/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.AttributeDefinitionStructureChild;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.IReferencedStructureProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionKey;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectCustomization;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectType;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonBundleIcon;
import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;

final class AccessorDefinitionStructureChild
extends AttributeDefinitionStructureChild
implements IReferencedStructureProvider {
    private List<? extends IStructure> referencedStructures;

    public AccessorDefinitionStructureChild(IStructureObject parent, AccessorDefinition namedDefinition, IStructureChild.StructureChildKind kind) {
        super(parent, (AttributeDefinition)namedDefinition, kind);
    }

    @Override
    public void dispose() {
        this.referencedStructures = null;
        super.dispose();
    }

    public boolean isCollection() {
        return ((AccessorDefinition)this.getNamedDefinition()).isCollection();
    }

    @Override
    protected String getNamedDefinitionSourceTypeDescriptionLabel() {
        if (this.getStructureObjectType() == StructureObjectType.OPERATION_RETURN) {
            return super.getNamedDefinitionSourceTypeDescriptionLabel();
        }
        AccessorDefinition accessorDefinition = (AccessorDefinition)this.getNamedDefinition();
        StructureDefinition structureDefinition = accessorDefinition.getStructure();
        if (structureDefinition != null) {
            String sourceType = StructureUtil.getCollectionElementSourceType(this);
            if (sourceType == null || sourceType.indexOf(46) < 0) {
                sourceType = structureDefinition.getFullName();
            }
            if (sourceType != null) {
                return this.isCollection() ? NLS.bind((String)Messages.sourceTypeCollectionOf, (Object)sourceType) : sourceType;
            }
        }
        if (this.isCollection()) {
            return Messages.sourceTypeCollection;
        }
        return null;
    }

    @Override
    protected ImageManager.IImageData computeImageData() {
        switch (this.getStructureObjectType()) {
            case ACCESSOR: {
                if (this.isCollection()) break;
                return DTRTvCommonBundleIcon.ACCESSOR_ATTRIBUTE_SINGULAR;
            }
        }
        return super.computeImageData();
    }

    @Override
    public List<? extends StructureDefinition> getReferencedStructureDefinitions() {
        StructureDefinition collectionStructureDefinition;
        AccessorDefinition accessorDefinition = (AccessorDefinition)this.getNamedDefinition();
        StructureDefinition referencedStructureDefinition = StructureUtil.getStructureDefinition(accessorDefinition, false);
        StructureDefinition structureDefinition = collectionStructureDefinition = StructureObjectType.getStructureObjectType(this.getParent()) != StructureObjectType.CONSTRUCTOR ? StructureUtil.getStructureDefinition(accessorDefinition, true) : null;
        if (referencedStructureDefinition != null || collectionStructureDefinition != null) {
            if (NamedDefinitionKey.shallowEquals((NamedDefinition)referencedStructureDefinition, (NamedDefinition)collectionStructureDefinition)) {
                collectionStructureDefinition = null;
            }
            if (referencedStructureDefinition != null && collectionStructureDefinition != null) {
                return Arrays.asList(referencedStructureDefinition, collectionStructureDefinition);
            }
            if (referencedStructureDefinition == null) {
                referencedStructureDefinition = collectionStructureDefinition;
            }
            return Collections.singletonList(referencedStructureDefinition);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isReferencedStructuresInitialzed() {
        return this.referencedStructures != null;
    }

    @Override
    public List<? extends IStructure> getReferencedStructures() {
        if (this.referencedStructures == null) {
            List<? extends StructureDefinition> referencedStructureDefinitions = this.getReferencedStructureDefinitions();
            if (!referencedStructureDefinitions.isEmpty()) {
                IStructure structure = DTRTObjectUtil.getStructure((IStructureObject)this);
                StructureProvider structureProvider = this.getStructureProvider();
                ArrayList<IStructure> list = new ArrayList<IStructure>(referencedStructureDefinitions.size());
                for (StructureDefinition structureDefinition : referencedStructureDefinitions) {
                    IStructure referencedStructure = StructureUtil.addStructureDefinition(list, structureProvider, structureDefinition);
                    structureProvider.handleReferencedStructure(structure, referencedStructure);
                }
                this.referencedStructures = DTRTUtil.toUnmodifiablePrunedList(list);
            } else {
                this.referencedStructures = Collections.emptyList();
            }
        }
        return this.referencedStructures;
    }

    @Override
    public boolean canCustomize() {
        return false;
    }

    @Override
    public StructureObjectCustomization getCustomization() {
        return null;
    }

    @Override
    public boolean isCustomizationFile(IFile file) {
        return false;
    }
}

