/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.adf.model.adapter.bean.annotation.AccessModeType;
import oracle.adf.model.adapter.bean.annotation.Properties;
import oracle.adf.model.adapter.bean.annotation.Property;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.jdt.AnnotationMemberValue;
import oracle.eclipse.tools.adf.dtrt.jdt.IMemberFilter;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.JDTUtil;
import oracle.eclipse.tools.adf.dtrt.jdt.MemberFilterUtil;
import oracle.eclipse.tools.adf.dtrt.jdt.TypeInfo;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.JavaUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.ClassEngine;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.FieldInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.JavaAnnotation;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.JavaClass;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.JavaManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.MethodInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.PrimitiveType;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;

final class Project
extends JavaManager {
    private static final IMemberFilter[] METHOD_INFO_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_OBJECT_MEMBERS, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, MemberFilterUtil.EXCLUDE_CONSTRUCTORS, MemberFilterUtil.INCLUDE_ALL};
    private static final IMemberFilter[] CONSTRUCTOR_INFO_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_CONSTRUCTORS, MemberFilterUtil.PUBLIC};
    private static final String VOID = Void.TYPE.getName();
    private IJavaProject javaProject;
    private IDTRTManager manager;

    public static JavaManager getJavaManager(Project project) {
        return project;
    }

    @Override
    public JavaClass getClass(String typeName) {
        PrimitiveType primitiveType = PrimitiveType.getPrimitiveType(TypeInfo.toClassName((String)typeName));
        if (primitiveType != null) {
            return primitiveType;
        }
        IType type = this.getType(typeName);
        return type != null ? new ClassEngine(this, typeName) : null;
    }

    static boolean isPrimitive(String typeName) {
        Class cls = JavaUtil.getPrimitiveOrVoidType((String)typeName);
        return cls != null && cls.isPrimitive();
    }

    static boolean isVoid(String typeName) {
        return typeName == null || Void.TYPE.getName().equals(typeName);
    }

    Project(IDTRTManager manager, IJavaProject javaProject) throws Exception {
        this.manager = manager;
        this.javaProject = javaProject;
    }

    void dispose() {
    }

    private ITypeHelper getTypeHelper() {
        return this.manager.getTypeHelper();
    }

    private IType getType(String typeName) {
        String className = TypeInfo.toClassName((String)typeName);
        if (JavaUtil.getPrimitiveOrVoidType((String)className) == null) {
            try {
                IType type = this.getTypeHelper().findType(this.javaProject, className);
                if (type != null) {
                    return type;
                }
            }
            catch (CoreException e) {
                throw new RuntimeException("Unable to locate " + typeName, e);
            }
        }
        return null;
    }

    FieldInfo createSyntheticField(MethodInfo getterOrSetterMethodInfo, String fieldName, String type) {
        return new FieldInfo(null, getterOrSetterMethodInfo.declaringClassName, fieldName, type, 2);
    }

    FieldInfo getFieldInfo(String typeName, String fieldName) {
        IType type = this.getType(typeName);
        if (type != null) {
            String key = "jdev1.Project.getFieldInfo(String, String)" + fieldName;
            Object value = this.manager.getCachedValue(type, key);
            if (value instanceof FieldInfo) {
                return (FieldInfo)value;
            }
            try {
                List fields = this.getTypeHelper().getFields(type, true, new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder(true).findByName(fieldName)});
                if (!fields.isEmpty()) {
                    IField field = (IField)fields.get(0);
                    TypeInfo typeInfo = this.getTypeHelper().getTypeInfo(field);
                    FieldInfo fieldInfo = new FieldInfo(field, field.getDeclaringType().getFullyQualifiedName(), field.getElementName(), typeInfo.getSourceName(), field.getFlags());
                    return this.manager.cacheValue(type, key, fieldInfo);
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    MethodInfo[] getMethodInfos(String typeName) {
        IType type = this.getType(typeName);
        if (type != null) {
            String key = "jdev1.Project.getMethodInfos(String)";
            Object value = this.manager.getCachedValue(type, key);
            if (value instanceof MethodInfo[]) {
                return (MethodInfo[])value;
            }
            try {
                List methods = this.getTypeHelper().getMethods(type, true, METHOD_INFO_FILTER);
                if (!methods.isEmpty()) {
                    ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>(methods.size());
                    for (IMethod method : methods) {
                        MethodInfo methodInfo = new MethodInfo(this, method, method.getDeclaringType().getFullyQualifiedName(), method.getElementName(), this.adjustMethodReturnType(this.getTypeHelper().getTypeInfo(method).getSourceName()), method.getFlags(), this.getParameters(method));
                        methodInfos.add(methodInfo);
                    }
                    return this.manager.cacheValue(type, key, methodInfos.toArray(new MethodInfo[methodInfos.size()]));
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return new MethodInfo[0];
    }

    MethodInfo[] getConstructorInfos(String typeName) {
        IType type = this.getType(typeName);
        try {
            if (type != null && type.isClass()) {
                String key = "jdev1.Project.getConstructorInfos(String)";
                Object value = this.manager.getCachedValue(type, key);
                if (value instanceof MethodInfo[]) {
                    return (MethodInfo[])value;
                }
                List methods = this.getTypeHelper().getMethods(type, false, CONSTRUCTOR_INFO_FILTER);
                if (!methods.isEmpty()) {
                    ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>(methods.size());
                    for (IMethod method : methods) {
                        MethodInfo methodInfo = new MethodInfo(this, method, method.getDeclaringType().getFullyQualifiedName(), method.getElementName(), VOID, method.getFlags(), this.getParameters(method));
                        methodInfos.add(methodInfo);
                    }
                    return this.manager.cacheValue(type, key, methodInfos.toArray(new MethodInfo[methodInfos.size()]));
                }
                MethodInfo methodInfo = new MethodInfo(null, this, typeName, JavaUtil.toSimpleName((String)TypeInfo.toClassName((String)typeName)), VOID, 1, null);
                return this.manager.cacheValue(type, key, new MethodInfo[]{methodInfo});
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return new MethodInfo[0];
    }

    private List<List<String>> getParameters(IMethod method) throws CoreException {
        ArrayList<List<String>> parameters;
        ILocalVariable[] jdtParameters = method.getParameters();
        if (jdtParameters.length > 0) {
            parameters = new ArrayList<List<String>>(jdtParameters.length);
            ILocalVariable[] iLocalVariableArray = jdtParameters;
            int n = jdtParameters.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalVariable jdtParameter = iLocalVariableArray[n2];
                TypeInfo parameterTypeInfo = this.getTypeHelper().getTypeInfo(jdtParameter);
                parameters.add(Arrays.asList(parameterTypeInfo.getSourceName(), jdtParameter.getElementName()));
                ++n2;
            }
        } else {
            parameters = null;
        }
        return parameters;
    }

    private String adjustMethodReturnType(String typeName) {
        return Project.isVoid(typeName) ? VOID : typeName;
    }

    boolean isInterface(String typeName) {
        IType type = this.getType(typeName);
        try {
            return type != null && type.isInterface();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEnum(String typeName) {
        IType type = this.getType(typeName);
        try {
            return type != null && type.isEnum();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    Object getTypeParameter(String typeName, String typeParameterName) {
        IType type;
        if (!DTRTUtil.isEmpty((String)typeParameterName) && (type = this.getType(typeName)) != null) {
            String key = "jdev1.Project.getTypeParameter(String, String)" + typeParameterName;
            Object value = this.manager.getCachedValue(type, key);
            if (value != null) {
                return value;
            }
            try {
                ITypeParameter[] iTypeParameterArray = type.getTypeParameters();
                int n = iTypeParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeParameter typeParameter = iTypeParameterArray[n2];
                    if (typeParameterName.equals(typeParameter.getElementName())) {
                        return this.manager.cacheValue(type, key, typeParameter);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    boolean isCollection(String typeName) {
        IType type = this.getType(typeName);
        try {
            return this.getTypeHelper().isCollectionOrMap(type);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    boolean isArray(String typeName) {
        return TypeInfo.sourceNameNumberOfArrayDimensions((String)typeName) > 0;
    }

    boolean isAssignableFrom(String typeName1, String typeName2) {
        if (typeName1 == null || typeName2 == null) {
            return false;
        }
        if (typeName1.equals(typeName2) || TypeInfo.toClassName((String)typeName1).equals(TypeInfo.toClassName((String)typeName2))) {
            return true;
        }
        try {
            return this.getTypeHelper().isAssignableFrom(this.getType(typeName1), this.getType(typeName2));
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    Property getPropertyAnnotation(FieldInfo fieldInfo) {
        return this.createPropertyHelper(this.doFindAnnotation(fieldInfo, Property.class.getName()));
    }

    Properties getPropertiesAnnotation(FieldInfo fieldInfo) {
        IAnnotation annotation = this.doFindAnnotation(fieldInfo, Properties.class.getName());
        if (annotation != null) {
            try {
                ArrayList<PropertyHelper> propertyHelpers = new ArrayList<PropertyHelper>();
                AnnotationMemberValue annotationMemberValue = this.getTypeHelper().getAnnotationMemberValue(annotation, "type");
                if (annotationMemberValue != null) {
                    Object[] objectArray = annotationMemberValue.getRawValues();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PropertyHelper propertyHelper;
                        Object value = objectArray[n2];
                        PropertyHelper propertyHelper2 = propertyHelper = value instanceof IAnnotation ? this.createPropertyHelper((IAnnotation)value) : null;
                        if (propertyHelper == null) {
                            propertyHelpers.clear();
                            break;
                        }
                        propertyHelpers.add(propertyHelper);
                        ++n2;
                    }
                }
                PropertiesHelper propertiesHelper = new PropertiesHelper();
                propertiesHelper.setProperty(propertyHelpers.toArray(new PropertyHelper[propertyHelpers.size()]));
                return propertiesHelper;
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private PropertyHelper createPropertyHelper(IAnnotation annotation) {
        if (annotation != null) {
            try {
                IMemberValuePair memberValuePair;
                String value;
                IMemberValuePair memberValuePair2 = JDTUtil.findMemberValuePair((IAnnotation)annotation, (String)"value");
                String name = memberValuePair2 != null && memberValuePair2.getValue() instanceof String ? (String)memberValuePair2.getValue() : null;
                if (name != null && (value = (memberValuePair = JDTUtil.findMemberValuePair((IAnnotation)annotation, (String)"value")) != null && memberValuePair.getValue() instanceof String ? (String)memberValuePair.getValue() : null) != null) {
                    return new PropertyHelper(name, value);
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    AccessModeType getAccessModeType(FieldInfo fieldInfo) {
        try {
            IAnnotation annotation = this.doFindAnnotation(fieldInfo, "AccessMode");
            IMemberValuePair memberValuePair = JDTUtil.findMemberValuePair((IAnnotation)annotation, (String)"type");
            if (memberValuePair != null) {
                String stringValue;
                AccessModeType accessModeType;
                Object value = memberValuePair.getValue();
                if (value instanceof AccessModeType) {
                    return (AccessModeType)value;
                }
                if (value instanceof String && (accessModeType = AccessModeType.valueOf((String)(stringValue = JavaUtil.toSimpleName((String)((String)value))))) != null) {
                    return accessModeType;
                }
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    Object findAnnotation(FieldInfo fieldInfo, String annotationName) {
        return fieldInfo != null ? this.doFindAnnotation(fieldInfo, annotationName) : null;
    }

    private IAnnotation doFindAnnotation(FieldInfo fieldInfo, String annotationName) {
        Object javaMember = fieldInfo.getJavaMember();
        try {
            return javaMember instanceof IAnnotatable ? this.getTypeHelper().getAnnotation((IAnnotatable)javaMember, true, annotationName) : null;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    JavaAnnotation getJavaAnnotation(String typeName, JavaClass annotationClass) {
        IType type;
        if (annotationClass != null && (type = this.getType(typeName)) != null) {
            String annotationClassName = ((ClassEngine)annotationClass).getClassName();
            String key = "jdev1.Project.getJavaAnnotation(String, JavaClass)" + annotationClassName;
            Object value = this.manager.getCachedValue(type, key);
            if (value instanceof JavaAnnotation) {
                return (JavaAnnotation)value;
            }
            try {
                IAnnotation annotation = this.getTypeHelper().getAnnotation((IAnnotatable)type, true, annotationClassName);
                if (annotation != null) {
                    return this.manager.cacheValue(type, key, new JavaAnnotation(this, annotation));
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    Collection<JavaAnnotation> getJavaAnnotations(String typeName) {
        IType type = this.getType(typeName);
        if (type != null) {
            String key = "jdev1.Project.getJavaAnnotations(String)";
            Object value = this.manager.getCachedValue(type, key);
            if (value instanceof Collection) {
                return (Collection)value;
            }
            try {
                IAnnotation[] annotations = type.getAnnotations();
                if (annotations.length > 0) {
                    ArrayList<JavaAnnotation> javaAnnotations = new ArrayList<JavaAnnotation>(annotations.length);
                    IAnnotation[] iAnnotationArray = annotations;
                    int n = annotations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAnnotation annotation = iAnnotationArray[n2];
                        javaAnnotations.add(new JavaAnnotation(this, annotation));
                        ++n2;
                    }
                    return this.manager.cacheValue(type, key, javaAnnotations);
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    String getAnnotationFullyQualifiedName(Object annotationObject) {
        IAnnotation annotation = (IAnnotation)annotationObject;
        try {
            IType annotationType = this.getTypeHelper().getAnnotationType(annotation);
            if (annotationType != null) {
                return annotationType.getFullyQualifiedName();
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException(String.format("Unable to locate the annotation '%s' used by '%s' (%s)", annotation.getElementName(), annotation.getParent().getElementName(), annotation.getParent().getClass().getName()));
    }

    Object getAnnotationAttributeValue(Object annotationObject, String attrName) {
        IAnnotation annotation = (IAnnotation)annotationObject;
        try {
            AnnotationMemberValue annotationMemberValue = this.getTypeHelper().getAnnotationMemberValue(annotation, attrName);
            return this.toValue(annotationMemberValue);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    Map<String, ?> getJavaAnnotationAttributeValueMap(Object annotationObject) {
        IAnnotation annotation = (IAnnotation)annotationObject;
        try {
            Collection annotationMemberValues = this.getTypeHelper().getAnnotationMemberValues(annotation);
            if (!annotationMemberValues.isEmpty()) {
                HashMap<String, Object> map = new HashMap<String, Object>(annotationMemberValues.size());
                for (AnnotationMemberValue annotationMemberValue : annotationMemberValues) {
                    Object value = this.toValue(annotationMemberValue);
                    if (value == null) continue;
                    map.put(annotationMemberValue.getMemberName(), value);
                }
                if (!map.isEmpty()) {
                    return Collections.unmodifiableMap(map);
                }
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return Collections.emptyMap();
    }

    StructureDefinition loadStructure(String className) {
        IType type = this.getType(className);
        if (type != null) {
            try {
                return BeanDataControlProvider.loadStructureDef(this.manager, this.getType(className));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private Object toValue(AnnotationMemberValue annotationMemberValue) {
        if (annotationMemberValue != null && annotationMemberValue.getValues().length > 0) {
            if (annotationMemberValue.getValueKind() == AnnotationMemberValue.ValueKind.QUALIFIED_NAME || annotationMemberValue.getValueKind() == AnnotationMemberValue.ValueKind.SIMPLE_NAME) {
                throw new UnsupportedOperationException("We need to support JavaField");
            }
            Object[] array = this.toValue(annotationMemberValue.getValues());
            return array.length == 0 ? null : (array.length == 1 && !annotationMemberValue.isMultiValue() ? array[0] : array);
        }
        return null;
    }

    private Object[] toValue(Object[] values) {
        ArrayList<Object> list = new ArrayList<Object>(values.length);
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof IAnnotation) {
                list.add(new JavaAnnotation(this, value));
            } else if (value instanceof IType) {
                list.add(this.getClass(((IType)value).getFullyQualifiedName()));
            } else if (value instanceof Object[]) {
                list.add(this.toValue((Object[])value));
            } else {
                list.add(value);
            }
            ++n2;
        }
        return list.toArray();
    }

    private static class PropertiesHelper
    implements Properties {
        private Property[] properties;

        private PropertiesHelper() {
        }

        public Property[] value() {
            return this.properties;
        }

        public void setProperty(Property[] prop) {
            this.properties = prop;
        }

        public Class<? extends Annotation> annotationType() {
            return null;
        }
    }

    private static class PropertyHelper
    implements Property {
        private String _name;
        private String _value;

        public PropertyHelper(String name, String value) {
            this._name = name;
            this._value = value;
        }

        public String name() {
            return this._name;
        }

        public String value() {
            return this._value;
        }

        public String resId() {
            return null;
        }

        public Class<? extends Annotation> annotationType() {
            return Property.class;
        }
    }
}

