/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adfdt.model.datacontrols.JUDTAdapterDataControl;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.AbstractBeanDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanDCDefinitionLoader;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanDCStructureDef;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.MethodInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.Project;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.PDefViewObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.ViewAttribute;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.ViewAttributeDefinition;
import oracle.eclipse.tools.common.util.Pair;
import org.eclipse.jdt.core.IType;

public final class BeanDataControlProvider {
    private static final IProviderInfo BASIC_PROVIDER_INFO = new IProviderInfo(){

        @Override
        public boolean isRecursiveBeanBuild() {
            return false;
        }

        @Override
        public boolean isGenerateCollectionOperations() {
            return true;
        }

        @Override
        public boolean ignoreMethod(String name, String returnType) {
            return false;
        }

        @Override
        public Collection<String> getIgnoredClassNames() {
            return Collections.emptyList();
        }
    };

    private BeanDataControlProvider() {
    }

    public static StructureDef loadStructureDef(IDTRTManager manager, IType type) throws Exception {
        return BeanDataControlProvider.loadStructureDef(manager, null, type, BASIC_PROVIDER_INFO);
    }

    public static StructureDef loadStructureDef(IDTRTManager manager, JUDTAdapterDataControl dataControl, IType type, IProviderInfo providerInfo) throws Exception {
        List<? extends ViewAttribute> viewAttributes;
        PDefViewObject viewObject;
        String viewObjectFullName;
        Project project = new Project(manager, type.getJavaProject());
        BeanDCStructureDefProvider provider = new BeanDCStructureDefProvider(providerInfo);
        StructureDefinition structureDefinition = provider.buildStructure(project, type.getFullyQualifiedName(), true);
        project.dispose();
        StructureDef structureDef = (StructureDef)structureDefinition;
        if (dataControl != null) {
            structureDef = new BeanDCStructureDef(project, dataControl, structureDef);
        }
        if ((viewObjectFullName = manager.computeViewObjectFullName(structureDef.getFullName())) != null && (viewObject = manager.getViewObject(viewObjectFullName, false)) != null && !(viewAttributes = viewObject.getExtrinsicAttributes()).isEmpty()) {
            structureDef.getAttributeDefinitions();
            for (ViewAttribute viewAttribute : viewAttributes) {
                ViewAttributeDefinition.createChildViewAttributeDefinition((StructureDefinition)structureDef, viewAttribute);
            }
        }
        return structureDef;
    }

    public static Pair<StructureDefinition, List<String>> buildStructure(IDTRTManager manager, IType type, IProviderInfo providerInfo) throws Exception {
        Project project = new Project(manager, type.getJavaProject());
        DataControlProvider provider = new DataControlProvider(providerInfo);
        provider.setDefinitionClass(type.getFullyQualifiedName());
        StructureDefinition structureDefinition = provider.buildStructure(project, type.getFullyQualifiedName(), true);
        project.dispose();
        return new Pair((Object)structureDefinition, provider.getCreatableTypes());
    }

    public static DefinitionContainer getCriteriaDefinitions(StructureDefinition def) {
        return BeanDCDefinitionLoader.getCriteriaDefinitions(def);
    }

    private static class BeanDCStructureDefProvider
    extends DataControlProvider {
        public BeanDCStructureDefProvider(IProviderInfo providerInfo) {
            super(providerInfo);
        }

        @Override
        protected BeanDCStructureDef createStructureDef(Project project, String className) {
            return new BeanDCStructureDef(project, className);
        }
    }

    private static class DataControlProvider
    extends AbstractBeanDataControlProvider {
        private IProviderInfo providerInfo;

        public DataControlProvider(IProviderInfo providerInfo) {
            this.providerInfo = providerInfo;
            for (String className : providerInfo.getIgnoredClassNames()) {
                this.setIgnoredClass(className);
            }
            this.setGenerateCollectionOperations(providerInfo.isGenerateCollectionOperations());
            this.setRecursive(providerInfo.isRecursiveBeanBuild());
        }

        @Override
        protected boolean ignoredMethod(MethodInfo mi) {
            return super.ignoredMethod(mi) || this.providerInfo.ignoreMethod(mi.getName(), mi.type);
        }
    }

    public static interface IProviderInfo {
        public boolean ignoreMethod(String var1, String var2);

        public Collection<String> getIgnoredClassNames();

        public boolean isGenerateCollectionOperations();

        public boolean isRecursiveBeanBuild();
    }
}

