/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adfdt.model.datacontrols.JUDTAdapterDataControl;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.EditableStructureDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.binding.meta.StructureDefinitionListener;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanDCDefinitionLoader;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanDCHelper;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.Project;

class BeanDCStructureDef
extends StructureDef
implements EditableStructureDefinition,
StructureDefinitionListener {
    private Project _project;
    private String _bindPath;
    private StructureDefinition _definition;
    JUDTAdapterDataControl _adapterdc;
    private boolean _loadedConstructor = false;
    private boolean _loadedAttr = false;
    private boolean _loadedAcc = false;
    private boolean _loadedOper = false;
    private boolean _loadedCriteria = false;
    private boolean _supportsTransaction = false;
    private Set<StructureDefinitionListener> _structureListeners = Collections.newSetFromMap(new WeakHashMap());

    public BeanDCStructureDef(Project project, String className) {
        super(className);
        this._project = project;
    }

    public BeanDCStructureDef(Project project, JUDTAdapterDataControl adapterdc, StructureDef dcDef) {
        this(project, dcDef.getFullName());
        this._adapterdc = adapterdc;
        this._definition = dcDef;
        this._bindPath = adapterdc.getNativeDataControlDefinition().getFullName();
        this._supportsTransaction = adapterdc.getBooleanTrueAttribute("SupportsTransactions");
        ((BeanDCStructureDef)dcDef)._adapterdc = adapterdc;
    }

    public void setBindPath(String bindPath) {
        this._bindPath = bindPath;
    }

    public Project getProject() {
        return this._project;
    }

    public DefinitionContainer getAttributeDefinitions() {
        if (!this.hasAttribute()) {
            this.loadAttributeDefinitions();
        }
        return super.getAttributeDefinitions();
    }

    public DefinitionContainer getOperationDefinitions() {
        if (!this.hasOperation()) {
            this.loadOperationDefinitions();
        }
        return super.getOperationDefinitions();
    }

    public DefinitionContainer getAccessorDefinitions() {
        if (!this.hasAccessor()) {
            this.loadAccessorDefinitions();
        }
        return super.getAccessorDefinitions();
    }

    public DefinitionContainer getConstructorOperationDefinitions() {
        if (!this.hasConstructor()) {
            this.loadConstructorDefinitions();
        }
        return super.getConstructorOperationDefinitions();
    }

    public DefinitionContainer getCriteriaDefinitions() {
        if (!this.hasCriteria()) {
            this.loadCriteriaDefinitions();
        }
        return super.getCriteriaDefinitions();
    }

    private void loadAttributeDefinitions() {
        if (!this._loadedAttr && this.loadStructure().hasAttribute()) {
            BeanDCDefinitionLoader.addAttributeDefs(this, this._definition, this._bindPath);
            this._loadedAttr = true;
        }
    }

    private void loadAccessorDefinitions() {
        if (!this._loadedAcc && this.loadStructure().hasAccessor()) {
            BeanDCDefinitionLoader.addAccessorDefs(this, this._definition, this._bindPath);
            this._loadedAcc = true;
        }
    }

    private void loadOperationDefinitions() {
        if (!this._loadedOper) {
            if (this.loadStructure().hasOperation()) {
                BeanDCDefinitionLoader.addMethodsDefs(this, this._definition, this._bindPath);
            }
            if (this._supportsTransaction) {
                BeanDCDefinitionLoader.addTransactionOperations(this);
            }
            this._loadedOper = true;
        }
    }

    private void loadConstructorDefinitions() {
        if (!this._loadedConstructor && this.loadStructure().hasConstructor()) {
            BeanDCDefinitionLoader.addConstructors(this, this._definition, this._bindPath);
            this._loadedConstructor = true;
        }
    }

    private void loadCriteriaDefinitions() {
        if (!this._loadedCriteria && this.loadStructure().hasCriteria()) {
            BeanDCDefinitionLoader.addCriteriaDefinitions(this, this._definition);
            this._loadedCriteria = true;
        }
    }

    private BeanDCStructureDef loadStructure() {
        if (this._project != null && this._definition == null) {
            String className = this.getFullName();
            this._definition = this._project.loadStructure(className);
            ((BeanDCStructureDef)this._definition)._adapterdc = this._adapterdc;
            BeanDCHelper.addVisitDefinition(this._adapterdc, (StructureDefinition)this);
        }
        return (BeanDCStructureDef)this._definition;
    }

    public boolean hasConstructor() {
        return super.getConstructorOperationDefinitions() != null && (super.getConstructorOperationDefinitions() == null || !super.getConstructorOperationDefinitions().isEmpty());
    }

    public boolean hasAttribute() {
        return super.getAttributeDefinitions() != null && (super.getAttributeDefinitions() == null || !super.getAttributeDefinitions().isEmpty());
    }

    public boolean hasAccessor() {
        return super.getAccessorDefinitions() != null && (super.getAccessorDefinitions() == null || !super.getAccessorDefinitions().isEmpty());
    }

    public boolean hasOperation() {
        return super.getOperationDefinitions() != null && (super.getOperationDefinitions() == null || !super.getOperationDefinitions().isEmpty());
    }

    public boolean hasCriteria() {
        return super.getCriteriaDefinitions() != null && (super.getCriteriaDefinitions() == null || !super.getCriteriaDefinitions().isEmpty());
    }

    public void addListener(StructureDefinitionListener listener) {
        this._structureListeners.add(listener);
    }

    public void removeListener(StructureDefinitionListener listener) {
        this._structureListeners.remove(listener);
    }

    public void structureChanged() {
        this.clearLoadedDefinitions();
        this.notifyStructureChanged();
    }

    protected void notifyStructureChanged() {
        for (StructureDefinitionListener listener : this._structureListeners) {
            listener.structureChanged();
        }
    }

    private void clearLoadedDefinitions() {
        this._loadedConstructor = false;
        this._loadedAttr = false;
        this._loadedAcc = false;
        this._loadedOper = false;
        this._loadedCriteria = false;
        this._definition = null;
        this.clearMetadata();
    }
}

