/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1;

import java.util.Iterator;
import java.util.Map;
import oracle.adf.model.adapter.DTContext;
import oracle.adf.model.adapter.dataformat.AccessorDef;
import oracle.adf.model.adapter.dataformat.AttributeDef;
import oracle.adf.model.adapter.dataformat.MethodDef;
import oracle.adf.model.adapter.dataformat.MethodReturnDef;
import oracle.adf.model.adapter.dataformat.ParamDef;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adf.share.logging.ADFLogger;
import oracle.adfinternal.model.adapter.bean.BeanDCUtils;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.ArrayListDefinitionContainer;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.OperationReturnDefinition;
import oracle.binding.meta.ParameterDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanCriteria;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanDCStructureDef;

class BeanDCDefinitionLoader {
    private static ADFLogger mLogger = DTContext.getInstance().getLogger();

    BeanDCDefinitionLoader() {
    }

    public static void addAttributeDefs(BeanDCStructureDef dcDef, StructureDefinition def, String bindPath) {
        mLogger.fine("Adding attributes.");
        for (AttributeDefinition attrDef : def.getAttributeDefinitions()) {
            AttributeDef thisAttr = new AttributeDef(attrDef.getName(), (StructureDefinition)dcDef, attrDef.getJavaTypeString(), attrDef.isReadOnly(), attrDef.isKey());
            thisAttr.setSourceTypeString(attrDef.getSourceTypeString());
            byte updateableFlag = attrDef.isReadOnly() ? (byte)0 : (attrDef.isKey() ? (byte)1 : 2);
            thisAttr.setProperty("UPDATEABLE_FLAG", (Object)new Byte(updateableFlag));
            if (bindPath != null) {
                thisAttr.setBindPath(bindPath);
            }
            thisAttr.addProperties((Map)attrDef.getProperties());
            dcDef.addAttribute((AttributeDefinition)thisAttr);
        }
    }

    public static void addAccessorDefs(BeanDCStructureDef dcDef, StructureDefinition def, String bindPath) {
        mLogger.fine("Adding accessors.");
        for (AccessorDef accDef : def.getAccessorDefinitions()) {
            AccessorDef thisAccDef = null;
            if (accDef.getStructure() != null) {
                StructureDefinition accStructDef = accDef.getStructure();
                if (accDef.isCollection() && accDef.isScalarCollection()) {
                    String elementType = BeanDCDefinitionLoader.getAttributeDef(accStructDef).getJavaTypeString();
                    thisAccDef = new AccessorDef(accDef.getName(), (StructureDefinition)dcDef, accDef.getJavaTypeString(), "element", BeanDCUtils.getType((String)elementType));
                    accStructDef = thisAccDef.getStructure();
                } else {
                    thisAccDef = new AccessorDef(accDef.getName(), (StructureDefinition)dcDef, accStructDef, accDef.isCollection());
                    thisAccDef.setSourceTypeString(accDef.getSourceTypeString());
                }
                ((StructureDef)accStructDef).setParent((Definition)thisAccDef);
                if (accStructDef instanceof BeanDCStructureDef && thisAccDef.getFullName() != null) {
                    ((BeanDCStructureDef)accStructDef).setBindPath(thisAccDef.getFullName());
                }
                BeanDCDefinitionLoader.setAdapterDC(dcDef, accStructDef);
            } else {
                thisAccDef = new AccessorDef(accDef.getName(), (StructureDefinition)dcDef, accDef.isCollection());
            }
            StructureDef collectionStructure = (StructureDef)accDef.getCollectionStructure();
            if (collectionStructure != null) {
                collectionStructure.setParent((Definition)thisAccDef);
                thisAccDef.setCollectionStructure((StructureDefinition)collectionStructure);
            }
            thisAccDef.addProperties((Map)accDef.getProperties());
            thisAccDef.setReadOnly(accDef.isReadOnly());
            accDef = thisAccDef;
            if (bindPath != null) {
                accDef.setBindPath(bindPath);
            }
            dcDef.addAccessor((AccessorDefinition)accDef);
        }
    }

    public static void addMethodsDefs(BeanDCStructureDef dcDef, StructureDefinition def, String bindPath) {
        mLogger.fine("Adding methods.");
        for (MethodDef methodDef : def.getOperationDefinitions()) {
            if (methodDef.getOperationReturnType() == null) continue;
            MethodDef thisMethodDef = null;
            OperationReturnDefinition oprDef = methodDef.getOperationReturnType();
            if (oprDef instanceof MethodReturnDef) {
                StructureDef collectionStructure;
                MethodReturnDef thisReturnDef = null;
                MethodReturnDef returnDef = (MethodReturnDef)oprDef;
                StructureDefinition retStructure = returnDef.getStructure();
                if (retStructure != null && retStructure instanceof BeanDCStructureDef) {
                    thisMethodDef = new MethodDef(methodDef.getName(), (StructureDefinition)dcDef, methodDef.getOperationReturnType().getJavaTypeString());
                    String bindPath2 = String.valueOf(bindPath) + "." + methodDef.getName() + "." + "Return".toLowerCase();
                    thisReturnDef = new MethodReturnDef(retStructure.getName(), retStructure, (OperationDefinition)thisMethodDef, returnDef.isCollection());
                    ((BeanDCStructureDef)retStructure).setBindPath(bindPath2);
                    ((BeanDCStructureDef)retStructure).setParent((Definition)thisReturnDef);
                    BeanDCDefinitionLoader.setAdapterDC(dcDef, retStructure);
                } else if (returnDef.isScalarCollection()) {
                    String elementType = BeanDCDefinitionLoader.getAttributeDef(retStructure).getJavaTypeString();
                    thisMethodDef = new MethodDef(methodDef.getName(), (StructureDefinition)dcDef, methodDef.getOperationReturnType().getJavaTypeString());
                    thisReturnDef = new MethodReturnDef("Return".toLowerCase(), (OperationDefinition)thisMethodDef, returnDef.getJavaTypeString(), "element", BeanDCUtils.getType((String)elementType));
                } else {
                    thisMethodDef = returnDef.getJavaTypeString().equalsIgnoreCase("void") ? new MethodDef(methodDef.getName(), (StructureDefinition)dcDef) : new MethodDef(methodDef.getName(), (StructureDefinition)dcDef, returnDef.getJavaTypeString());
                }
                thisMethodDef.setReturnType(thisReturnDef);
                if (thisReturnDef != null && (collectionStructure = (StructureDef)returnDef.getCollectionStructure()) != null) {
                    collectionStructure.setParent((Definition)thisReturnDef);
                    thisMethodDef.setReturnCollectionStructure((StructureDefinition)collectionStructure);
                }
                BeanDCDefinitionLoader.addOperationParameters(thisMethodDef, methodDef);
            }
            if (bindPath != null) {
                thisMethodDef.setBindPath(bindPath);
            }
            dcDef.addMethod((OperationDefinition)thisMethodDef);
        }
    }

    public static void addConstructors(BeanDCStructureDef dcDef, StructureDefinition def, String bindPath) {
        mLogger.fine("Adding constructors.");
        for (MethodDef methodDef : def.getConstructorOperationDefinitions()) {
            if (methodDef.getOperationReturnType() != null) {
                MethodDef thisMethodDef = null;
                OperationReturnDefinition oprDef = methodDef.getOperationReturnType();
                if (oprDef instanceof MethodReturnDef) {
                    thisMethodDef = new MethodDef(methodDef.getName(), (StructureDefinition)dcDef, true);
                    MethodReturnDef thisReturnDef = null;
                    MethodReturnDef returnDef = (MethodReturnDef)oprDef;
                    StructureDefinition retStructure = returnDef.getStructure();
                    if (retStructure != null && retStructure instanceof BeanDCStructureDef) {
                        String bindPath2 = String.valueOf(bindPath) + "." + methodDef.getName() + "." + "Return".toLowerCase();
                        ((BeanDCStructureDef)retStructure).setBindPath(bindPath2);
                        for (AttributeDefinition attributeDefinition : retStructure.getAttributeDefinitions()) {
                            if (!(attributeDefinition instanceof AttributeDef)) continue;
                            AttributeDef thisAttr = (AttributeDef)attributeDefinition;
                            if (bindPath == null) continue;
                            thisAttr.setBindPath(bindPath2);
                        }
                        for (AccessorDef thisAcc : retStructure.getAccessorDefinitions()) {
                            if (bindPath == null) continue;
                            thisAcc.setBindPath(bindPath2);
                        }
                        thisReturnDef = new MethodReturnDef(retStructure.getName(), retStructure, (OperationDefinition)thisMethodDef, returnDef.isCollection());
                        ((BeanDCStructureDef)retStructure).setParent((Definition)thisReturnDef);
                        BeanDCDefinitionLoader.setAdapterDC(dcDef, retStructure);
                        thisMethodDef.setReturnType(thisReturnDef);
                        thisMethodDef.setReturnName(methodDef.getName());
                        thisMethodDef.setProperty("__SHOW_PARAMETERS__", (Object)"false");
                    }
                    BeanDCDefinitionLoader.addOperationParameters(thisMethodDef, methodDef);
                    methodDef = thisMethodDef;
                }
            }
            if (bindPath != null) {
                methodDef.setBindPath(bindPath);
            }
            dcDef.addConstructorMethod((OperationDefinition)methodDef);
        }
    }

    public static void addCriteriaDefinitions(BeanDCStructureDef dcDef, StructureDefinition def) {
    }

    public static void addTransactionOperations(StructureDef dcDef) {
        mLogger.fine("Adding default transaction operations.");
        BeanDCUtils.addTransactionalOperations((StructureDef)dcDef);
    }

    private static void addOperationParameters(MethodDef parent, MethodDef methodDef) {
        DefinitionContainer parameters = methodDef.getOperationParameters();
        if (parameters != null && !parameters.isEmpty()) {
            for (ParamDef paramDef : parameters) {
                StructureDefinition strDef = paramDef.getStructure();
                if (strDef instanceof BeanDCStructureDef) {
                    ((BeanDCStructureDef)strDef).setParent((Definition)parent);
                }
                paramDef.setParent((OperationDefinition)parent);
                parent.addParameter((ParameterDefinition)paramDef);
            }
        }
    }

    public static DefinitionContainer getCriteriaDefinitions(StructureDefinition def) {
        mLogger.fine("Get criteria definitions.");
        ArrayListDefinitionContainer criteria = new ArrayListDefinitionContainer();
        criteria.add((Object)BeanDCDefinitionLoader.createBeanCriteriaDef(def));
        return criteria;
    }

    public static BeanCriteria createBeanCriteriaDef(StructureDefinition def) {
        mLogger.fine("Create criteria definition.");
        return new BeanCriteria(def);
    }

    static AttributeDef getAttributeDef(StructureDefinition def) {
        Iterator iter = def.getAttributeDefinitions().iterator();
        if (iter.hasNext()) {
            return (AttributeDef)iter.next();
        }
        return null;
    }

    static void setAdapterDC(BeanDCStructureDef dcDef, StructureDefinition def) {
        if (def instanceof BeanDCStructureDef) {
            ((BeanDCStructureDef)def)._adapterdc = dcDef._adapterdc;
        }
    }
}

