/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.ui.provider.ISummaryProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.BaseWizardPage;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreationInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.Messages;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

class OptionsPage
extends BaseWizardPage
implements ISummaryProvider {
    private Combo accessModeCombo;
    private Button namedCriteriaButton;
    private Button generateMetadataButton;
    private StyledText accessModeDescription;
    private StyledText namedCriteriaDesc;

    @Override
    public void dispose() {
        this.accessModeCombo = null;
        this.accessModeDescription = null;
        this.namedCriteriaButton = null;
        this.namedCriteriaDesc = null;
        this.generateMetadataButton = null;
        super.dispose();
    }

    public OptionsPage(CreationInfo creationInfo) {
        super(creationInfo, OptionsPage.class.getSimpleName(), Messages.OptionsPage_title, null);
        this.setDescription(Messages.OptionsPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return new Point(this.getClientArea().width, this.getClientArea().height);
            }
        };
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(composite);
        DTRTUIUtil.applyGrabAllGridData((Control)composite);
        Composite accessModeComposite = new Composite(composite, 0);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)accessModeComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(accessModeComposite);
        Label accessModeLabel = new Label(accessModeComposite, 0);
        accessModeLabel.setText(Messages.OptionsPage_accessMode);
        accessModeLabel.setLayoutData((Object)new GridData(-1, 0x1000000, false, false));
        this.accessModeCombo = new Combo(accessModeComposite, 12);
        this.accessModeCombo.setLayoutData((Object)new GridData(-1, -1, false, false));
        this.accessModeDescription = new StyledText(composite, 66);
        GridData gd1 = DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.accessModeDescription);
        gd1.horizontalIndent = 20;
        gd1.heightHint = 3 * DTRTUIUtil.getFontHeight((Control)this.accessModeDescription);
        this.accessModeDescription.setBackground(composite.getBackground());
        this.namedCriteriaButton = new Button(composite, 32);
        this.namedCriteriaButton.setText(Messages.OptionsPage_namedCriteria);
        this.namedCriteriaDesc = new StyledText(composite, 66);
        this.namedCriteriaDesc.setBackground(composite.getBackground());
        GridData gd2 = DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.namedCriteriaDesc);
        gd2.horizontalIndent = 20;
        gd2.heightHint = 2 * DTRTUIUtil.getFontHeight((Control)this.namedCriteriaDesc);
        this.generateMetadataButton = new Button(composite, 32);
        this.generateMetadataButton.setText(Messages.OptionsPage_metadata);
        this.generateMetadataButton.setToolTipText(Messages.OptionsPage_metadata_tooltip);
        this.generateMetadataButton.setVisible(false);
        this.initializeControls();
        this.setPageComplete(true);
        this.setControl((Control)composite);
    }

    private void initializeControls() {
        this.namedCriteriaButton.setSelection(this.getCreationInfo().isNamedCritriaSettable());
        this.initializeAccessModeCombo();
        this.namedCriteriaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsPage.this.getCreationInfo().setQueryMethodSupported(OptionsPage.this.namedCriteriaButton.getSelection());
            }
        });
        this.generateMetadataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsPage.this.getCreationInfo().setGenerateMetadata(OptionsPage.this.generateMetadataButton.getSelection());
            }
        });
        this.updateNamedCriteriaButton();
    }

    private void initializeAccessModeCombo() {
        this.accessModeCombo.add(Messages.OptionsPage_noPaging);
        this.accessModeCombo.add(Messages.OptionsPage_scrollable);
        this.accessModeCombo.add(Messages.OptionsPage_rangePaging);
        this.accessModeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (OptionsPage.this.accessModeCombo.getSelectionIndex()) {
                    case 0: {
                        OptionsPage.this.getCreationInfo().setAccessMode((short)-1);
                        OptionsPage.this.accessModeDescription.setText("");
                        break;
                    }
                    case 1: {
                        OptionsPage.this.getCreationInfo().setAccessMode((short)1);
                        OptionsPage.this.accessModeDescription.setText(Messages.OptionsPage_scrollableDesc);
                        break;
                    }
                    case 2: {
                        OptionsPage.this.getCreationInfo().setAccessMode((short)4);
                        OptionsPage.this.accessModeDescription.setText(Messages.OptionsPage_rangePagingDesc);
                    }
                }
                OptionsPage.this.updateNamedCriteriaButton();
            }
        });
        this.accessModeCombo.select(1);
        this.accessModeDescription.setText(Messages.OptionsPage_scrollableDesc);
    }

    private void updateNamedCriteriaButton() {
        if (!this.getCreationInfo().isNamedCritriaSettable()) {
            this.namedCriteriaButton.setSelection(false);
            this.namedCriteriaButton.setEnabled(false);
            this.namedCriteriaDesc.setText(Messages.OptionsPage_namedCriteriaNotAvailable);
        } else if (this.accessModeCombo.getSelectionIndex() == 0) {
            this.namedCriteriaButton.setSelection(false);
            this.namedCriteriaButton.setEnabled(false);
            this.namedCriteriaDesc.setText(Messages.OptionsPage_namedCriteriaNeedsPaging);
        } else {
            this.namedCriteriaButton.setEnabled(true);
            this.namedCriteriaDesc.setText(Messages.OptionsPage_namedCriteriaAvailable);
        }
    }

    public List<String> getSummaries() {
        ArrayList<String> summaries = new ArrayList<String>();
        summaries.add("");
        summaries.add(Messages.OptionsPage_options_summary);
        summaries.add(NLS.bind((String)Messages.OptionsPage_accessMode_summary, (Object)this.accessModeCombo.getText()));
        summaries.add(NLS.bind((String)Messages.OptionsPage_namedCriteria_summary, (Object)this.getCreationInfo().isQueryMethodSupported()));
        if (this.getCreationInfo().isGenerateMetadata()) {
            summaries.add(Messages.OptionsPage_metadata_summary);
        }
        return summaries;
    }
}

