/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adfdt.model.ModelDesignTimeContext;
import oracle.adfdt.model.datacontrols.AdapterLazyStructure;
import oracle.adfdt.model.datacontrols.AdapterStructureDefinition;
import oracle.adfdt.model.datacontrols.JUDTAdapterDataControl;
import oracle.adfdt.model.datacontrols.JUDTAdapterDataControlDTHelperInterface;
import oracle.adfdt.model.objects.DataControl;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.StructureSourceFactory;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.DataControlType;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.DataControlUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.ISourceHandler;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IType;

class JUDTAdapterDataControlLoader
implements JUDTAdapterDataControlDTHelperInterface {
    public static void register() {
        JUDTAdapterDataControl.initalizeAdapterDCHelperInterface((JUDTAdapterDataControlDTHelperInterface)new JUDTAdapterDataControlLoader());
    }

    private JUDTAdapterDataControlLoader() {
    }

    public StructureDef loadStructure(JUDTAdapterDataControl adapterdc, String className) {
        IStructure.ITypeSource structureSource;
        IType type;
        IProject project = DataControlUtil.getProject((DataControl)adapterdc);
        try {
            IDTRTManager manager = DTRTvUtil.getManager((DataControl)adapterdc);
            type = manager.getTypeHelper().findType(project, className);
        }
        catch (Exception e) {
            DTRTvBundle.log(e);
            type = null;
        }
        if (type != null && (structureSource = StructureSourceFactory.createTypeSource((IType)type)) != null) {
            try {
                ISourceHandler handler = DataControlType.createHandlerForLoading((DataControl)adapterdc, (IStructure.IStructureSource)structureSource);
                if (handler != null) {
                    return handler.loadStructure(adapterdc);
                }
            }
            catch (RuntimeException e) {
                DTRTvBundle.log(e);
                throw e;
            }
            catch (Exception e) {
                DTRTvBundle.log(e);
                throw new RuntimeException(e);
            }
        }
        DTRTvBundle.log((IStatus)new Status(2, "oracle.eclipse.tools.adf.dtrt.v120102", "Unable to locate the structure for " + adapterdc + ", className " + className));
        return null;
    }

    public void addCreatableTypes(JUDTAdapterDataControl adapterdc, StructureDefinition structureDef) {
        throw new UnsupportedOperationException();
    }

    public DefinitionContainer getCriteriaDefinitions(StructureDefinition structureDef) {
        return this.hasCriteriaDefinition(structureDef) ? BeanDataControlProvider.getCriteriaDefinitions(structureDef) : null;
    }

    public void configureClientProject(Object dtContext, Object project, DataControl dc) {
        throw new UnsupportedOperationException();
    }

    private boolean hasCriteriaDefinition(StructureDefinition structureDefinition) {
        IDTRTManager manager;
        ModelDesignTimeContext context;
        Object object = structureDefinition instanceof AdapterStructureDefinition ? ((AdapterStructureDefinition)structureDefinition).getModelDesignTimeContext() : (context = structureDefinition instanceof AdapterLazyStructure ? ((AdapterLazyStructure)structureDefinition).getModelDesignTimeContext() : null);
        if (context instanceof IAdaptable && (manager = (IDTRTManager)DTRTUtil.getAdapter((IAdaptable)((IAdaptable)context), IDTRTManager.class)) != null) {
            try {
                IType type = manager.findType(structureDefinition.getFullName());
                if (type != null) {
                    return this.hasCriteriaDefinition(manager.getTypeHelper(), type);
                }
            }
            catch (CoreException e) {
                DTRTvBundle.log(e);
            }
        }
        return false;
    }

    private boolean hasCriteriaDefinition(ITypeHelper typeHelper, IType type) throws CoreException {
        if (typeHelper.getAnnotation((IAnnotatable)type, true, "javax.persistence.Entity") != null) {
            if (typeHelper.getAnnotation((IAnnotatable)type, true, "javax.persistence.NamedQueries") != null) {
                return true;
            }
            if (typeHelper.getAnnotation((IAnnotatable)type, true, "javax.persistence.NamedQuery") != null) {
                return true;
            }
        }
        return false;
    }
}

