/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import java.util.Iterator;
import java.util.List;
import oracle.adf.model.adapter.AbstractDefinition;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adfdt.model.datacontrols.JUDTAdapterDataControl;
import oracle.adfinternal.model.adapter.ejb.EjbDCDefinition;
import oracle.adfinternal.model.adapter.generic.DataControlStructure;
import oracle.eclipse.tools.adf.dtrt.context.command.IStructureCommand;
import oracle.eclipse.tools.adf.dtrt.jdt.AnnotationMemberValue;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreationInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.EJBSessionBeanSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.JavaHandler;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.Messages;
import oracle.xml.parser.v2.XMLDocument;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.ejb.SessionType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class EJBSessionBeanHandler
extends JavaHandler<EJBSessionBeanSourceInfo> {
    private static final String JE = "javax.ejb.";
    private static final String TRANSACTIONATTRIBUTE_S = "TransactionAttribute";
    private static final String TRANSACTIONATTRIBUTE = "javax.ejb.TransactionAttribute";
    private static final String TRANSACTIONATTRIBUTETYPE_S = "TransactionAttributeType";
    private static final String TRANSACTIONATTRIBUTETYPE_NOT_SUPPORTED_S = "TransactionAttributeType.NOT_SUPPORTED";
    private static final String TRANSACTIONATTRIBUTETYPE_NOT_SUPPORTED = "javax.ejb.TransactionAttributeType.NOT_SUPPORTED";
    private static final String TRANSACTIONATTRIBUTETYPE_REQUIRED_S = "TransactionAttributeType.REQUIRED";
    private static final String TRANSACTIONATTRIBUTETYPE_REQUIRED = "javax.ejb.TransactionAttributeType.REQUIRED";

    public EJBSessionBeanHandler(EJBSessionBeanSourceInfo sourceInfo) {
        super(sourceInfo);
    }

    @Override
    public void assertExecution(IStructureCommand command) throws Exception {
        DTRTUtil.assertTrue((((EJBSessionBeanSourceInfo)this.getSourceInfo()).getLocalInterfaceType() != null ? 1 : 0) != 0, (String)Messages.invalidLocalInterface);
        DTRTUtil.assertTrue((boolean)((EJBSessionBeanSourceInfo)this.getSourceInfo()).getSessionBeanType().getJavaProject().equals(((EJBSessionBeanSourceInfo)this.getSourceInfo()).getLocalInterfaceType().getJavaProject()), (String)Messages.localInterfaceNotInSameProject);
        super.assertExecution(command);
    }

    @Override
    protected void assertCreateCommandExecution() {
        String validationErrorMessage = EJBSessionBeanHandler.validateTypeAsDataControl(false, ((EJBSessionBeanSourceInfo)this.getSourceInfo()).getSessionBeanType());
        DTRTUtil.assertTrue((validationErrorMessage == null ? 1 : 0) != 0, (String)validationErrorMessage);
    }

    @Override
    public IDataControl createDataControl(CreateDataControlCommand command, IProgressMonitor monitor) throws Exception {
        return this.createDataControl(((EJBSessionBeanSourceInfo)this.getSourceInfo()).getLocalInterfaceType(), command, monitor);
    }

    @Override
    public StructureDef loadStructure(JUDTAdapterDataControl dataControl) throws Exception {
        return this.loadStructure(dataControl, ((EJBSessionBeanSourceInfo)this.getSourceInfo()).getLocalInterfaceType());
    }

    @Override
    protected IJavaProject getJavaProject() {
        return ((EJBSessionBeanSourceInfo)this.getSourceInfo()).getSessionBeanType().getJavaProject();
    }

    @Override
    protected Node getRuntimeSettings(ITypeHelper typeHelper, CreationInfo creationInfo, IType type) throws Exception {
        XMLDocument xmlDoc = new XMLDocument();
        Element metaData = xmlDoc.createElementNS("http://xmlns.oracle.com/adfm/adapter/ejb", "ejb-definition");
        this.assignAttr(metaData, "ejb-version", ((EJBSessionBeanSourceInfo)this.getSourceInfo()).getEJBVersion());
        this.assignAttr(metaData, "ejb-name", ((EJBSessionBeanSourceInfo)this.getSourceInfo()).getSessionBean().getEjbName());
        this.assignAttr(metaData, "ejb-type", "Session");
        this.assignAttr(metaData, "ejb-business-interface", type.getFullyQualifiedName());
        this.assignAttr(metaData, "ejb-interface-type", "local");
        this.supportsDataControlHandler(creationInfo, metaData);
        this.supportsAccessMode(creationInfo, metaData);
        this.assignAttr(metaData, "EagerPersist", Boolean.toString(this.supportsEagerPersist(typeHelper, ((EJBSessionBeanSourceInfo)this.getSourceInfo()).getSessionBean(), ((EJBSessionBeanSourceInfo)this.getSourceInfo()).getSessionBeanType())));
        metaData.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://xmlns.oracle.com/adfm/adapter/ejb");
        return metaData;
    }

    protected boolean supportsEagerPersist(ITypeHelper typeHelper, SessionBean sessionBean, IType sessionType) {
        if (sessionBean.getSessionType() == SessionType.STATEFUL_LITERAL) {
            try {
                List methods;
                Object valueObject;
                IAnnotation annotation = typeHelper.getAnnotation((IAnnotatable)sessionType, true, TRANSACTIONATTRIBUTE);
                if (annotation != null && (valueObject = this.getAnnotationMemberValue(typeHelper, annotation, "value", TRANSACTIONATTRIBUTETYPE_REQUIRED_S)) instanceof String && (TRANSACTIONATTRIBUTETYPE_NOT_SUPPORTED_S.equals(valueObject) || TRANSACTIONATTRIBUTETYPE_NOT_SUPPORTED.equals(valueObject)) && (methods = typeHelper.getMethods(sessionType, true, SUPPORTS_EAGER_PERSIST_FILTER)).size() == 2) {
                    IMethod commitMethod;
                    IMethod persistMethod;
                    Iterator iterator = methods.iterator();
                    IMethod firstMethod = (IMethod)iterator.next();
                    if (firstMethod.getElementName().equals("persistEntity")) {
                        persistMethod = firstMethod;
                        commitMethod = (IMethod)iterator.next();
                    } else {
                        commitMethod = firstMethod;
                        persistMethod = (IMethod)iterator.next();
                    }
                    assert (persistMethod != null);
                    assert ("persistEntity".equals(persistMethod.getElementName())) : persistMethod.getElementName();
                    assert (commitMethod != null);
                    assert ("commitTransaction".equals(commitMethod.getElementName())) : commitMethod.getElementName();
                    if (typeHelper.getAnnotation((IAnnotatable)persistMethod, true, TRANSACTIONATTRIBUTE) == null && (annotation = typeHelper.getAnnotation((IAnnotatable)commitMethod, true, TRANSACTIONATTRIBUTE)) != null && (valueObject = this.getAnnotationMemberValue(typeHelper, annotation, "value", TRANSACTIONATTRIBUTETYPE_NOT_SUPPORTED)) instanceof String && (TRANSACTIONATTRIBUTETYPE_REQUIRED_S.equals(valueObject) || TRANSACTIONATTRIBUTETYPE_REQUIRED.equals(valueObject))) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                DTRTvBundle.log(e);
            }
        }
        return false;
    }

    private Object getAnnotationMemberValue(ITypeHelper typeHelper, IAnnotation annotation, String memberName, String defaultValue) {
        try {
            Object value;
            AnnotationMemberValue annotationMemberValue = typeHelper.getAnnotationMemberValue(annotation, memberName);
            if (annotationMemberValue != null && (value = DTRTUtil.getFistElement((Object[])annotationMemberValue.getValues())) != null) {
                if (value instanceof IField) {
                    IField field = (IField)value;
                    return String.valueOf(field.getDeclaringType().getFullyQualifiedName()) + '.' + field.getElementName();
                }
                if (value instanceof IType) {
                    return ((IType)value).getFullyQualifiedName();
                }
                return value;
            }
        }
        catch (Exception exception) {}
        return defaultValue;
    }

    @Override
    protected AbstractDefinition createDefinition(DataControlStructure dataControlStructure) {
        return new EjbDCDefinition(dataControlStructure);
    }
}

