/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.adf.model.adapter.bean.BeanDefinition;
import oracle.adfdt.model.datacontrols.JUDTAdapterDataControl;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfinternal.model.adapter.ejb.EjbDefinition;
import oracle.binding.meta.DataControlDefinition;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.BasicDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.util.StructureSourceFactory;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.BeanHandler;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.BeanSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.DataControlUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.EJBSessionBeanHandler;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.EJBSessionBeanSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.IDataControlSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.ISourceHandler;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.JavaHandler;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.osgi.util.NLS;

public final class DataControlType
extends Enum<DataControlType>
implements IDescribable {
    public static final /* enum */ DataControlType JAVA_BEAN = new DataControlType(Messages.javaBeanLabel, Messages.javaBeanToolTipText, (ImageManager.IImageData)DTRTBundleIcon.DATA_CONTROL_JAVA_BEAN, JavaBeanResourceVisitor.class);
    public static final /* enum */ DataControlType EJB_SESSION_BEAN = new DataControlType(Messages.ejbSessionLabel, Messages.ejbSessionToolTipText, (ImageManager.IImageData)DTRTBundleIcon.DATA_CONTROL_EJB_BEAN, EJBSessionBeanResourceVisitor.class);
    private final BaseDescriptor descriptor;
    private final Class<? extends ResourceVisitor> resourceVisitor;
    private static final /* synthetic */ DataControlType[] ENUM$VALUES;

    static {
        ENUM$VALUES = new DataControlType[]{JAVA_BEAN, EJB_SESSION_BEAN};
    }

    public static List<DataControlType> getTypes(IDataControlContext context) {
        return context.getModelProject() != null && JavaEEProjectUtilities.isEJBProject((IProject)context.getModelProject()) ? Arrays.asList(DataControlType.values()) : Collections.singletonList(JAVA_BEAN);
    }

    public static List<DataControlType> getTypes(boolean forLoading, IStructure.IStructureSource source) throws CoreException {
        IDataControlSourceInfo sourceInfo = DataControlUtil.computeInfo(source);
        return DataControlType.getTypes(forLoading, sourceInfo);
    }

    private static List<DataControlType> getTypes(boolean forLoading, IDataControlSourceInfo sourceInfo) throws CoreException {
        if (sourceInfo instanceof BeanSourceInfo) {
            if (JavaHandler.validateTypeAsDataControl(forLoading, ((BeanSourceInfo)sourceInfo).getType()) == null) {
                return Collections.singletonList(JAVA_BEAN);
            }
        } else if (sourceInfo instanceof EJBSessionBeanSourceInfo) {
            return Collections.singletonList(EJB_SESSION_BEAN);
        }
        return Collections.emptyList();
    }

    public static ISourceHandler createHandlerForLoading(DataControl dataControl, IStructure.IStructureSource structureSource) throws CoreException {
        IType type;
        DataControlType dataControlType = DataControlType.getType(dataControl);
        if (dataControlType == EJB_SESSION_BEAN && structureSource instanceof IStructure.ITypeSource && (type = ((IStructure.ITypeSource)structureSource).getType()).isInterface()) {
            return new EJBSessionBeanHandler(new EJBSessionBeanSourceInfo(type));
        }
        IDataControlSourceInfo sourceInfo = DataControlUtil.computeInfo(structureSource);
        for (DataControlType type2 : DataControlType.getTypes(true, sourceInfo)) {
            ISourceHandler sourceHandler = type2.createHandler(sourceInfo);
            if (sourceHandler == null) continue;
            return sourceHandler;
        }
        return null;
    }

    public static DataControlType getType(DataControl dataControl) {
        if (dataControl instanceof JUDTAdapterDataControl) {
            DataControlDefinition definition = ((JUDTAdapterDataControl)dataControl).getNativeDataControlDefinition();
            if (definition instanceof EjbDefinition) {
                return EJB_SESSION_BEAN;
            }
            if (definition instanceof BeanDefinition) {
                return JAVA_BEAN;
            }
        }
        return null;
    }

    private DataControlType(String label, String toolTipText, ImageManager.IImageData imageData, Class<? extends ResourceVisitor> resourceVisitor) {
        assert (label != null);
        assert (resourceVisitor != null);
        this.descriptor = new BasicDescriptor(label, toolTipText, imageData);
        this.resourceVisitor = resourceVisitor;
    }

    public IDescriptor getDescriptor() {
        return this.descriptor;
    }

    ISourceHandler createHandler(IStructure.IStructureSource source) throws CoreException {
        IDataControlSourceInfo sourceInfo = DataControlUtil.computeInfo(source);
        return this.createHandler(sourceInfo);
    }

    ISourceHandler createHandler(IDataControlSourceInfo sourceInfo) throws CoreException {
        if (sourceInfo != null) {
            switch (this) {
                case JAVA_BEAN: {
                    if (!(sourceInfo instanceof BeanSourceInfo)) break;
                    return new BeanHandler((BeanSourceInfo)sourceInfo);
                }
                case EJB_SESSION_BEAN: {
                    if (!(sourceInfo instanceof EJBSessionBeanSourceInfo)) break;
                    return new EJBSessionBeanHandler((EJBSessionBeanSourceInfo)sourceInfo);
                }
            }
        }
        return null;
    }

    public Collection<? extends IStructure.IStructureSource> getStructureSources(final boolean forLoading, IProject project) {
        if (project != null) {
            switch (this) {
                case JAVA_BEAN: {
                    final HashSet typeSources = new HashSet();
                    IResourceVisitor visitor = new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (!resource.isDerived()) {
                                IType type;
                                if (resource instanceof IContainer) {
                                    return true;
                                }
                                IJavaElement javaElement = JavaCore.create((IResource)resource);
                                if (javaElement instanceof ITypeRoot && JavaHandler.validateTypeAsDataControl(forLoading, type = ((ITypeRoot)javaElement).findPrimaryType()) == null) {
                                    typeSources.add(StructureSourceFactory.createTypeSource((IType)type));
                                }
                            }
                            return false;
                        }
                    };
                    try {
                        project.accept(visitor);
                    }
                    catch (CoreException e) {
                        DTRTvBundle.log(e);
                    }
                    if (typeSources.isEmpty()) break;
                    return typeSources;
                }
                case EJB_SESSION_BEAN: {
                    Collection types = DTRTvCommonUtil.getSessionBeanTypes((IProject)project);
                    if (types.isEmpty()) break;
                    HashSet<IStructure.ITypeSource> typeSources = new HashSet<IStructure.ITypeSource>(types.size());
                    for (IType type : types) {
                        typeSources.add(StructureSourceFactory.createTypeSource((IType)type));
                    }
                    return typeSources;
                }
                default: {
                    throw new IllegalStateException(this.name());
                }
            }
        }
        return Collections.emptySet();
    }

    public IResourceVisitor createResourceVisitor(IProject project, Set<IStructure.IStructureSource> matchingResources) throws Exception {
        ResourceVisitor visitor = this.resourceVisitor.newInstance();
        visitor.setProject(project);
        visitor.setMatchingResources(matchingResources);
        return visitor;
    }

    public static DataControlType[] values() {
        DataControlType[] dataControlTypeArray = ENUM$VALUES;
        int n = dataControlTypeArray.length;
        DataControlType[] dataControlTypeArray2 = new DataControlType[n];
        System.arraycopy(ENUM$VALUES, 0, dataControlTypeArray2, 0, n);
        return dataControlTypeArray2;
    }

    public static DataControlType valueOf(String string) {
        return Enum.valueOf(DataControlType.class, string);
    }

    private static class EJBSessionBeanResourceVisitor
    extends ResourceVisitor {
        private EJBSessionBeanResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            Collection types = DTRTvCommonUtil.getSessionBeanTypes((IProject)this.project);
            if (!types.isEmpty()) {
                for (IType type : types) {
                    this.matchingResources.add(StructureSourceFactory.createTypeSource((IType)type));
                }
            }
            return false;
        }
    }

    private static class JavaBeanResourceVisitor
    extends ResourceVisitor {
        private JavaBeanResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            IJavaElement javaElement = JavaCore.create((IResource)resource);
            if (javaElement instanceof ITypeRoot) {
                this.matchingResources.add(StructureSourceFactory.createTypeSource((ITypeRoot)((ITypeRoot)javaElement)));
            }
            return true;
        }
    }

    private static class Messages
    extends NLS {
        public static String javaBeanLabel;
        public static String javaBeanToolTipText;
        public static String ejbSessionLabel;
        public static String ejbSessionToolTipText;

        static {
            NLS.initializeMessages((String)DataControlType.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }

    private static abstract class ResourceVisitor
    implements IResourceVisitor {
        protected IProject project;
        protected Set<IStructure.IStructureSource> matchingResources;

        private ResourceVisitor() {
        }

        public void setMatchingResources(Set<IStructure.IStructureSource> matchingResources) {
            this.matchingResources = matchingResources;
        }

        public void setProject(IProject project) {
            this.project = project;
        }
    }
}

