/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import oracle.eclipse.tools.adf.dtrt.context.command.ICreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.DataControlUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.IDataControlSourceInfo;

public abstract class CreationInfo {
    private boolean transactionalDCSupported;
    protected boolean canSetTransactionalDCSupported;
    private boolean updateableDCSupported;
    protected boolean canSetUpdateableDCSupported;
    private boolean managedDCSupported;
    protected boolean canSetManagedDCSupported;
    private boolean queryMethodSupported;
    private boolean canSetQueryMethodSupported = false;
    private boolean generateMetadata;
    private short accessMode = 1;
    private IDataControlSourceInfo sourceInfo;

    public CreationInfo(IDataControlSourceInfo sourceInfo, boolean supportsQuery, boolean supportsManagedDC, boolean supportsTransaction, boolean supportsUpdateableDC) {
        this.sourceInfo = sourceInfo;
        this.managedDCSupported = supportsManagedDC;
        this.transactionalDCSupported = supportsTransaction;
        this.updateableDCSupported = supportsUpdateableDC;
        this.queryMethodSupported = supportsQuery;
        if (this.queryMethodSupported) {
            this.canSetQueryMethodSupported = true;
        }
    }

    public IDataControlSourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public boolean isQueryMethodSupported() {
        return this.queryMethodSupported;
    }

    public boolean isNamedCritriaSettable() {
        return this.canSetQueryMethodSupported;
    }

    public void setQueryMethodSupported(boolean queryMethodSupported) {
        if (this.canSetQueryMethodSupported) {
            this.queryMethodSupported = queryMethodSupported;
        }
    }

    public boolean isTransactionalDCSupported() {
        return this.transactionalDCSupported;
    }

    public boolean canSetTransactionalDCSupported() {
        return this.canSetTransactionalDCSupported;
    }

    public void setTransactionalDCSupported(boolean transactionalDCSupported) {
        if (this.canSetTransactionalDCSupported) {
            this.transactionalDCSupported = transactionalDCSupported;
        }
    }

    public boolean isUpdateableDCSupported() {
        return this.updateableDCSupported;
    }

    public boolean canSetUpdateableDCSupported() {
        return this.canSetUpdateableDCSupported;
    }

    public void setUpdateableDCSupported(boolean updateableDCSupported) {
        if (this.canSetUpdateableDCSupported) {
            this.updateableDCSupported = updateableDCSupported;
        }
    }

    public boolean isManagedDCSupported() {
        return this.managedDCSupported;
    }

    public boolean canSetManagedDCSupported() {
        return this.canSetManagedDCSupported;
    }

    public void setManagedDCSupported(boolean managedDCSupported) {
        if (this.canSetManagedDCSupported) {
            this.managedDCSupported = managedDCSupported;
        }
    }

    public boolean isPaginationSupported() {
        return this.accessMode > 0;
    }

    public boolean isGenerateMetadata() {
        return this.generateMetadata;
    }

    public void setGenerateMetadata(boolean generateMetadata) {
        this.generateMetadata = generateMetadata;
    }

    public short getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(short accessMode) {
        this.accessMode = accessMode;
    }

    public boolean matches(ICreateDataControlCommand command) {
        try {
            return DataControlUtil.computeInfo(command.getStructureSource()).equals(this.getSourceInfo());
        }
        catch (Exception exception) {
            return false;
        }
    }
}

