/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.adf.model.adapter.AbstractDefinition;
import oracle.adf.model.adapter.bean.BeanDCDefinition;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adfdt.model.datacontrols.JUDTAdapterDataControl;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfinternal.model.adapter.generic.DataControlStructure;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.BeanCreationInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.BeanSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreationInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.JavaHandler;
import oracle.xml.parser.v2.XMLDocument;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class BeanHandler
extends JavaHandler<BeanSourceInfo> {
    private String beanClassName;

    public BeanHandler(BeanSourceInfo sourceInfo) {
        super(sourceInfo);
    }

    @Override
    protected void assertCreateCommandExecution() {
        String validationErrorMessage = BeanHandler.validateTypeAsDataControl(false, ((BeanSourceInfo)this.getSourceInfo()).getBeanClassType());
        DTRTUtil.assertTrue((validationErrorMessage == null ? 1 : 0) != 0, (String)validationErrorMessage);
    }

    @Override
    public IDataControl createDataControl(CreateDataControlCommand command, IProgressMonitor monitor) throws Exception {
        return this.createDataControl(((BeanSourceInfo)this.getSourceInfo()).getBeanClassType(), command, monitor);
    }

    @Override
    protected void adjustDataControl(CreateDataControlCommand command, DataControl dataControl) {
        if (!dataControl.getDefinitionClass().equals(this.beanClassName)) {
            dataControl.setDefinitionClass(this.beanClassName);
        }
    }

    @Override
    public StructureDef loadStructure(JUDTAdapterDataControl dataControl) throws Exception {
        return this.loadStructure(dataControl, ((BeanSourceInfo)this.getSourceInfo()).getBeanClassType());
    }

    @Override
    protected IJavaProject getJavaProject() {
        return ((BeanSourceInfo)this.getSourceInfo()).getBeanClassType().getJavaProject();
    }

    @Override
    public Collection<String> getIgnoredClassNames() {
        return Collections.singleton("oracle.binding.OperationBinding");
    }

    @Override
    protected Node getRuntimeSettings(ITypeHelper typeHelper, CreationInfo creationInfo, IType type) throws Exception {
        XMLDocument xmlDoc = new XMLDocument();
        Element metaData = xmlDoc.createElementNS("http://xmlns.oracle.com/adfm/adapter/bean", "bean-definition");
        this.assignAttr(metaData, "BeanClass", this.getBeanClassName(creationInfo, type.getFullyQualifiedName()));
        this.supportsDataControlHandler(creationInfo, metaData);
        this.supportsAccessMode(creationInfo, metaData);
        this.assignAttr(metaData, "EagerPersist", Boolean.toString(this.supportsEagerPersist(typeHelper, type)));
        metaData.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://xmlns.oracle.com/adfm/adapter/bean");
        return metaData;
    }

    private String getBeanClassName(CreationInfo creationInfo, String typeName) {
        this.beanClassName = creationInfo == null ? typeName : (DTRTUtil.isEmpty((String)((BeanCreationInfo)creationInfo).getWrapperClassname()) ? typeName : ((BeanCreationInfo)creationInfo).getWrapperClassname());
        return this.beanClassName;
    }

    private boolean supportsEagerPersist(ITypeHelper typeHelper, IType type) {
        try {
            List methods = typeHelper.getMethods(type, true, SUPPORTS_EAGER_PERSIST_FILTER);
            if (methods.size() == 2) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    @Override
    protected AbstractDefinition createDefinition(DataControlStructure dataControlStructure) {
        return new BeanDCDefinition(dataControlStructure);
    }
}

