/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.context;

import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.util.TypedListenerList;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DataControlProviderHelper;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.OEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

abstract class DataControlProviderExecutableContext
extends OEPEExecutableContext
implements IDataControlProvider {
    private TypedListenerList<IDataControlProvider.IDataControlProviderListener> dataControlProviderListeners;
    private DataControlProviderHelper dataControlProviderHelper;

    DataControlProviderExecutableContext() {
    }

    @Override
    protected void doDispose() {
        if (this.dataControlProviderHelper != null) {
            this.dataControlProviderHelper.dispose();
            this.dataControlProviderHelper = null;
        }
        if (this.dataControlProviderListeners != null) {
            this.dataControlProviderListeners.clear();
            this.dataControlProviderListeners = null;
        }
        super.doDispose();
    }

    @Override
    protected boolean doReset(IProgressMonitor monitor) throws InterruptedException, CoreException {
        boolean doReset = false;
        if (this.dataControlProviderHelper != null) {
            this.dataControlProviderHelper.dispose();
            this.dataControlProviderHelper = null;
            doReset = true;
        }
        return super.doReset(monitor) || doReset;
    }

    public final void addListener(IDataControlProvider.IDataControlProviderListener listener) {
        if (listener != null) {
            if (this.dataControlProviderListeners == null) {
                this.dataControlProviderListeners = new TypedListenerList();
            }
            this.dataControlProviderListeners.add((Object)listener);
        }
    }

    public final void removeListener(IDataControlProvider.IDataControlProviderListener listener) {
        if (listener != null && this.dataControlProviderListeners != null) {
            this.dataControlProviderListeners.remove((Object)listener);
        }
    }

    @Override
    protected final void handleStructureLoading() {
        if (this.dataControlProviderListeners != null && !this.dataControlProviderListeners.isEmpty()) {
            for (IDataControlProvider.IDataControlProviderListener listener : this.dataControlProviderListeners) {
                try {
                    listener.handleStructureLoading((IDataControlProvider)this);
                }
                catch (Exception e) {
                    DTRTvBundle.log(e);
                }
            }
        }
    }

    @Override
    protected final void handleStructureChange() {
        if (this.dataControlProviderListeners != null && !this.dataControlProviderListeners.isEmpty() && this.isImpactedByStructureChange()) {
            for (IDataControlProvider.IDataControlProviderListener listener : this.dataControlProviderListeners) {
                try {
                    listener.handleStructureChange((IDataControlProvider)this);
                }
                catch (Exception e) {
                    DTRTvBundle.log(e);
                }
            }
        }
    }

    protected boolean isImpactedByStructureChange() {
        return true;
    }

    public final List<? extends IDataControl> getDataControls(IProgressMonitor monitor) throws IllegalStateException, InterruptedException {
        this.checkInitialized();
        return this.getDataControlProviderHelper().getDataControls(this.getManager(), this.getTranslator(), monitor);
    }

    protected final IDataControlObject getLocalDataControlObject(IDataControlObject dataControlObject) {
        return this.getDataControlProviderHelper().getLocalDataControlObject(this.getManager(), this.getTranslator(), dataControlObject);
    }

    protected final DataControlProviderHelper getDataControlProviderHelper() {
        return this.dataControlProviderHelper == null ? (this.dataControlProviderHelper = new DataControlProviderHelper()) : this.dataControlProviderHelper;
    }

    protected final boolean isDataControlProviderInstantiated() {
        return this.dataControlProviderHelper != null;
    }

    public void resetStructures(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.getManager().resetStructures();
        if (this.dataControlProviderHelper != null) {
            this.dataControlProviderHelper.updateStructure(this.getManager());
        }
        this.notifyStructureReset();
    }

    private void notifyStructureReset() {
        if (this.dataControlProviderListeners != null) {
            for (IDataControlProvider.IDataControlProviderListener listener : this.dataControlProviderListeners) {
                try {
                    listener.handleStructureReset((IDataControlProvider)this);
                }
                catch (Exception e) {
                    DTRTvBundle.log(e);
                }
            }
        }
    }

    public final <T extends IStructureObject> T getStructureObject(T externalStructureObject) {
        return StructureUtil.getStructureObject(this.getManager(), externalStructureObject);
    }
}

