/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandExecutor;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IObjectEditor;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.context.command.ISetCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.ui.command.IWizardCommandExecutor;
import oracle.eclipse.tools.adf.dtrt.ui.context.IUIObjectEditor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DataControlProviderExecutableContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreationInfoProviderCommandExecutor;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.DataControlType;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.DataControlUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.IDataControlSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.WizardCreateDataControlCommandExecutor;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.editor.DataControlObjectEditorUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.command.StructureObjectSetCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.editor.StructureObjectEditorUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

class DataControlContext
extends DataControlProviderExecutableContext
implements IDataControlContext {
    DataControlContext() {
    }

    public DataControlContext initialize(IProject earProject, IProject webProject, IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (!this.isInitialized()) {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)1);
            try {
                this.initializeManager(earProject, webProject);
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
                return (DataControlContext)this.initialize((OEPEContextImpl)this);
            }
            catch (Exception e) {
                this.throwNotInitializedException(e);
            }
        }
        return this;
    }

    public DataControlContext initialize(IProject modelProject, IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (!this.isInitialized()) {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)1);
            try {
                this.initializeManager(modelProject);
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
                return (DataControlContext)this.initialize((OEPEContextImpl)this);
            }
            catch (Exception e) {
                this.throwNotInitializedException(e);
            }
        }
        return this;
    }

    public IProject getEARProject() {
        IDTRTManager manager = this.getManager();
        return manager != null && manager.initializedWithEARWebProjects() ? manager.getEARProject() : null;
    }

    public IProject getWebProject() {
        IDTRTManager manager = this.getManager();
        return manager != null && manager.initializedWithEARWebProjects() ? manager.getProject() : null;
    }

    public IProject getModelProject() {
        IDTRTManager manager = this.getManager();
        return manager != null && manager.initializedWithModelProject() ? manager.getProject() : null;
    }

    public List<? extends IDataControl> getDataControls(IDescribable type, IStructure.IStructureSource source, IProgressMonitor monitor) throws IllegalStateException, InterruptedException, CoreException {
        this.checkInitialized();
        if (type instanceof DataControlType && type.getDescriptor() != null && source != null && source.getResource() != null) {
            IProject sourceProject = source.getResource().getProject();
            IDataControlSourceInfo info = DataControlUtil.computeInfo(source);
            if (sourceProject != null) {
                List<? extends IDataControl> dataControls = this.getDataControls(monitor);
                ArrayList<IDataControl> matched = new ArrayList<IDataControl>(dataControls.size());
                for (IDataControl iDataControl : dataControls) {
                    IProject dataControlProject;
                    if (!type.getDescriptor().equals(iDataControl.getTypeDescriptor())) continue;
                    IFile file = this.getAccessibleFile((IObject)iDataControl);
                    IProject iProject = dataControlProject = file != null ? file.getProject() : this.getManager().getProject();
                    if (!DTRTUtil.equals((Object)sourceProject, (Object)dataControlProject) || !info.appliesTo(iDataControl.getStructureObject())) continue;
                    matched.add(iDataControl);
                }
                if (!matched.isEmpty()) {
                    return Collections.unmodifiableList(matched);
                }
            }
        }
        return Collections.emptyList();
    }

    public IFileMarker getAccessibleDeclaration(IDataControlObject dataControlObject) {
        List<? extends IFileMarker> markers = super.getAccessibleDeclarations((IObject)dataControlObject);
        return markers.isEmpty() ? null : markers.get(0);
    }

    public boolean hasUpdateableStructure(IStructure.IStructureSource source) {
        return false;
    }

    public String computeUniqueDataControlId(IDescribable type, IStructure.IStructureSource source) throws CoreException {
        IDataControlSourceInfo sourceInfo;
        if (type instanceof DataControlType && source != null && (sourceInfo = DataControlUtil.computeInfo(source)) != null) {
            return DTRTvContextUtil.computeUniqueId((IOEPEContext)this, IDataControl.class, sourceInfo.getBaseDataControlId(), type);
        }
        return null;
    }

    public Collection<? extends IDescribable> getDataControlTypes() {
        return DataControlType.getTypes(this);
    }

    public List<? extends IDescribable> getDataControlTypes(IStructure.IStructureSource source) throws CoreException {
        return DataControlType.getTypes(false, source);
    }

    public Collection<? extends IStructure.IStructureSource> getStructureSources(IDescribable dataControlType) {
        DataControlType type = (DataControlType)dataControlType;
        return type.getStructureSources(false, this.getModelProject() != null ? this.getModelProject() : this.getWebProject());
    }

    protected <T extends ICommand> T doCreateCommand(Class<T> commandType) {
        this.checkCommandCreation();
        this.checkInitialized();
        CreateDataControlCommand command = commandType == ICreateDataControlCommand.class ? new CreateDataControlCommand(this) : (commandType == CreateDataControlCommand.class ? new CreateDataControlCommand(this) : (commandType == ISetCommand.class ? new StructureObjectSetCommand(this) : (commandType == StructureObjectSetCommand.class ? new StructureObjectSetCommand(this) : null)));
        return (T)(command != null ? (ICommand)commandType.cast((Object)command) : null);
    }

    protected <C extends ICommand, E extends ICommandExecutor<C>> E doCreateCommandExecutor(Class<E> commandExecutorType, Class<C> commandType) {
        if (commandType == ICreateDataControlCommand.class) {
            if (commandExecutorType == IWizardCommandExecutor.class) {
                return (E)((ICommandExecutor)commandExecutorType.cast((Object)new WizardCreateDataControlCommandExecutor(this)));
            }
            if (commandExecutorType == ICommandExecutor.class || commandExecutorType == CreationInfoProviderCommandExecutor.class) {
                return (E)((ICommandExecutor)commandExecutorType.cast((Object)new CreationInfoProviderCommandExecutor(this)));
            }
        }
        return null;
    }

    public <T extends IObjectEditor> T createObjectEditor(Class<T> type, IObject object) {
        if (type == IUIObjectEditor.class) {
            if (object instanceof IDataControlObject) {
                Object adfObject = this.getTranslator().toADFObject(object);
                return (T)((IObjectEditor)type.cast(DataControlObjectEditorUtil.createObjectEditor(this, (IDataControlObject)object, adfObject)));
            }
            if (object instanceof IStructureObject) {
                return (T)((IObjectEditor)type.cast(StructureObjectEditorUtil.createObjectEditor(this, (IStructureObject)object)));
            }
        }
        return null;
    }

    public Collection<? extends IStructure> getLoadedStructures() {
        return DTRTvContextUtil.getLoadedStructures(this);
    }

    protected void handleCommandOperation(ICommand command, ICommand.CommandOperation operationPerformed) {
        if (this.isDataControlProviderInstantiated() && command instanceof ICreateDataControlCommand) {
            if (operationPerformed == ICommand.CommandOperation.UNDO) {
                this.getDataControlProviderHelper().removeDataControls(this.getManager(), this.getTranslator(), null);
            } else {
                assert (command.getAffectedObjects().size() == 1) : command.getAffectedObjects();
                assert (command.getAffectedObjects().get(0) instanceof IDataControl) : command.getAffectedObjects();
                this.getDataControlProviderHelper().addDataControl(this.getManager(), this.getTranslator(), (IDataControl)command.getAffectedObjects().get(0), null);
            }
        }
    }
}

