/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.context;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.adfdt.view.unified.binding.util.ExpressionUtils;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.vbundle.CreatableType;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.OEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.PageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.WebPageContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.boundsource.WebPageBoundSourceSubType;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public final class DTRTvContextUtil {
    public static final WebPageBoundSourceSubType[] SUPPORTED_WEB_PAGE_BOUND_SOURCE_SUB_TYPES = new WebPageBoundSourceSubType[4];

    static {
        DTRTvContextUtil.SUPPORTED_WEB_PAGE_BOUND_SOURCE_SUB_TYPES[0] = WebPageBoundSourceSubType.FACELET;
        DTRTvContextUtil.SUPPORTED_WEB_PAGE_BOUND_SOURCE_SUB_TYPES[1] = WebPageBoundSourceSubType.FACELET_COMPOSITION;
        DTRTvContextUtil.SUPPORTED_WEB_PAGE_BOUND_SOURCE_SUB_TYPES[2] = WebPageBoundSourceSubType.JSPX;
        DTRTvContextUtil.SUPPORTED_WEB_PAGE_BOUND_SOURCE_SUB_TYPES[3] = WebPageBoundSourceSubType.JSP_FRAGMENT;
    }

    private DTRTvContextUtil() {
    }

    public static IDTRTManager getManager(IOEPEContext context) {
        return context instanceof OEPEExecutableContext ? ((OEPEExecutableContext)context).getManager() : null;
    }

    public static IStatus isValidObjectId(Class<? extends IObject> objectType, String objectId) {
        String el;
        String elId;
        if (objectId == null) {
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", Messages.idNull);
        }
        Character firstChar = Character.valueOf(objectId.charAt(0));
        if (firstChar.charValue() != '_' && firstChar.charValue() != ':' && !Character.isLetter(firstChar.charValue())) {
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", Messages.idFirstChar);
        }
        if (objectId.indexOf(32) >= 0) {
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", Messages.idEmptySpace);
        }
        if (objectId.indexOf(59) >= 0) {
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", Messages.idSemicolon);
        }
        if (objectId.indexOf(46) >= 0) {
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", Messages.idDots);
        }
        if (IBindingObject.class.isAssignableFrom(objectType) && !objectId.equals(elId = ExpressionUtils.getBindingIdFromExpression((String)(el = "${bindings." + objectId + '}')))) {
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", NLS.bind((String)Messages.invalidId, (Object)objectId));
        }
        return Status.OK_STATUS;
    }

    public static String computeUniqueId(IOEPEContext context, Class<? extends IObject> type, String baseId, IDescribable describableType) {
        if (type != null) {
            if (describableType == CreatableType.TYPE_VariablesIterator) {
                return "variables";
            }
            if (context instanceof IPageDefinitionContext) {
                IPageDefinition pageDefinition;
                if (IBindingObject.class.isAssignableFrom(type) && (pageDefinition = ((IPageDefinitionContext)context).getPageDefinition()) != null) {
                    if (baseId == null) {
                        baseId = "bindingObject";
                    } else {
                        baseId = DTRTvContextUtil.sanitizeId(baseId);
                        assert (DTRTvContextUtil.isValidObjectId(type, baseId).isOK());
                    }
                    List bindingObjects = DTRTObjectUtil.getBindingObjects((IPageDefinition)pageDefinition);
                    return DTRTvContextUtil.computeUniqueId(bindingObjects, baseId, false);
                }
                return null;
            }
            if (context instanceof IDataControlContext && IDataControl.class.isAssignableFrom(type)) {
                if (baseId == null) {
                    baseId = "dataControl";
                } else {
                    baseId = DTRTvContextUtil.sanitizeId(baseId);
                    assert (DTRTvContextUtil.isValidObjectId(type, baseId).isOK());
                }
                List dataControls = DTRTObjectUtil.getDataControls((IDataControlProvider)((IDataControlProvider)context));
                return DTRTvContextUtil.computeUniqueId(dataControls, baseId, true);
            }
        }
        return null;
    }

    private static String sanitizeId(String id) {
        id = id.replace(" ", "");
        id = id.replace(";", "");
        Character firstChar = Character.valueOf((id = id.replace(".", "")).charAt(0));
        if (firstChar.charValue() != '_' && firstChar.charValue() != ':' && !Character.isLetter(firstChar.charValue())) {
            id = "_" + id;
        }
        return id;
    }

    private static String computeUniqueId(Collection<? extends IObject> objects, String baseId, boolean testBaseId) {
        if (!testBaseId || DTRTObjectUtil.find(objects, (String)baseId) != null) {
            String id;
            int counter = 0;
            while (DTRTObjectUtil.find(objects, (String)(id = String.valueOf(baseId) + ++counter)) != null) {
            }
            return id;
        }
        return baseId;
    }

    public static IPageDefinition getPageDefinition(IOEPEContext context) {
        return context instanceof PageDefinitionContext ? ((PageDefinitionContext)context).getPageDefinition() : (context instanceof WebPageContext ? ((WebPageContext)context).getPageDefinition() : null);
    }

    static Collection<? extends IStructure> getLoadedStructures(OEPEExecutableContext context) {
        StructureProvider structureProvider;
        IDTRTManager manager;
        if (context != null && (manager = context.getManager()) != null && (structureProvider = manager.getStructureProvider()) != null) {
            return structureProvider.getStructures();
        }
        return Collections.emptySet();
    }

    private static class Messages
    extends NLS {
        public static String idEmptySpace;
        public static String idFirstChar;
        public static String idNull;
        public static String idSemicolon;
        public static String idDots;
        public static String invalidId;

        static {
            NLS.initializeMessages((String)DTRTvContextUtil.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

