/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.adf.model.adapter.dataformat.MethodDef;
import oracle.adf.share.common.ClassUtils;
import oracle.adfdt.model.ModelDesignTimeContext;
import oracle.adfdt.model.managers.FactoryManager;
import oracle.adfdt.model.objects.Application;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdt.model.objects.BeanMethodParameter;
import oracle.adfdt.model.objects.BeanStructure;
import oracle.adfdt.model.objects.DTFactory;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.model.objects.ElementObjectFactory;
import oracle.adfdt.model.objects.Method;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.adfdt.model.objects.Variable;
import oracle.binding.meta.ArrayListDefinitionContainer;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IBinding;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IIteratorBinding;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.object.IVariableObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.FileMaker;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionKey;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IAccessorIterator;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IteratorBinding;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonUtil;
import oracle.jbo.mom.PropertyNameValueDef;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class DTRTvUtil {
    private DTRTvUtil() {
    }

    public static String computePageDefinitionUsageId(Application application, boolean makeUnique) {
        String usageId = application.getPackageName();
        usageId = String.valueOf(usageId.replace('.', '_').replace('-', '_')) + '_';
        return makeUnique ? DTRTvCommonUtil.computeUniqueValue((Document)application.getDocument(), (String)"usageId", (String)usageId) : String.valueOf(usageId) + '1';
    }

    public static String getNonEncodedURISegment(Object o) throws IllegalArgumentException {
        if (o instanceof Variable) {
            return DTRTvUtil.getNonEncodedURISegment((Variable)o);
        }
        if (o instanceof BaseElementObject) {
            return DTRTvUtil.getNonEncodedURISegment((BaseElementObject)o);
        }
        if (o instanceof NamedDefinition) {
            return NamedDefinitionKey.computeNonEncodedURISegment((NamedDefinition)o);
        }
        if (o instanceof ArrayListDefinitionContainer) {
            return DTRTvUtil.getNonEncodedURISegment((ArrayListDefinitionContainer)o);
        }
        if (o instanceof PropertyNameValueDef) {
            return DTRTvUtil.getNonEncodedURISegment((PropertyNameValueDef)o);
        }
        if (o != null) {
            throw new IllegalArgumentException(o.getClass().toString());
        }
        return null;
    }

    private static String getNonEncodedURISegment(PropertyNameValueDef o) {
        if (o != null) {
            String typeName;
            StringBuilder builder = new StringBuilder(o.getClass().getSimpleName());
            String name = o.getName();
            Class type = o.getType();
            if (name != null) {
                builder.append('-').append(name);
            }
            String string = typeName = type != null ? type.getSimpleName() : null;
            if (typeName != null) {
                builder.append('-').append(typeName);
            }
            return builder.toString();
        }
        return null;
    }

    private static String getNonEncodedURISegment(BaseElementObject element) {
        if (element != null) {
            StringBuilder sb = new StringBuilder(element.getClass().getSimpleName()).append('-');
            if (element instanceof Method) {
                sb.append(DTRTvUtil.getSignature((Method)element));
            } else {
                String id = element.getId();
                if (id == null) {
                    id = element.getFullName();
                }
                sb.append(id);
            }
            return sb.toString();
        }
        return null;
    }

    private static String getNonEncodedURISegment(Variable variable) {
        if (variable != null) {
            String id = variable.getName() != null ? variable.getName() : Integer.toHexString(System.identityHashCode(variable));
            return variable.getClass().getSimpleName() + '-' + variable.getName() + id;
        }
        return null;
    }

    private static String getNonEncodedURISegment(ArrayListDefinitionContainer element) {
        return element == null ? null : element.getClass().getSimpleName() + '-' + element.getSize();
    }

    public static boolean isConstructor(NamedDefinition namedDefinition) {
        return namedDefinition instanceof MethodDef && ((MethodDef)namedDefinition).isConstructor();
    }

    public static boolean isMethod(NamedDefinition namedDefinition) {
        return namedDefinition instanceof MethodDef && !((MethodDef)namedDefinition).isConstructor();
    }

    public static boolean isCustomMethod(NamedDefinition namedDefinition) {
        return namedDefinition instanceof OperationDefinition && ((OperationDefinition)namedDefinition).getDefinitionType() == 60 && ((OperationDefinition)namedDefinition).getOperationId() == 999;
    }

    public static String getSignature(OperationDefinition operationDefinition) {
        if (operationDefinition != null) {
            String key = "DTRTvUtil.getSignature(OperationDefinition)";
            Object value = operationDefinition.getProperty(key);
            if (value instanceof String) {
                return (String)value;
            }
            StringBuilder sb = new StringBuilder(operationDefinition.getName());
            sb.append('(');
            int pos = sb.length();
            DefinitionContainer operationParameters = operationDefinition.getOperationParameters();
            if (operationParameters != null && !operationParameters.isEmpty()) {
                for (AttributeDefinition attributeDefinition : operationDefinition.getOperationParameters()) {
                    sb.append(", ");
                    sb.append(DTRTvCommonUtil.getSimpleName((String)attributeDefinition.getJavaTypeString()));
                }
                sb.delete(pos, pos + 2);
            }
            sb.append(')');
            String signature = sb.toString();
            operationDefinition.getProperties().put(key, signature);
            return signature;
        }
        return null;
    }

    public static String getSignature(Method method) {
        if (method != null) {
            StringBuilder sb = new StringBuilder(DTRTvCommonUtil.getSimpleName((String)method.getFullName()));
            sb.append('(');
            ArrayList parameters = method.getParameters();
            if (parameters != null && !parameters.isEmpty()) {
                int i = 0;
                while (i < parameters.size()) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(DTRTvCommonUtil.getSimpleName((String)((BeanMethodParameter)parameters.get(0)).getType()));
                    ++i;
                }
            }
            return sb.append(')').toString();
        }
        return null;
    }

    public static List<IBindingObject> computePageDefinitionUsage(IBindingObject bindingObject) {
        IObject parent;
        if (bindingObject instanceof IIteratorBinding && (parent = bindingObject.getParent()) instanceof IPageDefinition) {
            IPageDefinition pageDefinition = (IPageDefinition)parent;
            ArrayList<IBindingObject> bindingObjects = new ArrayList<IBindingObject>();
            for (IBinding binding : pageDefinition.getBindings()) {
                if (!bindingObject.equals((Object)binding.getIteratorBinding())) continue;
                bindingObjects.add((IBindingObject)binding);
            }
            for (IExecutable executable : pageDefinition.getExecutables()) {
                IAccessorIterator accessorIterator;
                IteratorBinding masterIterator;
                if (!(executable instanceof IAccessorIterator) || !bindingObject.equals((Object)(masterIterator = (accessorIterator = (IAccessorIterator)executable).getMasterIterator())) || bindingObjects.contains(masterIterator)) continue;
                bindingObjects.add(accessorIterator);
            }
            if (!bindingObjects.isEmpty()) {
                bindingObjects.remove(bindingObject);
                return bindingObjects;
            }
        }
        return new ArrayList<IBindingObject>(0);
    }

    public static void registerDTFactory(DTFactory dtfactory) {
        try {
            Class factoryClass = ClassUtils.forName(dtfactory.getClassName(), dtfactory.getClass());
            ElementObjectFactory factory = (ElementObjectFactory)factoryClass.newInstance();
            FactoryManager.getInstance().registerFactory(factory);
        }
        catch (Exception e) {
            DTRTvBundle.log((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", "Unable to register DTFactory: " + dtfactory.getClassName(), (Throwable)e));
        }
    }

    public static Object getManagedElement(IDTRTManager manager, IObjectTranslator translator, IObject object) {
        if (manager != null && translator != null && object != null) {
            if (object instanceof IDataControlChild) {
                BeanStructure beanStructure;
                IStructure structure;
                IStructureChild structureChild = ((IDataControlChild)object).getStructureObject();
                if (structureChild != null && (structure = DTRTObjectUtil.getStructure((IStructureObject)structureChild)) != null && (beanStructure = StructureUtil.getBeanStructure(structure)) != null && manager.isManagedElement(beanStructure)) {
                    return beanStructure;
                }
                return null;
            }
            Object adfObject = translator.toADFObject(object);
            if (adfObject instanceof DataControl) {
                adfObject = ((DataControl)adfObject).getConfigurationParent();
            } else {
                IObject root = DTRTvCommonUtil.getRootObject((IObject)object);
                if (root != adfObject) {
                    adfObject = translator.toADFObject(root);
                }
            }
            if (manager.isManagedElement(adfObject)) {
                return adfObject;
            }
        }
        return null;
    }

    public static IFile getAccessibleFile(IDTRTManager manager, IObjectTranslator translator, IObject object) throws IllegalStateException {
        Object element;
        if (manager != null && translator != null && object != null && (element = DTRTvUtil.getManagedElement(manager, translator, object)) != null) {
            IFile file = manager.getElementFile(element);
            return manager.isAccessible(file) ? file : null;
        }
        return null;
    }

    public static Application getFirstApplication(IDTRTManager manager, PageDefinition pageDefinition) {
        Map<Application, List<IPageDefinition.IBoundSource>> applications;
        if (manager != null && pageDefinition != null && !(applications = manager.getApplications(pageDefinition)).isEmpty()) {
            return applications.keySet().iterator().next();
        }
        return null;
    }

    public static List<? extends IFileMarker> getAccessibleDeclarations(IDTRTManager manager, IObjectTranslator translator, IObject object) {
        if (manager != null && translator != null && object != null) {
            if (object instanceof IDataControl || object instanceof IBindingObject || object instanceof IVariableObject) {
                IFileMarker fileMarker = DTRTvUtil.getAccessibleDeclaration(manager, translator, object);
                if (fileMarker != null) {
                    return Collections.singletonList(fileMarker);
                }
            } else if (object instanceof IDataControlChild) {
                IFile file = DTRTvUtil.getStructureFile((IDataControlChild)object);
                if (manager.isAccessible(file)) {
                    return Collections.singletonList(new FileMaker(file, "org.eclipse.core.resources.textmarker"));
                }
            } else {
                Object adfObject = translator.toADFObject(object);
                if (manager.isManagedElement(adfObject)) {
                    return manager.getAccessibleDeclarations(adfObject);
                }
                throw new IllegalArgumentException("Unknown object: " + object);
            }
        }
        return Collections.emptyList();
    }

    private static IFile getStructureFile(IDataControlChild dataControlChild) {
        return dataControlChild != null ? StructureUtil.getDeclarationFile((IStructureObject)dataControlChild.getStructureObject()) : null;
    }

    private static IFileMarker getAccessibleDeclaration(IDTRTManager manager, IObjectTranslator translator, IObject object) {
        BaseElementObject adfObject;
        IFile file;
        Object element = DTRTvUtil.getManagedElement(manager, translator, object);
        if (element != null && manager.isAccessible(file = manager.getElementFile(element)) && (adfObject = (BaseElementObject)translator.toADFObject(object)) != null) {
            return DTRTvUtil.createTextFileMarker(file, adfObject.getElement());
        }
        return null;
    }

    public static IFileMarker createTextFileMarker(IFile file, Node node) {
        if (file != null) {
            return new FileMaker(file, "org.eclipse.core.resources.textmarker");
        }
        return null;
    }

    public static IDTRTManager getManager(DataControl dataControl) {
        return dataControl != null ? DTRTvUtil.getManager((BaseElementObject)dataControl.getConfigurationParent()) : null;
    }

    public static IDTRTManager getManager(BaseElementObject element) {
        if (element != null) {
            if (element instanceof DataControl) {
                return DTRTvUtil.getManager((DataControl)element);
            }
            ModelDesignTimeContext modelDesignTimeContext = element.getDesigntimeContext();
            if (modelDesignTimeContext instanceof IAdaptable) {
                return (IDTRTManager)DTRTUtil.getAdapter((IAdaptable)((IAdaptable)modelDesignTimeContext), IDTRTManager.class);
            }
        }
        return null;
    }
}

