/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdt.view.unified.binding.provider;

import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.model.binding.BindingInfo;
import oracle.adfdt.model.binding.DefaultBindingFactory;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.CtrlHierTypeBinding;
import oracle.adfdt.model.objects.CtrlList;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.adfdt.model.util.JSR227Util;
import oracle.adfdt.view.common.binding.provider.ADFBaseProvider;
import oracle.adfdt.view.common.binding.provider.ModelProvider;
import oracle.adfdt.view.common.binding.utils.ADFBindingUtils;
import oracle.adfdt.view.unified.binding.provider.ADFColumnModelProvider;
import oracle.adfdt.view.unified.binding.provider.api.ColumnModelProvider;
import oracle.adfdt.view.unified.binding.provider.api.TableModelProvider;
import oracle.adfdt.view.unified.binding.util.ExpressionUtils;
import oracle.adfdt.view.unified.binding.util.PropertyGenerationUtils;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.VariableDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ADFSelectionModelProvider
extends ADFBaseProvider {
    private final NamedDefinition _definition;
    private ControlBinding _binding;
    private String _attributeId;
    private String _rootAccessorId;
    private String _tableIteratorVar;
    private String _tableBindingPrefix;
    private boolean _supportsMRU;
    private boolean _bindingRequiresPopulation = false;
    private boolean _ignorePopulation = false;

    public ADFSelectionModelProvider(ADFDesignTimeContext dtContext, DataControl dataControl, NamedDefinition dataControlDefinition) {
        this(dtContext, dataControl, dataControlDefinition, null, false);
    }

    public ADFSelectionModelProvider(ADFDesignTimeContext dtContext, DataControl dataControl, NamedDefinition dataControlDefinition, String boundAttributeId, boolean supportsMRU) {
        super(dtContext, dataControl);
        this._definition = dataControlDefinition;
        this._attributeId = boundAttributeId;
        this._supportsMRU = supportsMRU;
    }

    public void initializeFromParent(ModelProvider parent) {
        if (parent instanceof ColumnModelProvider) {
            ColumnModelProvider colProvider = (ColumnModelProvider)parent;
            this._attributeId = colProvider.getAttributeId();
            this._rootAccessorId = colProvider.getRootAccessorId();
            this._tableBindingPrefix = colProvider.getTableBindingPrefix();
        }
    }

    public boolean configureModelFromView(Node insertParent) {
        Element table = this.getParentTable(insertParent);
        if (table == null) {
            return true;
        }
        String value = table.getAttributeNS(null, "value");
        String bindingId = ExpressionUtils.getBindingIdFromExpression((String)value);
        TableModelProvider tableProvider = this.getTableModelProvider(this.getDTContext(), this.getDTBaseBindingContainer(), bindingId);
        if (tableProvider == null) {
            return true;
        }
        VariableDefinition definition = (VariableDefinition)this._definition;
        ColumnModelProvider colProviderBase = tableProvider.getBaseColumnModelBinding(definition);
        if (colProviderBase != null && colProviderBase instanceof ADFColumnModelProvider) {
            ADFColumnModelProvider colProvider = (ADFColumnModelProvider)colProviderBase;
            this._tableBindingPrefix = colProvider.getTableBindingPrefix();
            this._attributeId = colProvider.getAttributeId();
            this._rootAccessorId = colProvider.getRootAccessorId();
            if (!JSR227Util.hasDefaultBindingType((VariableDefinition)definition, (BindingInfo)DefaultBindingFactory.LIST)) {
                colProvider.__setHierUpdateStrategy(new ADFColumnModelProvider.UpdateHierStrategy(){

                    public void updatePrimaryRule(CtrlHierTypeBinding primaryRule) {
                        primaryRule.addOrSetAttrNameAndBinds(ADFSelectionModelProvider.this._attributeId, ADFSelectionModelProvider.this.getOrCreateUnpopulatedBinding().getId());
                        ADFSelectionModelProvider.this._bindingRequiresPopulation = true;
                    }
                });
            }
            tableProvider.initializeColumnModel((ColumnModelProvider)colProvider);
            String itorVar = table.getAttributeNS(null, "var");
            if (itorVar != null && !"".equals(itorVar)) {
                this._tableIteratorVar = itorVar.trim();
            }
        }
        return true;
    }

    protected abstract TableModelProvider getTableModelProvider(ADFDesignTimeContext var1, PageDefinition var2, String var3);

    protected abstract Element getParentTable(Node var1);

    public String getSelectionExpression() {
        return this._createExpression("inputValue");
    }

    public String getSelectionExpression(String baseExpr) {
        return this._createExpression(baseExpr, "inputValue");
    }

    public String getChildIteratorExpression() {
        return this._createExpression("items");
    }

    public String getChildIteratorExpression(String baseExpr) {
        return this._createExpression(baseExpr, "items");
    }

    public String getValidatorExpression() {
        return this._createExpression("validator");
    }

    public String getValidatorExpression(String baseExpr) {
        return this._createExpression(baseExpr, "validator");
    }

    public String getLabelExpression() {
        return this._createExpression("label");
    }

    public String getLabelExpression(String baseExpr) {
        return this._createExpression(baseExpr, "label");
    }

    public String getRequiredExpression() {
        if (this._tableBindingPrefix != null) {
            this.ensureBindingConfigured();
            return PropertyGenerationUtils.buildHintProperty((String)this._tableBindingPrefix, (String)this._attributeId, (String)this._rootAccessorId, (String)"mandatory");
        }
        return PropertyGenerationUtils.buildBaseHintProperty((String)this._getOrCreateControlBinding().getId(), (String)"mandatory");
    }

    public String getShortDescExpression() {
        if (this._tableBindingPrefix != null) {
            this.ensureBindingConfigured();
            return PropertyGenerationUtils.buildHintProperty((String)this._tableBindingPrefix, (String)this._attributeId, (String)this._rootAccessorId, (String)"tooltip");
        }
        return PropertyGenerationUtils.buildBaseHintProperty((String)this._getOrCreateControlBinding().getId(), (String)"tooltip");
    }

    public String getRenderedExpression(String baseExpression) {
        return this._rootAccessorId != null && baseExpression != null ? ExpressionUtils.createExpression((String[])new String[]{ExpressionUtils.createPropertyExpression((String)baseExpression, (String)this._rootAccessorId) + " != null"}) : null;
    }

    public boolean isBoundToIterator() {
        return this._tableBindingPrefix != null;
    }

    public String getIteratorVar() {
        return this._tableIteratorVar;
    }

    public boolean requiresEditorPopulation() {
        if (this._ignorePopulation) {
            return false;
        }
        return !(this._definition instanceof VariableDefinition) || !JSR227Util.hasDefaultBindingType((VariableDefinition)((VariableDefinition)this._definition), (BindingInfo)DefaultBindingFactory.LIST);
    }

    public void setIgnorePopulation(boolean ignorePopulation) {
        this._ignorePopulation = ignorePopulation;
    }

    public void populateSelection() {
        boolean ok;
        if (this._binding.hasCustomDialog() && !(ok = this.getDTContext().launchBindingEditor(this._binding))) {
            ADFBindingUtils.cancelCreateOrBind();
        }
    }

    public ControlBinding getOrCreateUnpopulatedBinding() {
        return this._getOrCreateControlBinding(false);
    }

    public NamedDefinition getDefinition() {
        return this._definition;
    }

    protected void ensureBindingConfigured() {
        if (this._bindingRequiresPopulation) {
            if (this.requiresEditorPopulation()) {
                this.populateSelection();
            }
            this._bindingRequiresPopulation = false;
        }
    }

    protected BindingInfo getSelectionBindingInfo() {
        return DefaultBindingFactory.LIST;
    }

    protected ControlBinding getControlBinding() {
        return this._getOrCreateControlBinding();
    }

    protected String getTableDrivenAttributeId() {
        return this._attributeId;
    }

    private String _createExpression(String toFetch) {
        return this._createExpression(null, toFetch);
    }

    private String _createExpression(String baseExpr, String toFetch) {
        if (baseExpr != null) {
            this.ensureBindingConfigured();
            return PropertyGenerationUtils.buildColumnAttributeExpression((String)baseExpr, (String)this._attributeId, (String)this._rootAccessorId, (String)toFetch);
        }
        return ExpressionUtils.createBaseExpression((String)this._getOrCreateControlBinding().getId(), (String)toFetch);
    }

    private ControlBinding _getOrCreateControlBinding() {
        ControlBinding binding = this._getOrCreateControlBinding(true);
        this.ensureBindingConfigured();
        return binding;
    }

    private ControlBinding _getOrCreateControlBinding(boolean populateBinding) {
        if (this._binding == null) {
            BindingInfo bindingInfo = this.getSelectionBindingInfo();
            this._binding = this.createUniqueBinding() ? this.createUniqueControlBinding(this._definition, this.getSelectionBindingInfo()) : this.createControlBinding(this._definition, this.getSelectionBindingInfo());
            if (this._binding instanceof CtrlList) {
                ((CtrlList)this._binding).setSupportsMRU(this._supportsMRU);
            }
            if (DefaultBindingFactory.LIST.equals(bindingInfo)) {
                ((CtrlList)this._binding).setSelectItemValueMode("ListObject");
            }
            if (populateBinding && this.requiresEditorPopulation()) {
                this.populateSelection();
            }
        }
        return this._binding;
    }
}

