/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdt.view.dvt.binding.pattern.gauge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.CtrlAttrs;
import oracle.adfdt.model.objects.CtrlValue;
import oracle.adfdt.model.objects.ElementInterface;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.adfdt.view.common.binding.creator.v2.BinderParams;
import oracle.adfdt.view.common.binding.creator.v2.BinderResult;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.dvt.binding.pattern.gauge.GaugeBottomLabel;
import oracle.adfdt.view.dvt.binding.pattern.gauge.GaugeOptions;
import oracle.adfdt.view.dvt.binding.pattern.gauge.GaugeTopLabel;
import oracle.adfdt.view.dvt.binding.pattern.options.BindingOptions;
import oracle.adfdt.view.dvt.binding.pattern.options.GaugeBindingOptions;
import oracle.adfdt.view.rich.binding.util.JSFExpressionUtils;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.DvtDataBindingDtCoreUtils;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.GaugeBindingUtilsCore;
import oracle.adfdtinternal.dvt.datapresdt.dnd.DvtCoreProvider;
import oracle.adfdtinternal.dvt.datapresdt.dnd.GaugeModelProvider;
import oracle.adfdtinternal.model.dvt.objects.CtrlGauge;
import oracle.adfdtinternal.model.dvt.objects.DvtBaseElementObject;
import oracle.adfdtinternal.model.dvt.objects.GaugeDataMap;
import oracle.adfdtinternal.view.dvt.binding.pattern.options.utils.DvtPatternOptionsUtils;
import oracle.binding.meta.NamedDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class CommonGaugeHelper {
    static final String NAMESPACE = "http://xmlns.oracle.com/dss/adf/faces";
    public static final String GAUGE = "gauge";
    private static final String DVT_PREFIX = "dvt";

    CommonGaugeHelper() {
    }

    static BinderResult bind(BinderParams<? extends GaugeOptions> params) {
        DvtDataBindingDtCoreUtils.setExistingNames(null);
        GaugeOptions options = (GaugeOptions)params.getOptions();
        Map properties = params.getProperties();
        boolean isStampedGauge = CommonGaugeHelper.isStampedGauge(properties);
        Document document = params.getOwnerDocument();
        Node node = params.getBindRoots();
        NodeList children = node.getChildNodes();
        Element gauge = null;
        CtrlValue ctrlValue = null;
        if (node != null && node.getNodeType() == 11) {
            children = node.getChildNodes();
            if (children != null && children.getLength() == 1) {
                Element elem = (Element)children.item(0);
                if (!isStampedGauge) {
                    ctrlValue = CommonGaugeHelper.getCtrlValue(elem, params);
                }
                if (elem.getTagName().equals(GAUGE)) {
                    gauge = elem;
                } else {
                    node.removeChild(elem);
                    params.getDtContext().findOrCreatePageDefinition().removeControlBinding((ControlBinding)ctrlValue);
                    ctrlValue = null;
                }
            }
        } else {
            gauge = (Element)node;
            if (gauge != null && !isStampedGauge) {
                ctrlValue = CommonGaugeHelper.getCtrlValue(gauge, params);
            }
        }
        if (gauge == null) {
            gauge = document.createElementNS(NAMESPACE, GAUGE);
            String strID = GaugeBindingUtilsCore.makeGaugeID((Node)gauge, (ADFDesignTimeContext)DvtDataBindingDtCoreUtils.getADFDesignTimeContext(params));
            DvtPatternOptionsUtils.setAttribute((Element)gauge, (String)"id", (String)strID);
            if (node != null && node.getNodeType() == 11) {
                node.appendChild(gauge);
            }
            if (isStampedGauge) {
                String gaugeType = (String)properties.get("gaugeType");
                String baseExpression = (String)properties.get("primitive:baseExpression");
                GaugeModelProvider modelProvider = (GaugeModelProvider)params.getModelProvider();
                String value = modelProvider.createCurrentValueExpression(baseExpression);
                String shortDesc = modelProvider.createShortDescriptionExpression(baseExpression);
                if (options.getGaugeType() == null) {
                    options.setGaugeType(gaugeType);
                }
                if (options.getExtendedProperties().getShortDesc() == null) {
                    options.getExtendedProperties().setShortDesc(shortDesc);
                }
                options.getExtendedProperties().setValue(value);
            }
        }
        options.applyChanges(params);
        if (isStampedGauge) {
            return BinderResult.OK;
        }
        DvtCoreProvider provider = (DvtCoreProvider)params.getModelProvider();
        if (ctrlValue == null) {
            ctrlValue = provider.getCtrlObject();
            PageDefinition pageDefinition = ctrlValue.getBindingContainer();
            String strIteratorBindingID = ctrlValue.getIteratorBinding().getId();
            String strAttribute = options.getBindingOptions().getMetricValue();
            ctrlValue = CommonGaugeHelper.addAttributeValuesBinding(pageDefinition, strIteratorBindingID, strAttribute);
        }
        DvtPatternOptionsUtils.setAttribute((Element)gauge, (String)"value", (String)provider.getValueExpression(ctrlValue));
        CommonGaugeHelper.updateLabels(options, gauge, ctrlValue);
        CommonGaugeHelper.updateBinding(provider, ctrlValue, options);
        return BinderResult.OK;
    }

    private static boolean isStampedGauge(Map<String, Object> properties) {
        boolean isStamped = false;
        if (properties != null && properties.get("primitive:baseExpression") != null) {
            isStamped = true;
        }
        return isStamped;
    }

    private static void updateLabels(GaugeOptions gaugeOptions, Element elementGauge, CtrlValue ctrlValue) {
        if (gaugeOptions != null) {
            CommonGaugeHelper.updateBottomLabel(gaugeOptions, elementGauge, ctrlValue);
            CommonGaugeHelper.updateTopLabel(gaugeOptions, elementGauge, ctrlValue);
        }
    }

    private static void updateLabelPosition(String strPosition, Node node) {
        if (node != null && node.getNodeType() == 1) {
            Element elementLabel = (Element)node;
            if (strPosition == null || strPosition.length() == 0) {
                elementLabel.removeAttributeNS(null, "position");
            } else {
                elementLabel.setAttributeNS(null, "position", strPosition);
            }
        }
    }

    private static void updateText(String strText, Node node) {
        if (node != null && node.getNodeType() == 1) {
            Element elementLabel = (Element)node;
            if (strText == null || strText.length() == 0) {
                elementLabel.removeAttributeNS(null, "text");
            } else {
                elementLabel.setAttributeNS(null, "text", strText);
            }
        }
    }

    private static String getMetricValue(GaugeOptions gaugeOptions) {
        String strMetricValue = null;
        if (gaugeOptions != null) {
            GaugeBindingOptions gaugeBindingOptions = gaugeOptions.getBindingOptions();
            strMetricValue = gaugeBindingOptions != null ? gaugeBindingOptions.getMetricValue() : null;
        }
        return strMetricValue;
    }

    public static String buildBaseHintProperty(String attribute, String property) {
        return JSFExpressionUtils.createBaseExpression((String)attribute, (String)"hints", (String)property);
    }

    private static void updateLabelText(GaugeOptions gaugeOptions, String strText, int nLabelOptions, Node nodeLabel) {
        if (nodeLabel != null && nodeLabel.getNodeType() == 1) {
            Element elementLabel = (Element)nodeLabel;
            switch (nLabelOptions) {
                case 0: {
                    CommonGaugeHelper.updateAttribute(strText, nodeLabel);
                    break;
                }
                case 1: {
                    strText = CommonGaugeHelper.buildBaseHintProperty(CommonGaugeHelper.getMetricValue(gaugeOptions), "label");
                    elementLabel.setAttributeNS(null, "text", strText);
                    break;
                }
                case 2: {
                    if (strText == null || strText.length() == 0) {
                        elementLabel.removeAttributeNS(null, "text");
                        break;
                    }
                    elementLabel.setAttributeNS(null, "text", strText);
                    break;
                }
            }
        }
    }

    private static void updateAttribute(String strBindingID, Node nodeLabel) {
        String expression = JSFExpressionUtils.createBaseExpression((String)strBindingID, (String)"inputValue");
        CommonGaugeHelper.updateText(expression, nodeLabel);
    }

    private static void updateBottomLabel(GaugeOptions gaugeOptions, Element elementGauge, CtrlValue ctrlValueGauge) {
        GaugeBottomLabel gaugeBottomLabel;
        GaugeBottomLabel gaugeBottomLabel2 = gaugeBottomLabel = gaugeOptions != null ? gaugeOptions.getGaugeBottomLabel() : null;
        if (gaugeBottomLabel != null) {
            String strLabel = gaugeBottomLabel.getLabel();
            GaugeBottomLabel.LabelOptions labelOptions = gaugeBottomLabel.getLabelOptions();
            Node nodeBottomLabel = CommonGaugeHelper.findOrCreateBottomLabel(strLabel, elementGauge);
            CommonGaugeHelper.updateLabelPosition(gaugeBottomLabel.getPosition(), nodeBottomLabel);
            int nLabelOptions = labelOptions != null ? labelOptions.ordinal() : -1;
            CommonGaugeHelper.updateLabelText(gaugeOptions, strLabel, nLabelOptions, nodeBottomLabel);
        }
    }

    static Node findChildNode(Node parent, String childName) {
        if (childName != null && parent != null) {
            DvtBaseElementObject.logMessageDebug((String)("Parent: " + parent.getNodeName()));
            NodeList childNodes = parent.getChildNodes();
            if (childNodes != null) {
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node child = childNodes.item(i);
                    DvtBaseElementObject.logMessageDebug((String)("Child: " + child.getNodeName()));
                    if (child != null && childName.equals(child.getLocalName())) {
                        DvtBaseElementObject.logMessageDebug((String)"\n");
                        return child;
                    }
                    ++i;
                }
            }
        }
        DvtBaseElementObject.logMessageDebug((String)"\n");
        return null;
    }

    private static Node findOrCreateBottomLabel(String strValue, Element elementGauge) {
        return CommonGaugeHelper.findOrCreateLabel(strValue, elementGauge, "bottomLabel");
    }

    private static Node findOrCreateTopLabel(String strValue, Element elementGauge) {
        return CommonGaugeHelper.findOrCreateLabel(strValue, elementGauge, "topLabel");
    }

    private static Node findOrCreateLabel(String strValue, Element elementGauge, String strType) {
        Node nodeLabel = null;
        if (elementGauge != null && (nodeLabel = CommonGaugeHelper.findChildNode(elementGauge, strType)) == null && !"".equals(strValue)) {
            nodeLabel = elementGauge.getOwnerDocument().createElementNS(NAMESPACE, strType);
            nodeLabel.setPrefix(DVT_PREFIX);
            elementGauge.appendChild(nodeLabel);
        }
        return nodeLabel;
    }

    private static void updateTopLabel(GaugeOptions gaugeOptions, Element elementGauge, CtrlValue ctrlValueGauge) {
        GaugeTopLabel gaugeTopLabel;
        GaugeTopLabel gaugeTopLabel2 = gaugeTopLabel = gaugeOptions != null ? gaugeOptions.getGaugeTopLabel() : null;
        if (gaugeTopLabel != null) {
            String strLabel = gaugeTopLabel.getLabel();
            GaugeTopLabel.LabelOptions labelOptions = gaugeTopLabel.getLabelOptions();
            Node nodeTopLabel = CommonGaugeHelper.findOrCreateTopLabel(strLabel, elementGauge);
            CommonGaugeHelper.updateLabelPosition(gaugeTopLabel.getPosition(), nodeTopLabel);
            int nLabelOptions = labelOptions != null ? labelOptions.ordinal() : -1;
            CommonGaugeHelper.updateLabelText(gaugeOptions, strLabel, nLabelOptions, nodeTopLabel);
        }
    }

    private static void updateAttribute(CtrlAttrs ctrlAttrs, String strName) {
        if (ctrlAttrs != null) {
            if (strName != null) {
                String[] strNames = new String[]{strName};
                ctrlAttrs.setAttrNames(strNames);
            } else {
                ctrlAttrs.setAttrNames(null);
            }
        }
    }

    private static void updateAttributes(CtrlAttrs ctrlAttrs, String[] strNames) {
        if (ctrlAttrs != null) {
            if (strNames != null && strNames.length > 0) {
                ctrlAttrs.setAttrNames(strNames);
            } else {
                ctrlAttrs.setAttrNames(null);
            }
        }
    }

    private static void updateBinding(DvtCoreProvider provider, CtrlAttrs ctrlAttrs, GaugeOptions gaugeOptions) {
        if (ctrlAttrs != null && gaugeOptions != null) {
            ctrlAttrs.setChangeEventPolicy(gaugeOptions.getBindingOptions().getChangeEventPolicy().toString());
            PageDefinition pageDefinition = ctrlAttrs.getBindingContainer();
            String strIteratorBindingID = ctrlAttrs.getIteratorBinding().getId();
            CommonGaugeHelper.isAccessorDefinition(provider);
            GaugeBindingOptions gaugeBindingOptions = gaugeOptions.getBindingOptions();
            if (gaugeBindingOptions != null) {
                String strMetricValue = gaugeBindingOptions.getMetricValue();
                if (pageDefinition != null) {
                    HashSet<String> hashSetAttributes = CommonGaugeHelper.getLabelAttributes(gaugeOptions, strMetricValue);
                    String strAttribute2 = null;
                    Node node = null;
                    for (String strAttribute2 : hashSetAttributes) {
                        node = DvtDataBindingDtCoreUtils.findNodeDeep((Node)pageDefinition.getElement(), (String)"attributeValues", (String)strAttribute2, null);
                        if (node != null) continue;
                        CommonGaugeHelper.addAttributeValuesBinding(pageDefinition, strIteratorBindingID, strAttribute2);
                    }
                }
            }
        }
    }

    private static CtrlAttrs makeCtrlAttrs(PageDefinition pageDefinition, String strIteratorBindingID, String strAttribute) {
        CtrlAttrs ctrlAttrs = null;
        if (pageDefinition != null && strIteratorBindingID != null && strAttribute != null) {
            HashMap<String, String> hashMapProperties = new HashMap<String, String>();
            hashMapProperties.put("IterBinding", strIteratorBindingID);
            hashMapProperties.put("id", strAttribute);
            ctrlAttrs = (CtrlAttrs)pageDefinition.createControlBinding("DCTextField", hashMapProperties);
            ctrlAttrs.setBindingContainer(pageDefinition);
        }
        return ctrlAttrs;
    }

    private static CtrlAttrs addAttributeValuesBinding(PageDefinition pageDefinition, String strIteratorBindingID, String strAttribute) {
        CtrlAttrs ctrlAttrs = null;
        if (pageDefinition != null && (ctrlAttrs = CommonGaugeHelper.makeCtrlAttrs(pageDefinition, strIteratorBindingID, strAttribute)) != null) {
            pageDefinition.addControlBinding((ControlBinding)ctrlAttrs);
            ctrlAttrs.addAttrName(strAttribute);
        }
        return ctrlAttrs;
    }

    private static String getLabelAttribute(GaugeBottomLabel gaugeBottomLabel, String strMetricValue) {
        String strLabelAttribute = null;
        if (gaugeBottomLabel != null) {
            if (gaugeBottomLabel.getLabelOptions() == GaugeBottomLabel.LabelOptions.ATTRIBUTE) {
                strLabelAttribute = gaugeBottomLabel.getLabel();
            } else if (gaugeBottomLabel.getLabelOptions() == GaugeBottomLabel.LabelOptions.METRIC_ATTRIBUTE) {
                strLabelAttribute = strMetricValue;
            }
        }
        return strLabelAttribute;
    }

    private static String getLabelAttribute(GaugeTopLabel gaugeTopLabel, String strMetricValue) {
        String strLabelAttribute = null;
        if (gaugeTopLabel != null) {
            if (gaugeTopLabel.getLabelOptions() == GaugeTopLabel.LabelOptions.ATTRIBUTE) {
                strLabelAttribute = gaugeTopLabel.getLabel();
            } else if (gaugeTopLabel.getLabelOptions() == GaugeTopLabel.LabelOptions.METRIC_ATTRIBUTE) {
                strLabelAttribute = strMetricValue;
            }
        }
        return strLabelAttribute;
    }

    private static HashSet<String> getLabelAttributes(GaugeOptions gaugeOptions, String strMetricValue) {
        HashSet<String> hashSetAttributes = new HashSet<String>();
        if (gaugeOptions != null) {
            String strLabelAttribute = CommonGaugeHelper.getLabelAttribute(gaugeOptions.getGaugeBottomLabel(), strMetricValue);
            if (strLabelAttribute != null) {
                hashSetAttributes.add(strLabelAttribute);
            }
            if ((strLabelAttribute = CommonGaugeHelper.getLabelAttribute(gaugeOptions.getGaugeTopLabel(), strMetricValue)) != null) {
                hashSetAttributes.add(strLabelAttribute);
            }
        }
        return hashSetAttributes;
    }

    private static boolean isAccessorDefinition(DvtCoreProvider provider) {
        int definitionType;
        NamedDefinition definition;
        boolean bRetVal = true;
        if (provider != null && (definition = provider.getDefinition()) != null && (30 == (definitionType = definition.getDefinitionType()) || 80 == definitionType)) {
            bRetVal = false;
        }
        return bRetVal;
    }

    private static void updateBinding(DvtCoreProvider provider, CtrlGauge ctrlGauge) {
        if (ctrlGauge != null) {
            GaugeDataMap dataMap = null;
            dataMap = (GaugeDataMap)ctrlGauge.getDataMap();
            if (dataMap == null) {
                dataMap = (GaugeDataMap)ctrlGauge.createDefaultDatamap();
                ctrlGauge.appendChild((ElementInterface)ctrlGauge);
            }
        }
    }

    private static void updateBinding(DvtCoreProvider provider, CtrlValue ctrlValue, GaugeOptions gaugeOptions) {
        if (ctrlValue instanceof CtrlAttrs) {
            CommonGaugeHelper.updateBinding(provider, (CtrlAttrs)ctrlValue, gaugeOptions);
        } else if (ctrlValue instanceof CtrlGauge) {
            CommonGaugeHelper.updateBinding(provider, (CtrlGauge)ctrlValue);
        }
    }

    static GaugeOptions populateOptions(BinderParams<? extends GaugeOptions> params, GaugeOptions options, Element gauge) {
        DvtDataBindingDtCoreUtils.setExistingNames(null);
        ArrayList<String> gaugePackages = new ArrayList<String>();
        gaugePackages.add("oracle.adfdt.view.dvt.binding.pattern.gauge");
        gaugePackages.add("oracle.adfdt.view.dvt.binding.pattern.common");
        options.getExtendedProperties().populateAttributesAndChildTags(gauge, gaugePackages);
        DvtCoreProvider provider = (DvtCoreProvider)params.getModelProvider();
        CtrlValue ctrlValue = CommonGaugeHelper.getCtrlValue(gauge, params);
        if (ctrlValue == null) {
            return options;
        }
        String policy = ctrlValue.getChangeEventPolicy();
        if (policy != null) {
            if (policy.equals(BindingOptions.ChangeEventPolicy.ppr.toString())) {
                options.getBindingOptions().setChangeEventPolicy(BindingOptions.ChangeEventPolicy.ppr);
            } else if (policy.equals(BindingOptions.ChangeEventPolicy.none.toString())) {
                options.getBindingOptions().setChangeEventPolicy(BindingOptions.ChangeEventPolicy.none);
            } else if (policy.equals(BindingOptions.ChangeEventPolicy.push.toString())) {
                options.getBindingOptions().setChangeEventPolicy(BindingOptions.ChangeEventPolicy.push);
            } else {
                options.getBindingOptions().setChangeEventPolicy(BindingOptions.ChangeEventPolicy.ppr);
            }
        }
        CommonGaugeHelper.updateBinding(provider, ctrlValue, options);
        return options;
    }

    private static CtrlValue getCtrlValue(Element graph, CreatorParams params) {
        String valueExpression = DvtPatternOptionsUtils.getAttribute((Element)graph, (String)"value");
        String bindingId = JSFExpressionUtils.getBindingIdFromExpression((String)valueExpression);
        return (CtrlValue)params.getDtContext().findOrCreatePageDefinition().findControlBinding(bindingId);
    }

    private static GaugeBindingOptions getGaugeBindingOptions(GaugeOptions gaugeOptions) {
        return gaugeOptions != null ? gaugeOptions.getBindingOptions() : null;
    }
}

