/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.util;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DefaultPrefixLookup;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.MetadataProvidedDefaultPrefixLookup;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.helpers.NamespaceSupport;

public final class NamespaceUtils {
    private static final String _XML_NS = "xmlns";
    private static final String _XML_NS_COLON = "xmlns:";
    private static final String _XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String _XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";

    private NamespaceUtils() {
    }

    public static Map<String, String> getPrefixesInScope(Node node) {
        HashMap<String, String> map = new HashMap<String, String>();
        NamespaceUtils._addPrefixesInScope(map, node);
        return map;
    }

    public static final void fixPrefixes(Node parent, Node subTree, DefaultPrefixLookup lookup) {
        NamespaceUtils.fixPrefixes(parent, subTree, lookup, true);
    }

    public static final void fixPrefixes(Node parent, Node subTree, DefaultPrefixLookup lookup, boolean declarePrefixesOnRoot) {
        Document ownerDoc;
        if (subTree == null) {
            throw new IllegalArgumentException("Node is null");
        }
        if (lookup == null) {
            throw new IllegalArgumentException("Prefix lookup is null");
        }
        if (subTree.getParentNode() == parent && declarePrefixesOnRoot) {
            throw new IllegalArgumentException("subTree shouldn't already be in doc");
        }
        if (subTree.getNodeType() != 1 && subTree.getNodeType() != 2) {
            return;
        }
        if (subTree.getNodeType() == 2 && parent.getNodeType() != 1) {
            throw new IllegalArgumentException("can't add an attribute to a non-element parent");
        }
        NamespaceSupportAdapter ns = new NamespaceSupportAdapter();
        ns.pushContext();
        String defaultNamespace = null;
        Node current = parent;
        while (current != null) {
            NamedNodeMap attrs;
            if (current.getNodeType() == 1 && (attrs = current.getAttributes()) != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    Node attr = attrs.item(i);
                    String key = attr.getNodeName();
                    if (key.startsWith(_XML_NS_COLON) && !ns.containsURI(attr.getNodeValue()) && !ns.containsPrefix(key.substring(6))) {
                        String keyInsert = key.substring(6);
                        ns.declarePrefix(keyInsert, attr.getNodeValue());
                    } else if (_XML_NS.equals(key) && defaultNamespace == null) {
                        defaultNamespace = attr.getNodeValue();
                    }
                    ++i;
                }
            }
            current = current.getParentNode();
        }
        if (defaultNamespace != null) {
            ns.declarePrefix("", defaultNamespace);
        }
        if (parent != null && (ownerDoc = parent.getOwnerDocument()) != null) {
            Element documentRoot = ownerDoc.getDocumentElement();
            if (documentRoot == null) {
                documentRoot = (Element)subTree;
            }
            Element elementForPrefixDeclarations = documentRoot;
            if (!declarePrefixesOnRoot) {
                elementForPrefixDeclarations = NamespaceUtils.isElement(subTree) ? (Element)subTree : (Element)parent;
            }
            NamespaceUtils._fixPrefixesRecursively(ns, parent, subTree, documentRoot, elementForPrefixDeclarations, lookup);
        }
    }

    private static final void _fixPrefixesRecursively(NamespaceSupportAdapter ns, Node parent, Node current, Element documentRoot, Element elementForPrefixDeclarations, DefaultPrefixLookup lookup) {
        NamedNodeMap attrs;
        String name;
        Node a;
        NamedNodeMap attrs2;
        boolean elemNode;
        String namespace = current.getNamespaceURI();
        String currentDefaultNamespace = ns.getURI("");
        ns.pushContext();
        if (current.getNodeType() == 2 && (_XMLNS_NAMESPACE.equals(namespace) || _XML_NAMESPACE.equals(namespace))) {
            return;
        }
        boolean bl = elemNode = current.getNodeType() == 1;
        if (namespace == null || currentDefaultNamespace == null || !namespace.equals(currentDefaultNamespace)) {
            String foundpfx = ns.getPrefix(namespace);
            String defpfx = namespace != null ? lookup.getDefaultPrefix(namespace) : null;
            String origPrefix = current.getPrefix();
            String newprefix = null;
            String foundConflictURI = ns.getURI(foundpfx);
            String origConflictURI = ns.getURI(origPrefix);
            String defConflictURI = ns.getURI(defpfx);
            if (foundpfx != null && (foundConflictURI == null || foundConflictURI.equals(namespace))) {
                newprefix = foundpfx;
            } else if (origPrefix != null && (origConflictURI == null || origConflictURI.equals(namespace) || namespace == null)) {
                newprefix = origPrefix;
            } else if (defpfx != null && (defConflictURI == null || defConflictURI.equals(namespace))) {
                newprefix = defpfx;
            }
            boolean shouldAddPrefix = true;
            if (documentRoot == current) {
                shouldAddPrefix = false;
            }
            if (newprefix != null && shouldAddPrefix) {
                if (!newprefix.equals(origPrefix)) {
                    current.setPrefix(newprefix);
                }
                if (elemNode) {
                    if (newprefix.equals(origPrefix) && ((Element)current).hasAttribute(_XML_NS_COLON + origPrefix)) {
                        ((Element)current).removeAttribute(_XML_NS_COLON + origPrefix);
                    } else if (((Element)current).hasAttribute(_XML_NS)) {
                        ((Element)current).removeAttribute(_XML_NS);
                    }
                }
                if (!newprefix.equals(foundpfx)) {
                    elementForPrefixDeclarations.setAttributeNS(_XMLNS_NAMESPACE, _XML_NS_COLON + newprefix, namespace);
                }
            } else if (elemNode) {
                String prefix = current.getPrefix();
                if (prefix != null) {
                    if (((Element)current).hasAttribute(_XML_NS_COLON + prefix)) {
                        ((Element)current).removeAttribute(_XML_NS_COLON + prefix);
                    }
                    current.setPrefix(null);
                }
                if (namespace != null || currentDefaultNamespace != null) {
                    String newNS = namespace == null ? "" : namespace;
                    ((Element)current).setAttributeNS(_XMLNS_NAMESPACE, _XML_NS, newNS);
                }
            }
        } else if (parent != null && namespace.equals(parent.getNamespaceURI())) {
            String pPrefix;
            if (elemNode) {
                String origPrefix = current.getPrefix();
                if (origPrefix != null) {
                    if (((Element)current).hasAttribute(_XML_NS_COLON + origPrefix)) {
                        ((Element)current).removeAttribute(_XML_NS_COLON + origPrefix);
                    }
                    current.setPrefix(null);
                } else if (((Element)current).hasAttribute(_XML_NS)) {
                    ((Element)current).removeAttribute(_XML_NS);
                }
            }
            if ((pPrefix = parent.getPrefix()) != null) {
                current.setPrefix(pPrefix);
            }
            if (elemNode && (attrs2 = current.getAttributes()) != null) {
                int i = 0;
                while (i < attrs2.getLength()) {
                    a = attrs2.item(i);
                    name = a.getNodeValue();
                    if (name.startsWith(_XML_NS_COLON) && name.equals(current.getNamespaceURI())) {
                        ((Element)current).removeAttributeNode((Attr)a);
                    }
                    ++i;
                }
            }
        } else {
            String oldPref = current.getPrefix();
            current.setPrefix(null);
            if (elemNode) {
                if (((Element)current).hasAttribute(_XML_NS)) {
                    ((Element)current).removeAttribute(_XML_NS);
                }
                if (oldPref != null && (attrs2 = current.getAttributes()) != null) {
                    int i = 0;
                    while (i < attrs2.getLength()) {
                        a = attrs2.item(i);
                        name = a.getNodeValue();
                        if (name.startsWith(_XML_NS) && name.equals(current.getNamespaceURI())) {
                            ((Element)current).removeAttributeNode((Attr)a);
                        }
                        ++i;
                    }
                }
            }
        }
        if (current.getNodeType() == 1 && (attrs = current.getAttributes()) != null) {
            String name2;
            Node a2;
            int i = 0;
            while (i < attrs.getLength()) {
                a2 = attrs.item(i);
                name2 = a2.getNodeName();
                if (name2.startsWith(_XML_NS_COLON)) {
                    String keyInsert = name2.substring(6);
                    ns.declarePrefix(keyInsert, a2.getNodeValue());
                } else if (_XML_NS.equals(name2)) {
                    ns.declarePrefix("", a2.getNodeValue());
                }
                ++i;
            }
            i = 0;
            while (i < attrs.getLength()) {
                int index;
                a2 = attrs.item(i);
                name2 = a2.getNodeName();
                if (!(name2.startsWith(_XML_NS_COLON) || _XML_NAMESPACE.equals(a2.getNamespaceURI()) || _XMLNS_NAMESPACE.equals(a2.getNamespaceURI()) || (index = name2.indexOf(58)) == -1)) {
                    String ans = a2.getNamespaceURI();
                    if (ans != null) {
                        String apfx = name2.substring(0, index);
                        if (ns.containsURI(ans)) {
                            a2.setPrefix(ns.getPrefix(ans));
                        } else {
                            Element attrParent = ((Attr)a2).getOwnerElement();
                            attrParent.setAttributeNS(_XMLNS_NAMESPACE, _XML_NS_COLON + apfx, ans);
                            ns.declarePrefix(apfx, ans);
                        }
                    } else {
                        a2.setPrefix(null);
                    }
                }
                ++i;
            }
        }
        Node child = current.getFirstChild();
        while (child != null) {
            NamespaceUtils._fixPrefixesRecursively(ns, current, child, documentRoot, elementForPrefixDeclarations, lookup);
            child = child.getNextSibling();
        }
        ns.popContext();
    }

    private static void _addPrefixesInScope(Map<String, String> map, Node node) {
        NamedNodeMap attrs;
        if (node == null) {
            return;
        }
        NamespaceUtils._addPrefixesInScope(map, node.getParentNode());
        if (NamespaceUtils.isElement(node) && (attrs = node.getAttributes()) != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                Attr attr = (Attr)attrs.item(i);
                String qname = attr.getNodeName();
                if (qname != null) {
                    if (_XML_NS.equals(qname)) {
                        map.put("", attr.getValue());
                    } else if (qname.startsWith(_XML_NS_COLON)) {
                        String prefixName = NamespaceUtils.getLocalName(attr);
                        map.put(prefixName, attr.getValue());
                    }
                }
                ++i;
            }
        }
    }

    private static boolean isNodeType(Node node, int type) {
        return node != null && node.getNodeType() == type;
    }

    private static boolean isElement(Node node) {
        return NamespaceUtils.isNodeType(node, 1);
    }

    private static String getLocalName(Node node) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    if (node.getNamespaceURI() == null) {
                        return node.getNodeName();
                    }
                    return node.getLocalName();
                }
            }
        }
        return null;
    }

    public static void ensureNamespacesSet(IProject project, Document document, Node node, boolean declarePrefixesOnRoot) {
        if (document != null && node != null) {
            NamespaceUtils.fixPrefixes(document.getDocumentElement(), node, new MetadataProvidedDefaultPrefixLookup(project), declarePrefixesOnRoot);
        }
    }

    private static class NamespaceSupportAdapter
    extends NamespaceSupport {
        private NamespaceSupportAdapter() {
        }

        @Override
        public String getPrefix(String uri) {
            if (uri == null) {
                return null;
            }
            return super.getPrefix(uri);
        }

        @Override
        public String getURI(String pfx) {
            if (pfx == null) {
                return null;
            }
            return super.getURI(pfx);
        }

        public boolean containsPrefix(String pfx) {
            return this.getURI(pfx) != null;
        }

        public boolean containsURI(String uri) {
            return this.getPrefix(uri) != null;
        }
    }
}

