/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.util;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.FileMaker;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.DTRTvCommonBundle;
import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.Pair;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DTRTvCommonUtil {
    private DTRTvCommonUtil() {
    }

    public static java.net.URI getPlatformResourceURI(IResource resource) {
        return resource != null ? java.net.URI.create(URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true).toString()) : null;
    }

    public static IFile getFile(java.net.URI platformResourceURI) {
        IPath path = DTRTvCommonUtil.getPath(platformResourceURI);
        return path != null ? ResourcesPlugin.getWorkspace().getRoot().getFile(path) : null;
    }

    public static IPath getPath(java.net.URI platformResourceURI) {
        URI emfURI;
        if (platformResourceURI != null && (emfURI = URI.createURI((String)platformResourceURI.toString())).isPlatformResource()) {
            return new Path(emfURI.toPlatformString(true));
        }
        return null;
    }

    public static String computeUniqueValue(Document document, String attributeName, String baseValue) {
        Collection<String> values = DTRTvCommonUtil.collectValues(document, attributeName);
        String value = baseValue;
        int i = 0;
        while (values.contains(value)) {
            value = String.valueOf(baseValue) + ++i;
        }
        return value;
    }

    public static Collection<String> collectValues(Document document, String attributeName) {
        HashSet<String> values = new HashSet<String>();
        DTRTvCommonUtil.collectValues(values, document.getDocumentElement(), attributeName);
        return values;
    }

    public static void collectValues(Collection<String> values, Node node, String attributeName) {
        String id;
        if (1 == node.getNodeType() && !DTRTUtil.isEmpty((String)(id = ((Element)node).getAttributeNS(null, attributeName)))) {
            values.add(id);
        }
        Node child = node.getFirstChild();
        while (child != null) {
            DTRTvCommonUtil.collectValues(values, child, attributeName);
            child = child.getNextSibling();
        }
    }

    public static boolean isSameOrParent(Node candidate, Node node) {
        if (candidate != null && node != null) {
            if (candidate instanceof Document) {
                return candidate == node.getOwnerDocument();
            }
            Node parent = node;
            while (parent != null) {
                if (candidate == parent) {
                    return true;
                }
                parent = parent.getParentNode();
            }
        }
        return false;
    }

    public static String removeFileExtension(String name) {
        if (name != null) {
            int index = name.lastIndexOf(46);
            return index > 0 ? name.substring(0, index) : name;
        }
        return null;
    }

    public static String computePackageName(IPath packagePath, String sourceLevel, String complianceLevel) {
        if (packagePath != null && sourceLevel != null && complianceLevel != null) {
            StringBuilder pkgName = new StringBuilder();
            String[] stringArray = packagePath.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (JavaConventions.validateIdentifier((String)segment, (String)sourceLevel, (String)complianceLevel).getSeverity() != 4) {
                    pkgName.append('.').append(segment);
                }
                ++n2;
            }
            if (pkgName.length() > 0) {
                return pkgName.substring(1);
            }
        }
        return null;
    }

    public static String computeFullName(IProject project, String packagePath) {
        String complianceLevel;
        String sourceLevel;
        Path path;
        String pkg;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject.exists() && (pkg = DTRTvCommonUtil.computePackageName((IPath)(path = new Path(packagePath)), sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true), complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true))) != null) {
            String name = path.lastSegment();
            String fileExtension = path.getFileExtension();
            if (fileExtension != null) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            return String.valueOf(pkg) + '.' + name;
        }
        return null;
    }

    public static String getSimpleName(String className) {
        int index;
        if (className != null && 1 < (index = className.lastIndexOf(46) + 1) && index < className.length()) {
            String name = className.substring(index);
            return name;
        }
        return className;
    }

    public static IAppClassLoaderProvider.IClassLoader getClassLoader(IResource resource) {
        IAppClassLoaderProvider classLoaderProvider;
        Project oepeProject;
        IProject project;
        if (resource != null && (project = resource.getProject()) != null && (oepeProject = (Project)project.getAdapter(Project.class)) != null && (classLoaderProvider = (IAppClassLoaderProvider)oepeProject.getAppService(IAppClassLoaderProvider.class)) != null) {
            return classLoaderProvider.getAppClassLoader();
        }
        return null;
    }

    public static DocumentFragment createDocumentFragment(Document document, Map<String, String> namespaces, String text) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<bogusRoot");
        if (namespaces != null) {
            for (Map.Entry<String, String> entry : namespaces.entrySet()) {
                buffer.append(" xmlns:");
                buffer.append(entry.getKey());
                buffer.append("=\"");
                buffer.append(entry.getValue());
                buffer.append("\"");
            }
        }
        buffer.append('>');
        buffer.append(text);
        buffer.append("</bogusRoot>");
        Document tempDocument = null;
        try {
            InputSource is = new InputSource(new StringReader(buffer.toString()));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            tempDocument = docBuilder.parse(is);
        }
        catch (ParserConfigurationException e) {
            DTRTvCommonBundle.log(e);
            return null;
        }
        catch (IOException e) {
            DTRTvCommonBundle.log(e);
            return null;
        }
        catch (SAXException e) {
            DTRTvCommonBundle.log(e);
            return null;
        }
        if (tempDocument == null) {
            return null;
        }
        DocumentFragment documentFragment = document.createDocumentFragment();
        Node child = tempDocument.getDocumentElement().getFirstChild();
        while (child != null) {
            Object imported;
            Object object = imported = document instanceof IDOMDocument ? DTRTvCommonUtil.adoptNode((IDOMDocument)document, child) : document.importNode(child, true);
            if (imported != null) {
                documentFragment.appendChild((Node)imported);
            }
            child = child.getNextSibling();
        }
        return documentFragment;
    }

    private static IDOMNode adoptNode(IDOMDocument document, Node node) {
        if (node instanceof Element) {
            IDOMNode adopted = (IDOMNode)document.createElementNS(node.getNamespaceURI(), node.getNodeName());
            NamedNodeMap attributes = node.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Node item = attributes.item(i);
                if (item instanceof Attr) {
                    Attr attribute = document.createAttributeNS(item.getNamespaceURI(), item.getNodeName());
                    attribute.setNodeValue(item.getNodeValue());
                    adopted.getAttributes().setNamedItemNS(attribute);
                }
                ++i;
            }
            Node child = node.getFirstChild();
            while (child != null) {
                IDOMNode adoptedChild = DTRTvCommonUtil.adoptNode(document, child);
                if (adoptedChild != null) {
                    adopted.appendChild((Node)adoptedChild);
                }
                child = child.getNextSibling();
            }
            return adopted;
        }
        return null;
    }

    public static String computeFeatureKey(EStructuralFeature feature, EClass owner) {
        return String.format("_UI_%s_%s_feature", owner.getName(), feature.getName());
    }

    public static ImageManager.IImageData createImageData(final String bundlePath) {
        return new ImageManager.IImageData(){
            private URL url;

            public String getKey() {
                return "oracle.eclipse.tools.adf.dtrt.vcommon" + bundlePath;
            }

            public byte[] toBytes() {
                if (this.url == null) {
                    this.url = DTRTvCommonBundle.getResourceURL(bundlePath);
                }
                if (this.url != null) {
                    try {
                        return DTRTUtil.read((URL)this.url);
                    }
                    catch (IOException e) {
                        DTRTvCommonBundle.log(e);
                    }
                }
                return null;
            }
        };
    }

    public static java.net.URI createWidgetURI(Object ... segments) {
        if (segments.length == 0) {
            throw new IllegalArgumentException("The widget URI must have at least one segment.");
        }
        StringBuilder sb = new StringBuilder("widget://");
        sb.append(URI.encodeAuthority((String)"oracle.eclipse.tools.adf.dtrt.vcommon", (boolean)false));
        Object[] objectArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            Object segment = objectArray[n2];
            sb.append('/').append(URI.encodeSegment((String)segment.toString(), (boolean)false));
            ++n2;
        }
        return java.net.URI.create(sb.toString());
    }

    public static IFileMarker createFileMarker(IFile file, String type, int charStart, int charEnd, int lineNumber) {
        if (lineNumber >= 0 || charStart >= 0 && charEnd > charStart) {
            return new FileMaker(file, type, charStart, charEnd, lineNumber);
        }
        return new FileMaker(file, type);
    }

    public static IObject getRootObject(IObject object) {
        if (object != null) {
            while (true) {
                if (object.getParent() == null) {
                    return object;
                }
                object = object.getParent();
            }
        }
        return null;
    }

    public static IType getLocalInterface(SessionBean sessionBean, IType sessionBeanType) throws CoreException {
        for (String local : sessionBean.getBusinessLocals()) {
            IType localInterface = sessionBeanType.getJavaProject().findType(local);
            if (localInterface == null || !sessionBeanType.getJavaProject().equals(localInterface.getJavaProject())) continue;
            return localInterface;
        }
        return null;
    }

    public static Pair<SessionBean, String> getSessionBean(IType type) throws CoreException {
        IResource resource;
        if (type != null && !type.isInterface() && (resource = type.getResource()) != null) {
            String name = type.getFullyQualifiedName();
            Pair<List<SessionBean>, String> pair = DTRTvCommonUtil.getSessionBeans(resource.getProject());
            if (pair != null) {
                for (SessionBean sessionBean : (List)pair.getFirst()) {
                    if (!name.equals(sessionBean.getEjbClass())) continue;
                    return new Pair((Object)sessionBean, (Object)((String)pair.getSecond()));
                }
            }
        }
        return null;
    }

    public static Collection<? extends IType> getSessionBeanTypes(IProject project) {
        Pair<List<SessionBean>, String> sessionBeans = DTRTvCommonUtil.getSessionBeans(project);
        if (sessionBeans != null && !((List)sessionBeans.getFirst()).isEmpty()) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            HashSet<IType> types = new HashSet<IType>();
            for (SessionBean sessionBean : (List)sessionBeans.getFirst()) {
                if (sessionBean.getBusinessLocals() == null || sessionBean.getBusinessLocals().isEmpty() || sessionBean.getEjbClass() == null) continue;
                try {
                    IType type = javaProject.findType(sessionBean.getEjbClass());
                    if (type == null || !project.equals((Object)type.getResource().getProject())) continue;
                    types.add(type);
                }
                catch (JavaModelException javaModelException) {}
            }
            return types;
        }
        return Collections.emptySet();
    }

    private static Pair<List<SessionBean>, String> getSessionBeans(IProject project) {
        EJBJar ejbJar;
        EnterpriseBeans enterpriseBeans;
        IModelProvider provider;
        Object modelObject;
        if (project != null && JavaEEProjectUtilities.isEJBProject((IProject)project) && (modelObject = (provider = ModelProviderManager.getModelProvider((IProject)project)).getModelObject()) instanceof EJBJar && (enterpriseBeans = (ejbJar = (EJBJar)modelObject).getEnterpriseBeans()) != null) {
            String ejbVersion = ejbJar.getVersion();
            if (ejbVersion == null) {
                ejbVersion = "NOT SPECIFIED";
            }
            return new Pair((Object)enterpriseBeans.getSessionBeans(), (Object)ejbVersion);
        }
        return null;
    }
}

