/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.util;

import java.net.URI;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescribableDecorator;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;

public abstract class BaseObject<T>
extends BaseDescribableDecorator<T>
implements IObject {
    private URI uri;

    protected BaseObject(T decoratedObject) {
        super(decoratedObject);
    }

    protected BaseObject(T decoratedObject, String label) {
        super(decoratedObject, label);
    }

    protected abstract URI computeURI();

    public void dispose() {
        this.uri = null;
        super.dispose();
    }

    public final URI getURI() {
        if (!this.isDisposed()) {
            if (this.uri == null) {
                this.uri = this.computeURI();
                if (this.uri == null) {
                    throw new IllegalStateException("The URI of an object cannot be null.");
                }
            }
            return this.uri;
        }
        return null;
    }

    protected String getToolTipText() {
        return this.getLabel();
    }

    public final int compareTo(IObject o) {
        return DTRTUtil.compare((Object)DTRTUtil.getLabel((IDescribable)this), (Object)DTRTUtil.getLabel((IDescribable)o));
    }

    protected final int baseObjectHashCode() {
        int result = this.baseHashCode();
        result = 31 * result + (this.getURI() == null ? 0 : this.getURI().hashCode());
        return result;
    }

    protected final boolean baseObjectEquals(Object obj) {
        return super.baseEquals(obj) && DTRTUtil.equals((Object)this.getURI(), (Object)((BaseObject)((Object)obj)).getURI());
    }
}

