/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.util;

import java.io.IOException;
import java.io.OutputStream;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;

public class AssertEqualBytesOutputStream
extends OutputStream {
    private byte[] expected;
    private int count;
    private int[] filteredBytes;

    public AssertEqualBytesOutputStream(byte[] expected) throws IllegalArgumentException {
        if (expected == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this.expected = expected;
    }

    public AssertEqualBytesOutputStream(byte[] expected, int[] filteredBytes) throws IllegalArgumentException {
        this(expected);
        this.filteredBytes = filteredBytes;
    }

    @Override
    public synchronized void write(int b) throws AssertionError {
        if (this.count == this.expected.length && !this.isFilteredByte(b)) {
            throw new AssertionError(this.count);
        }
        if (this.expected[this.count] == b) {
            ++this.count;
            return;
        }
        if (this.isFilteredByte(b)) {
            return;
        }
        if (this.isFilteredByte(this.expected[this.count])) {
            ++this.count;
            while (this.isFilteredByte(this.expected[this.count])) {
                ++this.count;
            }
            this.write(b);
            return;
        }
        throw new AssertionError(this.count);
    }

    private boolean isFilteredByte(int b) {
        return this.filteredBytes != null && DTRTUtil.indexOf((int[])this.filteredBytes, (int)b) >= 0;
    }

    @Override
    public void write(byte[] b) throws AssertionError {
        try {
            super.write(b);
        }
        catch (IOException iOException) {}
    }

    @Override
    public void write(byte[] b, int off, int len) throws AssertionError {
        try {
            super.write(b, off, len);
        }
        catch (IOException iOException) {}
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

