/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.faces;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.ISelectOneOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.AbstractWizardPage;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.faces.SelectOneOptionsComposite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class SelectOneOptionsPage
extends AbstractWizardPage
implements PropertyChangeListener {
    private final ISelectOneOptionsModel _optionsModel;
    private final IOptionsMapper _optionsMapper;
    private SelectOneOptionsComposite _optionsComposite;
    private boolean _isComplete = false;

    public SelectOneOptionsPage(String pageName, String helpContextID, IOptionsMapper optionsMapper) {
        super(pageName, helpContextID);
        this._optionsMapper = optionsMapper;
        this._optionsModel = (ISelectOneOptionsModel)optionsMapper.getModel();
    }

    protected ISelectOneOptionsModel getModel() {
        return this._optionsModel;
    }

    private String getPageTitle() {
        return Messages.SelectOneOptionsPage_title;
    }

    private String getPageDescription() {
        return Messages.SelectOneOptionsPage_description;
    }

    public void createControl(Composite parent) {
        this._optionsComposite = this.createOptionsComposite(parent);
        this._optionsComposite.addPropertyChangeListener(this);
        this.setControl((Control)this._optionsComposite);
        IStatus status = this._optionsMapper.validateModel();
        if (status == null || status.getSeverity() != 4) {
            this._isComplete = true;
        }
        if (this.helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp((Control)this._optionsComposite, this.helpContextID);
        }
    }

    private SelectOneOptionsComposite createOptionsComposite(Composite parent) {
        return new SelectOneOptionsComposite(parent, 0, this.getModel());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this._optionsComposite.updateLayout();
            this.setTitle(this.getPageTitle());
            this.setDescription(this.getPageDescription());
        }
        super.setVisible(visible);
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    protected IStatus getStatus() {
        IStatus status = this._optionsMapper.validateModel();
        this._isComplete = status == null || status.getSeverity() != 4;
        return status;
    }

    public boolean isPageComplete() {
        return this._isComplete;
    }

    public void setPageComplete(boolean complete) {
        this._isComplete = complete;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateStatus();
    }
}

