/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.faces;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DataControlObjectContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.SelectDataControlObjectDialog;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewerComparator;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.ISelectOneOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ModelChangeComposite;
import oracle.eclipse.tools.common.ui.CommonImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectOneOptionsComposite
extends ModelChangeComposite<ISelectOneOptionsModel> {
    private Text _listDataSourceValue;
    private Button _listDataSourceButton;
    private ComboViewer _listAttrControl;
    private ComboViewer _displayAttrControl;

    public SelectOneOptionsComposite(Composite parent, int style, ISelectOneOptionsModel model) {
        super(parent, style, model);
        this.setFont(parent.getFont());
        this.setLayoutData(new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        this.createListTypeComposite(this);
    }

    private void createListTypeComposite(Composite parent) {
        Label listTypeLabel = new Label(parent, 0);
        if (((ISelectOneOptionsModel)this.getModel()).hasModelListBinding()) {
            listTypeLabel.setText(Messages.SelectOneOptionsPage_modelDrivenTypeLabel);
        } else {
            listTypeLabel.setText(Messages.SelectOneOptionsPage_dynamicTypeLabel);
        }
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.horizontalSpan = 3;
        data.verticalIndent = 10;
        listTypeLabel.setLayoutData((Object)data);
        this.createTargetAttributeControls(parent);
        if (((ISelectOneOptionsModel)this.getModel()).hasModelListBinding()) {
            this.createModelDrivenListComposite(parent);
        } else {
            this.createDynamicListComposite(parent);
            this.addListeners();
        }
    }

    private void createTargetAttributeControls(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(Messages.SelectOneOptionsPage_boundDataSourceLabel);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.verticalIndent = 5;
        label.setLayoutData((Object)data);
        Text targetEditor = new Text(parent, 8);
        targetEditor.setText(((ISelectOneOptionsModel)this.getModel()).getTargetAttributeName());
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        data.verticalIndent = 5;
        targetEditor.setLayoutData((Object)data);
    }

    private void createDynamicListComposite(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.SelectOneOptionsPage_listDataSourceLabel);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.verticalIndent = 5;
        label.setLayoutData((Object)data);
        this._listDataSourceValue = new Text(parent, 2052);
        this._listDataSourceValue.setEditable(false);
        data = new GridData(4, 0x1000000, true, false);
        data.verticalIndent = 5;
        this._listDataSourceValue.setLayoutData((Object)data);
        this._listDataSourceButton = new Button(parent, 8);
        this._listDataSourceButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        this._listDataSourceButton.setToolTipText(Messages.SelectOneOptionsPage_listDataSourceToolTip);
        data = new GridData(4, 0x1000000, false, false);
        data.verticalIndent = 5;
        this._listDataSourceButton.setLayoutData((Object)data);
        label = new Label(parent, 16384);
        label.setText(Messages.SelectOneOptionsPage_listAttributeLabel);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this._listAttrControl = new ComboViewer(parent, 0x800808);
        this._listAttrControl.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._listAttrControl.setContentProvider((IContentProvider)new DataControlObjectContentProvider());
        this._listAttrControl.setLabelProvider((IBaseLabelProvider)new DescribableLabelProvider());
        this._listAttrControl.setComparator((ViewerComparator)new DescribableViewerComparator());
        Label gridPlaceHolder = new Label(parent, 0);
        gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridPlaceHolder.setVisible(false);
        label = new Label(parent, 16384);
        label.setText(Messages.SelectOneOptionsPage_displayAttributeLabel);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this._displayAttrControl = new ComboViewer(parent, 0x800808);
        this._displayAttrControl.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._displayAttrControl.setContentProvider((IContentProvider)new DataControlObjectContentProvider());
        this._displayAttrControl.setLabelProvider((IBaseLabelProvider)new DescribableLabelProvider());
        this._displayAttrControl.setComparator((ViewerComparator)new DescribableViewerComparator());
        gridPlaceHolder = new Label(parent, 0);
        gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridPlaceHolder.setVisible(false);
    }

    private void createModelDrivenListComposite(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(Messages.SelectOneOptionsPage_listBindingLabel);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.verticalIndent = 5;
        label.setLayoutData((Object)data);
        Text targetEditor = new Text(parent, 8);
        String modelListName = ((ISelectOneOptionsModel)this.getModel()).getModelListBindingName();
        targetEditor.setText(modelListName == null ? "" : modelListName);
        data = new GridData(4, 0x1000000, true, false);
        data.verticalIndent = 5;
        targetEditor.setLayoutData((Object)data);
    }

    protected void addListeners() {
        this._listDataSourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDataControlObject dcObject;
                SelectDataControlObjectDialog dialog = new SelectDataControlObjectDialog(e.display.getActiveShell(), SelectOneOptionsComposite.this.getDataControls());
                dialog.setSelectionValidator(new SelectDataControlObjectDialog.ISelectionValidator(){

                    public boolean isValidSelection(SelectDataControlObjectDialog dialog, IDataControlObject selection) {
                        return selection != null && ((ISelectOneOptionsModel)SelectOneOptionsComposite.this.getModel()).validListDataSource(selection);
                    }
                });
                if (dialog.open() == 0 && (dcObject = dialog.getSelection()) != null && !DTRTUtil.equals((Object)dcObject, (Object)((ISelectOneOptionsModel)SelectOneOptionsComposite.this.getModel()).getListDataSource())) {
                    ((ISelectOneOptionsModel)SelectOneOptionsComposite.this.getModel()).setListDataSource(dcObject);
                    SelectOneOptionsComposite.this._listDataSourceValue.setText(SelectOneOptionsComposite.getDataControlObjDisplayName(dcObject));
                    List<? extends IDataControlObject> childAttrs = ((ISelectOneOptionsModel)SelectOneOptionsComposite.this.getModel()).getChildAttributes(dcObject);
                    SelectOneOptionsComposite.this._listAttrControl.setInput(childAttrs);
                    SelectOneOptionsComposite.this._displayAttrControl.setInput(childAttrs);
                    if (!childAttrs.isEmpty()) {
                        SelectOneOptionsComposite.this._listAttrControl.getCombo().select(0);
                        ((ISelectOneOptionsModel)SelectOneOptionsComposite.this.getModel()).setListAttribute(SelectOneOptionsComposite.this.getSelection(SelectOneOptionsComposite.this._listAttrControl));
                        SelectOneOptionsComposite.this._displayAttrControl.getCombo().select(0);
                        ((ISelectOneOptionsModel)SelectOneOptionsComposite.this.getModel()).setDisplayAttribute(SelectOneOptionsComposite.this.getSelection(SelectOneOptionsComposite.this._displayAttrControl));
                    } else {
                        ((ISelectOneOptionsModel)SelectOneOptionsComposite.this.getModel()).setListAttribute(null);
                        ((ISelectOneOptionsModel)SelectOneOptionsComposite.this.getModel()).setDisplayAttribute(null);
                    }
                    SelectOneOptionsComposite.this.firePropertyChange();
                }
            }
        });
        this._listAttrControl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IDataControlObject dcObject = SelectOneOptionsComposite.this.getSelection(SelectOneOptionsComposite.this._listAttrControl);
                if (dcObject != null) {
                    ((ISelectOneOptionsModel)SelectOneOptionsComposite.this.getModel()).setListAttribute(dcObject);
                    SelectOneOptionsComposite.this.firePropertyChange();
                }
            }
        });
        this._displayAttrControl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IDataControlObject dcObject = SelectOneOptionsComposite.this.getSelection(SelectOneOptionsComposite.this._displayAttrControl);
                if (dcObject != null) {
                    ((ISelectOneOptionsModel)SelectOneOptionsComposite.this.getModel()).setDisplayAttribute(dcObject);
                    SelectOneOptionsComposite.this.firePropertyChange();
                }
            }
        });
    }

    private IDataControlObject getSelection(ComboViewer viewer) {
        Object selection;
        if (viewer.getSelection() instanceof IStructuredSelection && (selection = ((IStructuredSelection)viewer.getSelection()).getFirstElement()) instanceof IDataControlObject) {
            return (IDataControlObject)selection;
        }
        return null;
    }

    private List<? extends IDataControlObject> getDataControls() {
        List<? extends IDataControlObject> dataControls = ((ISelectOneOptionsModel)this.getModel()).getDataControls();
        if (dataControls == null) {
            dataControls = new ArrayList<IDataControlObject>();
        }
        return dataControls;
    }

    private static String getDataControlObjDisplayName(IDataControlObject dcObject) {
        return dcObject.getParent() != null ? String.valueOf(SelectOneOptionsComposite.getDataControlObjDisplayName(dcObject.getParent())) + "." + dcObject.getDescriptor().getLabel() : dcObject.getDescriptor().getLabel();
    }

    @Override
    public void updateLayout() {
    }
}

