/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.ISparkChartOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.AbstractWizardPage;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ModelChangeComposite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class SparkChartOptionsPage
extends AbstractWizardPage
implements PropertyChangeListener {
    private final IOptionsMapper _optionsMapper;
    private ModelChangeComposite<ISparkChartOptionsModel> _optionsComposite;
    private boolean _isComplete = false;

    public SparkChartOptionsPage(String pageName, String helpContextID, IOptionsMapper optionsMapper) {
        super(pageName, helpContextID);
        this._optionsMapper = optionsMapper;
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
    }

    protected ISparkChartOptionsModel getModel() {
        return (ISparkChartOptionsModel)this._optionsMapper.getModel();
    }

    private String getPageTitle() {
        String titleParam = this.getModel().getLayoutVariationName();
        if (titleParam == null || titleParam.isEmpty()) {
            titleParam = "";
        }
        return NLS.bind((String)Messages.SparkChartOptionsPage_title, (Object)titleParam);
    }

    protected String getPageDescription() {
        return this.getModel().isBar() || this.getModel().isFloatingBar() ? Messages.SparkChartOptionsPage_descriptionBar : (this.getModel().isArea() ? Messages.SparkChartOptionsPage_descriptionArea : Messages.SparkChartOptionsPage_descriptionLine);
    }

    public void createControl(Composite parent) {
        this._optionsComposite = new SparkChartOptionsComposite(parent, 0, this.getModel());
        this._optionsComposite.addPropertyChangeListener(this);
        this.setControl((Control)this._optionsComposite);
        IStatus status = this._optionsMapper.validateModel();
        if (status == null || status.getSeverity() != 4) {
            this._isComplete = true;
        }
        if (this.helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp(this._optionsComposite, this.helpContextID);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this._optionsComposite.updateLayout();
            this.setTitle(this.getPageTitle());
            this.setDescription(this.getPageDescription());
        }
        super.setVisible(visible);
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    protected IStatus getStatus() {
        IStatus status = this._optionsMapper.validateModel();
        this._isComplete = status == null || status.getSeverity() != 4;
        return status;
    }

    public boolean isPageComplete() {
        return this._isComplete;
    }

    public void setPageComplete(boolean complete) {
        this._isComplete = complete;
    }

    public void dispose() {
        this._optionsComposite.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateStatus();
    }

    private class SparkChartOptionsComposite
    extends ModelChangeComposite<ISparkChartOptionsModel> {
        private final int NO_SELECTION = -1;
        private Label _dataValueLabel;
        private List _dataValuesWidget;
        private String[] _dataValueNames;
        private int _dataValueIndex;
        private Label _floatValueLabel;
        private List _floatValuesWidget;
        private String[] _floatValueNames;
        private int _floatValueIndex;

        public SparkChartOptionsComposite(Composite parent, int style, ISparkChartOptionsModel model) {
            super(parent, style, model);
            this.NO_SELECTION = -1;
            this._dataValueIndex = -1;
            this._floatValueIndex = -1;
            this.setFont(parent.getFont());
            this.setLayoutData(new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            this.setLayout((Layout)layout);
            this.createAttributeSelectionComposite(this);
            this.addListeners();
        }

        private void createAttributeSelectionComposite(Composite parent) {
            Composite dataValueComposite = new Composite(parent, 0);
            dataValueComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout(2, true);
            layout.horizontalSpacing = 10;
            layout.marginWidth = 0;
            dataValueComposite.setLayout((Layout)layout);
            this._dataValueLabel = new Label(dataValueComposite, 16384);
            this._dataValueLabel.setText(Messages.SparkChartOptionsPage_valueLabelBarHeight);
            GridData data = new GridData(16384, 0x1000000, false, false);
            this._dataValueLabel.setLayoutData((Object)data);
            if (this._dataValueNames == null) {
                this._dataValueNames = this.getItemsForWidget(((ISparkChartOptionsModel)this.getModel()).getFloatValue());
            }
            this._floatValueLabel = new Label(dataValueComposite, 16384);
            this._floatValueLabel.setText(Messages.SparkChartOptionsPage_valueLabelBarFloat);
            data = new GridData(16384, 0x1000000, false, false);
            this._floatValueLabel.setLayoutData((Object)data);
            if (this._floatValueNames == null) {
                this._floatValueNames = this.getItemsForWidget(((ISparkChartOptionsModel)this.getModel()).getValue());
            }
            this._dataValuesWidget = new List(dataValueComposite, 8391172);
            this._dataValuesWidget.setLayoutData((Object)new GridData(4, 4, true, true));
            this._dataValuesWidget.setItems(this._dataValueNames);
            if (((ISparkChartOptionsModel)this.getModel()).getValue() != null) {
                this._dataValueIndex = this.getSelectionIndex(this._dataValueNames, ((ISparkChartOptionsModel)this.getModel()).getValue());
                if (this._dataValueIndex != -1) {
                    this._dataValuesWidget.setSelection(this._dataValueIndex);
                }
            }
            this._floatValuesWidget = new List(dataValueComposite, 8391172);
            this._floatValuesWidget.setLayoutData((Object)new GridData(4, 4, true, true));
            this._floatValuesWidget.setItems(this._floatValueNames);
            if (((ISparkChartOptionsModel)this.getModel()).getFloatValue() != null) {
                this._floatValueIndex = this.getSelectionIndex(this._floatValueNames, ((ISparkChartOptionsModel)this.getModel()).getFloatValue());
                if (this._floatValueIndex != -1) {
                    this._floatValuesWidget.setSelection(this._floatValueIndex);
                }
            }
            if (!((ISparkChartOptionsModel)this.getModel()).isFloatingBar()) {
                this._floatValueLabel.setVisible(false);
                this._floatValuesWidget.setVisible(false);
            }
        }

        private int getSelectionIndex(String[] names, String value) {
            if (value != null && names != null && names.length > 0) {
                int i = 0;
                while (i < names.length) {
                    if (value.equals(names[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        private String getDataValueLabelText() {
            return ((ISparkChartOptionsModel)this.getModel()).isBar() ? Messages.SparkChartOptionsPage_valueLabelBar : (((ISparkChartOptionsModel)this.getModel()).isFloatingBar() ? Messages.SparkChartOptionsPage_valueLabelBarHeight : (((ISparkChartOptionsModel)this.getModel()).isArea() ? Messages.SparkChartOptionsPage_valueLabelArea : Messages.SparkChartOptionsPage_valueLabelLine));
        }

        private void addListeners() {
            this._dataValuesWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (SparkChartOptionsComposite.this._dataValueNames != null && SparkChartOptionsComposite.this._dataValueNames.length > 0) {
                        SparkChartOptionsComposite.this._dataValueIndex = SparkChartOptionsComposite.this._dataValuesWidget.getSelectionIndex();
                        ((ISparkChartOptionsModel)SparkChartOptionsComposite.this.getModel()).setValue(SparkChartOptionsComposite.this._dataValueNames[SparkChartOptionsComposite.this._dataValueIndex]);
                        SparkChartOptionsComposite.this.firePropertyChange();
                    }
                }
            });
            this._floatValuesWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (SparkChartOptionsComposite.this._floatValueNames != null && SparkChartOptionsComposite.this._floatValueNames.length > 0) {
                        SparkChartOptionsComposite.this._floatValueIndex = SparkChartOptionsComposite.this._floatValuesWidget.getSelectionIndex();
                        ((ISparkChartOptionsModel)SparkChartOptionsComposite.this.getModel()).setFloatValue(SparkChartOptionsComposite.this._floatValueNames[SparkChartOptionsComposite.this._floatValueIndex]);
                        SparkChartOptionsComposite.this.firePropertyChange();
                    }
                }
            });
        }

        private String[] getItemsForWidget(String usedItem) {
            ArrayList<String> items = new ArrayList<String>(((ISparkChartOptionsModel)this.getModel()).getAllAttributes());
            items.remove(usedItem);
            return items.toArray(new String[items.size()]);
        }

        @Override
        public void updateLayout() {
            this._dataValueNames = this.getItemsForWidget(((ISparkChartOptionsModel)this.getModel()).getFloatValue());
            this._dataValuesWidget.setItems(this._dataValueNames);
            this._dataValueLabel.setText(this.getDataValueLabelText());
            if (((ISparkChartOptionsModel)this.getModel()).getValue() != null) {
                this._dataValueIndex = this.getSelectionIndex(this._dataValueNames, ((ISparkChartOptionsModel)this.getModel()).getValue());
                if (this._dataValueIndex != -1) {
                    this._dataValuesWidget.setSelection(this._dataValueIndex);
                }
            }
            this._floatValueNames = this.getItemsForWidget(((ISparkChartOptionsModel)this.getModel()).getValue());
            this._floatValuesWidget.setItems(this._floatValueNames);
            if (((ISparkChartOptionsModel)this.getModel()).getFloatValue() != null) {
                this._floatValueIndex = this.getSelectionIndex(this._floatValueNames, ((ISparkChartOptionsModel)this.getModel()).getFloatValue());
                if (this._floatValueIndex != -1) {
                    this._floatValuesWidget.setSelection(this._floatValueIndex);
                }
            }
            if (((ISparkChartOptionsModel)this.getModel()).isFloatingBar()) {
                this._floatValueLabel.setVisible(true);
                this._floatValuesWidget.setVisible(true);
            } else {
                this._floatValueLabel.setVisible(false);
                this._floatValuesWidget.setVisible(false);
            }
            super.updateLayout();
        }
    }
}

