/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IPieGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.AttributeSelectionComposite;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.PieGraphAttributeSelectionComposite;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.ui.dialogs.ListShuttleDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PieBarGraphAttributeSelectionComposite
extends PieGraphAttributeSelectionComposite {
    private Text _barSegmentsValues;
    private Button _barSegmentsButton;

    public PieBarGraphAttributeSelectionComposite(Composite parent, int style, IPieGraphOptionsModel model) {
        super(parent, style, model);
    }

    @Override
    protected void createEdgesComposite(Composite parent) {
        Composite edgesComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        edgesComposite.setLayout((Layout)layout);
        this.createGroupsEdgeComposite(edgesComposite);
        this.createSeriesEdgeComposite(edgesComposite);
        this.createBarSegmentsComposite(edgesComposite);
        GridData gd = new GridData(4, 4, true, false);
        edgesComposite.setLayoutData((Object)gd);
    }

    protected void createBarSegmentsComposite(Composite parent) {
        Label barSegmentsLabel = new Label(parent, 16384);
        barSegmentsLabel.setText(this.getBarSegmentsLabelText());
        GridData data = new GridData(16384, 0x1000000, false, false);
        barSegmentsLabel.setLayoutData((Object)data);
        this._barSegmentsValues = new Text(parent, 2052);
        this.setEdgeValuesText(this._barSegmentsValues, this.getCurrrentBarSegmentsItemContexts());
        this._barSegmentsValues.setEditable(false);
        data = new GridData(4, 0x1000000, true, false);
        this._barSegmentsValues.setLayoutData((Object)data);
        this._barSegmentsButton = new Button(parent, 8);
        this._barSegmentsButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        this._barSegmentsButton.setToolTipText(this.getSeriesEdgeToolTipText());
        data = new GridData(4, 0x1000000, false, false);
        this._barSegmentsButton.setLayoutData((Object)data);
    }

    @Override
    protected String[] updateItemsForCombo() {
        ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>(((IPieGraphOptionsModel)this.getModel()).getAllEdgeItemContexts());
        contexts.removeAll(((IPieGraphOptionsModel)this.getModel()).getSeriesItemContexts());
        contexts.removeAll(this.getCurrrentBarSegmentsItemContexts());
        ArrayList<String> names = new ArrayList<String>();
        for (EdgeItemContext item : contexts) {
            if (!item.isNumeric()) continue;
            names.add(item.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    protected String getBarSegmentsLabelText() {
        return Messages.PieGraphOptionsPage_barSegmentslabel;
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.addBarSegmentsButtonListener();
    }

    private void addBarSegmentsButtonListener() {
        this._barSegmentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListShuttleDialog dialog = new ListShuttleDialog(e.display.getActiveShell());
                dialog.setTitle(Messages.GraphOptionsSelectAttributeDialog_title);
                dialog.setAvailableItemsContentProvider((IStructuredContentProvider)new AttributeSelectionComposite.EdgeItemContextContentProvider());
                dialog.setAvailableItemsLabelProvider((ILabelProvider)new AttributeSelectionComposite.AvailableAttrsLabelProvider());
                dialog.setAllItemsInput(PieBarGraphAttributeSelectionComposite.this.getAvailableBarSegmentsItemContexts());
                dialog.setSelectedItemsContentProvider((IStructuredContentProvider)new AttributeSelectionComposite.EdgeItemContextContentProvider());
                dialog.setSelectedItemsLabelProvider((ILabelProvider)new AttributeSelectionComposite.SelectedAttrsLabelProvider(false));
                dialog.setInitiallySelectedItemsInput(PieBarGraphAttributeSelectionComposite.this.getCurrrentBarSegmentsItemContexts());
                if (dialog.open() == 0) {
                    List selectedItems = dialog.getSelectedItems();
                    PieBarGraphAttributeSelectionComposite.this.updateGroupsWithBarSegments(selectedItems);
                    PieBarGraphAttributeSelectionComposite.this.setEdgeValuesText(PieBarGraphAttributeSelectionComposite.this._barSegmentsValues, selectedItems);
                    PieBarGraphAttributeSelectionComposite.this.firePropertyChange();
                }
            }
        });
    }

    private List<EdgeItemContext> getAvailableBarSegmentsItemContexts() {
        ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>(((IPieGraphOptionsModel)this.getModel()).getAllEdgeItemContexts());
        contexts.removeAll(((IPieGraphOptionsModel)this.getModel()).getSeriesItemContexts());
        EdgeItemContext currentDataItem = this.getGroupsDataItemContext();
        if (currentDataItem != null) {
            contexts.remove(currentDataItem);
        }
        return contexts;
    }

    private List<EdgeItemContext> getCurrrentBarSegmentsItemContexts() {
        ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>(((IPieGraphOptionsModel)this.getModel()).getGroupsItemContexts());
        EdgeItemContext currentDataItem = this.getGroupsDataItemContext();
        if (currentDataItem != null) {
            contexts.remove(currentDataItem);
        }
        return contexts;
    }

    private void updateGroupsWithBarSegments(List<EdgeItemContext> selectedItems) {
        ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>();
        EdgeItemContext currentDataItem = this.getGroupsDataItemContext();
        if (currentDataItem != null) {
            contexts.add(currentDataItem);
        }
        if (selectedItems != null) {
            for (EdgeItemContext context : selectedItems) {
                context.setDataItem(false);
                context.setTreatAsText(context.isNumeric());
                contexts.add(context);
            }
        }
        ((IPieGraphOptionsModel)this.getModel()).setGroupsItemContexts(contexts);
    }

    @Override
    protected void updateGroupsDataItemContext(EdgeItemContext item) {
        if (item == null || !item.isNumeric()) {
            return;
        }
        ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>();
        item.setDataItem(true);
        item.setTreatAsText(false);
        contexts.add(item);
        for (EdgeItemContext context : ((IPieGraphOptionsModel)this.getModel()).getGroupsItemContexts()) {
            if (context.isNumeric() && !context.isTreatAsText()) continue;
            contexts.add(context);
        }
        ((IPieGraphOptionsModel)this.getModel()).setGroupsItemContexts(contexts);
    }

    @Override
    public void updateLayout() {
        this.setEdgeValuesText(this._barSegmentsValues, this.getCurrrentBarSegmentsItemContexts());
        super.updateLayout();
    }
}

