/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph;

import java.util.ArrayList;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.AttributeSelectionComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ParetoGraphAttributeSelectionComposite
extends AttributeSelectionComposite<IGraphOptionsModel> {
    private Combo _seriesCombo;
    private String[] _namesOfNumericAttrs;

    public ParetoGraphAttributeSelectionComposite(Composite parent, int style, IGraphOptionsModel model) {
        super(parent, style, model);
    }

    @Override
    protected String getSwapButtonText() {
        return null;
    }

    @Override
    protected void addDataChangeOptions(Composite parent) {
    }

    @Override
    protected void addSwapButtonListener() {
    }

    @Override
    protected void createSeriesEdgeComposite(Composite parent) {
        Label seriesEdgeLabel = new Label(parent, 16384);
        seriesEdgeLabel.setText(this.getSeriesEdgeLabelText());
        GridData data = new GridData(16384, 0x1000000, false, false);
        seriesEdgeLabel.setLayoutData((Object)data);
        if (this._namesOfNumericAttrs == null) {
            this._namesOfNumericAttrs = this.updateItemsForCombo();
        }
        this._seriesCombo = new Combo(parent, 0x800808);
        this._seriesCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._seriesCombo.setItems(this._namesOfNumericAttrs);
        EdgeItemContext seriesItem = this.getSeriesDataItemContext();
        if (seriesItem != null) {
            this._seriesCombo.setText(seriesItem.getName());
        }
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
    }

    @Override
    protected String getSeriesEdgeLabelText() {
        return Messages.ParetoGraphOptionsPage_seriesEdgeLabel;
    }

    @Override
    protected String getGroupsEdgeLabelText() {
        return Messages.GraphOptionsPage_groupsEdgeLabel;
    }

    private String[] updateItemsForCombo() {
        ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>(((IGraphOptionsModel)this.getModel()).getAllEdgeItemContexts());
        contexts.removeAll(((IGraphOptionsModel)this.getModel()).getGroupsItemContexts());
        ArrayList<String> names = new ArrayList<String>();
        for (EdgeItemContext item : contexts) {
            if (!item.isNumeric()) continue;
            names.add(item.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    private EdgeItemContext getSeriesDataItemContext() {
        for (EdgeItemContext context : ((IGraphOptionsModel)this.getModel()).getSeriesItemContexts()) {
            if (!context.isNumeric() || context.isTreatAsText()) continue;
            return context;
        }
        return null;
    }

    @Override
    protected void addListeners() {
        this.addSeriesComboListener();
        this.addGroupsButtonListener();
    }

    private void addSeriesComboListener() {
        this._seriesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParetoGraphAttributeSelectionComposite.this._namesOfNumericAttrs != null && ParetoGraphAttributeSelectionComposite.this._namesOfNumericAttrs.length > 0) {
                    String name = ParetoGraphAttributeSelectionComposite.this._namesOfNumericAttrs[ParetoGraphAttributeSelectionComposite.this._seriesCombo.getSelectionIndex()];
                    EdgeItemContext item = ((IGraphOptionsModel)ParetoGraphAttributeSelectionComposite.this.getModel()).findEdgeItemContext(name);
                    if (item != null) {
                        ParetoGraphAttributeSelectionComposite.this.updateSeriesDataItemContext(item);
                        ParetoGraphAttributeSelectionComposite.this.firePropertyChangeNoComboItemUpdate();
                    }
                }
            }
        });
    }

    private void updateSeriesDataItemContext(EdgeItemContext item) {
        if (item == null || !item.isNumeric()) {
            return;
        }
        ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>();
        item.setDataItem(true);
        item.setTreatAsText(false);
        contexts.add(item);
        ((IGraphOptionsModel)this.getModel()).setSeriesItemContexts(contexts);
    }

    @Override
    public void updateLayout() {
        this._namesOfNumericAttrs = this.updateItemsForCombo();
        this._seriesCombo.setItems(this._namesOfNumericAttrs);
        EdgeItemContext seriesItem = this.getSeriesDataItemContext();
        if (seriesItem != null) {
            this._seriesCombo.setText(seriesItem.getName());
        }
        super.updateLayout();
    }

    @Override
    protected void firePropertyChange() {
        this._namesOfNumericAttrs = this.updateItemsForCombo();
        this._seriesCombo.setItems(this._namesOfNumericAttrs);
        EdgeItemContext seriesItem = this.getSeriesDataItemContext();
        if (seriesItem != null) {
            this._seriesCombo.setText(seriesItem.getName());
        }
        super.firePropertyChange();
    }

    private void firePropertyChangeNoComboItemUpdate() {
        super.firePropertyChange();
    }
}

