/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.AbstractWizardPage;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.GraphOptionsComposite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class GraphOptionsPage<O extends IGraphOptionsModel>
extends AbstractWizardPage
implements PropertyChangeListener {
    private static final Map<GraphType, String> GRAPH_DESCRIPTION_PARAMS = new HashMap<GraphType, String>();
    private final O _optionsModel;
    private final IOptionsMapper _optionsMapper;
    private GraphOptionsComposite<O> _optionsComposite;
    private boolean _isComplete = false;

    static {
        GRAPH_DESCRIPTION_PARAMS.put(GraphType.AREA, Messages.AreaGraphOptionsPage_description);
        GRAPH_DESCRIPTION_PARAMS.put(GraphType.BAR, Messages.BarGraphOptionsPage_description);
        GRAPH_DESCRIPTION_PARAMS.put(GraphType.BUBBLE, Messages.BubbleGraphOptionsPage_description);
        GRAPH_DESCRIPTION_PARAMS.put(GraphType.COMBO, Messages.ComboGraphOptionsPage_description);
        GRAPH_DESCRIPTION_PARAMS.put(GraphType.HORIZ_BAR, Messages.HorizBarGraphOptionsPage_description);
        GRAPH_DESCRIPTION_PARAMS.put(GraphType.FUNNEL, Messages.FunnelGraphOptionsPage_description);
        GRAPH_DESCRIPTION_PARAMS.put(GraphType.LINE, Messages.LineGraphOptionsPage_description);
        GRAPH_DESCRIPTION_PARAMS.put(GraphType.PARETO, Messages.ParetoGraphOptionsPage_description);
        GRAPH_DESCRIPTION_PARAMS.put(GraphType.RADAR, Messages.RadarGraphOptionsPage_description);
        GRAPH_DESCRIPTION_PARAMS.put(GraphType.SCATTER, Messages.ScatterGraphOptionsPage_description);
    }

    public GraphOptionsPage(String pageName, String helpContextID, O model, IOptionsMapper optionsMapper) {
        super(pageName, helpContextID);
        this._optionsModel = model;
        this._optionsMapper = optionsMapper;
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
    }

    protected O getModel() {
        return this._optionsModel;
    }

    private String getPageTitle() {
        String titleParam = this.getModel().getLayoutVariationName();
        if (titleParam == null || titleParam.isEmpty()) {
            titleParam = this._optionsMapper.getComponentName();
        }
        return NLS.bind((String)Messages.GraphOptionsPage_title, (Object)titleParam);
    }

    protected String getPageDescription() {
        return GRAPH_DESCRIPTION_PARAMS.get((Object)this.getModel().getType());
    }

    public void createControl(Composite parent) {
        this._optionsComposite = this.createGraphOptionsComposite(parent);
        this._optionsComposite.addPropertyChangeListener(this);
        this.setControl((Control)this._optionsComposite);
        IStatus status = this._optionsMapper.validateModel();
        if (status == null || status.getSeverity() != 4) {
            this._isComplete = true;
        }
        if (this.helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp(this._optionsComposite, this.helpContextID);
        }
    }

    protected GraphOptionsComposite<O> createGraphOptionsComposite(Composite parent) {
        return new GraphOptionsComposite<O>(parent, 0, this.getModel());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this._optionsComposite.updateLayout();
            this.setTitle(this.getPageTitle());
            this.setDescription(this.getPageDescription());
        }
        super.setVisible(visible);
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    protected IStatus getStatus() {
        IStatus status = this._optionsMapper.validateModel();
        this._isComplete = status == null || status.getSeverity() != 4;
        return status;
    }

    public boolean isPageComplete() {
        return this._isComplete;
    }

    public void setPageComplete(boolean complete) {
        this._isComplete = complete;
    }

    public void dispose() {
        this._optionsComposite.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateStatus();
    }
}

