/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ModelChangeComposite;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.AttributeLabelEditingSupport;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.AttributeSelectionComposite;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.AxisGraphAttributeSelectionComposite;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.BubbleGraphAttributeSelectionComposite;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.FunnelGraphAttributeSelectionComposite;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.ParetoGraphAttributeSelectionComposite;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.ScatterGraphAttributeSelectionComposite;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.StockGraphAttributeSelectionComposite;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonBundleIcon;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class GraphOptionsComposite<O extends IGraphOptionsModel>
extends ModelChangeComposite<O>
implements PropertyChangeListener {
    private static final String ATTR_COLUMN = "name";
    private static final String LABEL_COLUMN = "value";
    private static final String[] COLUMN_NAMES = new String[]{"name", "value"};
    private ModelChangeComposite<?> _attrSelectionComposite;
    private TableViewer _attrLabelsViewer;
    private Button _rowSelectionButton;

    public GraphOptionsComposite(Composite parent, int style, O model) {
        super(parent, style, model);
        this.setFont(parent.getFont());
        this.setLayoutData(new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        this._attrSelectionComposite = this.createAttributeSelectionComposite(this);
        this._attrSelectionComposite.addPropertyChangeListener(this);
        this.addAttributeLabels(this);
        this.addRowSelectionOption(this);
        this.addListeners();
    }

    public void dispose() {
        this._attrSelectionComposite.removePropertyChangeListener(this);
    }

    protected ModelChangeComposite<?> createAttributeSelectionComposite(Composite parent) {
        GraphType graphType = ((IGraphOptionsModel)this.getModel()).getType();
        return GraphType.BUBBLE.equals((Object)graphType) ? new BubbleGraphAttributeSelectionComposite(parent, 0, (IGraphOptionsModel)this.getModel()) : (GraphType.FUNNEL.equals((Object)graphType) ? new FunnelGraphAttributeSelectionComposite(parent, 0, (IGraphOptionsModel)this.getModel()) : (GraphType.PARETO.equals((Object)graphType) ? new ParetoGraphAttributeSelectionComposite(parent, 0, (IGraphOptionsModel)this.getModel()) : (GraphType.SCATTER.equals((Object)graphType) ? new ScatterGraphAttributeSelectionComposite(parent, 0, (IGraphOptionsModel)this.getModel()) : (GraphType.STOCK.equals((Object)graphType) ? new StockGraphAttributeSelectionComposite(parent, 0, (IGraphOptionsModel)this.getModel()) : new AxisGraphAttributeSelectionComposite(parent, 0, (IGraphOptionsModel)this.getModel())))));
    }

    protected void addAttributeLabels(Composite parent) {
        Label attrLabelsViewerLabel = new Label(parent, 16384);
        attrLabelsViewerLabel.setText(Messages.GraphOptionsPage_attributeLabelsLabel);
        GridData data = new GridData(16384, 0x1000000, true, false);
        attrLabelsViewerLabel.setLayoutData((Object)data);
        this._attrLabelsViewer = this.createTableViewer(parent);
        this.updateAttributeLabelViewerInput();
    }

    private TableViewer createTableViewer(Composite parent) {
        Composite tableComp = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 200;
        tableComp.setLayoutData((Object)data);
        int tableStyle = 101124;
        Table table = new Table(tableComp, tableStyle);
        table.setFont(parent.getFont());
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn attrCol = new TableColumn(table, 16384, 0);
        attrCol.setText(Messages.GraphOptionsPage_attributeColumnHeader);
        TableColumn labelCol = new TableColumn(table, 16384, 1);
        labelCol.setText(Messages.GraphOptionsPage_labelColumnHeader);
        TableColumnLayout tcLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tcLayout);
        tcLayout.setColumnData((Widget)attrCol, (ColumnLayoutData)new ColumnWeightData(50));
        tcLayout.setColumnData((Widget)labelCol, (ColumnLayoutData)new ColumnWeightData(50));
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setColumnProperties(COLUMN_NAMES);
        tableViewer.setContentProvider((IContentProvider)new AttributeSelectionComposite.EdgeItemContextContentProvider());
        TableViewerColumn attrColViewer = new TableViewerColumn(tableViewer, table.getColumn(0));
        attrColViewer.setLabelProvider((CellLabelProvider)new AttrColumnLabelProvider());
        TableViewerColumn labelColViewer = new TableViewerColumn(tableViewer, table.getColumn(1));
        labelColViewer.setLabelProvider((CellLabelProvider)new LabelColumnLabelProvider());
        labelColViewer.setEditingSupport((EditingSupport)new AttributeLabelEditingSupport(tableViewer, ((IGraphOptionsModel)this.getModel()).getAllEdgeItemContexts()));
        return tableViewer;
    }

    private void addRowSelectionOption(Composite parent) {
        this._rowSelectionButton = new Button(parent, 32);
        this._rowSelectionButton.setText(Messages.GraphOptionsPage_setRowSelectionButton);
        this._rowSelectionButton.setSelection(((IGraphOptionsModel)this.getModel()).isRowSelection());
        GridData data = new GridData(16384, 0x1000000, false, false);
        this._rowSelectionButton.setLayoutData((Object)data);
    }

    private void addListeners() {
        this._rowSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IGraphOptionsModel)GraphOptionsComposite.this.getModel()).setRowSelection(GraphOptionsComposite.this._rowSelectionButton.getSelection());
                GraphOptionsComposite.this.firePropertyChange();
            }
        });
    }

    @Override
    public void updateLayout() {
        this._attrSelectionComposite.updateLayout();
        this.updateAttributeLabelViewerInput();
        this._attrLabelsViewer.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateAttributeLabelViewerInput();
        this._attrLabelsViewer.refresh();
        this.firePropertyChange();
    }

    private void updateAttributeLabelViewerInput() {
        ArrayList<EdgeItemContext> input = new ArrayList<EdgeItemContext>();
        input.addAll(((IGraphOptionsModel)this.getModel()).getSeriesItemContexts());
        input.addAll(((IGraphOptionsModel)this.getModel()).getGroupsItemContexts());
        this._attrLabelsViewer.setInput(input);
    }

    private static final class AttrColumnLabelProvider
    extends ColumnLabelProvider {
        private AttrColumnLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof EdgeItemContext) {
                EdgeItemContext itemContext = (EdgeItemContext)element;
                if (itemContext.isNumeric()) {
                    if (itemContext.isTreatAsText() || !itemContext.isDataItem()) {
                        return this.getImageFromBundle(DTRTvCommonBundleIcon.DATABINDING_NUMERIC_AS_STRING);
                    }
                    return this.getImageFromBundle(DTRTvCommonBundleIcon.DATABINDING_NUMBER_ICON);
                }
                return this.getImageFromBundle(DTRTvCommonBundleIcon.DATABINDING_STRING_ICON);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof EdgeItemContext) {
                return ((EdgeItemContext)element).getName();
            }
            return null;
        }

        private Image getImageFromBundle(DTRTvCommonBundleIcon icon) {
            return (Image)ImageManager.getInstance().getImage((ImageManager.IImageData)icon);
        }
    }

    private static final class LabelColumnLabelProvider
    extends ColumnLabelProvider {
        private LabelColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof EdgeItemContext) {
                EdgeItemContext itemContext = (EdgeItemContext)element;
                String labelText = itemContext.getLabel();
                if (labelText == null || labelText.trim().isEmpty()) {
                    labelText = itemContext.isNumeric() && !itemContext.isTreatAsText() ? Messages.GraphOptionsPage_labelValueUseAttributeName : Messages.GraphOptionsPage_labelValueUseAttributeValue;
                } else if ("__NO_LABEL".equals(labelText)) {
                    labelText = Messages.GraphOptionsPage_labelValueNoLabel;
                }
                return labelText;
            }
            return null;
        }
    }
}

