/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.gauge;

import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGaugeThreshold;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.gauge.ThresholdManager;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class ThresholdCellModifier
implements ICellModifier {
    private final ThresholdManager _mgr;

    public ThresholdCellModifier(ThresholdManager manager) {
        this._mgr = manager;
    }

    public boolean canModify(Object element, String property) {
        IGaugeThreshold threshold = (IGaugeThreshold)element;
        ThresholdManager.ColumnName columnName = ThresholdManager.getColumnName(property);
        return ThresholdManager.ColumnName.VALUE == columnName ? !threshold.isMaxThreshold() : ThresholdManager.ColumnName.INDEX != columnName;
    }

    public Object getValue(Object element, String property) {
        ThresholdManager.ColumnName columnName = ThresholdManager.getColumnName(property);
        IGaugeThreshold threshold = (IGaugeThreshold)element;
        String result = null;
        switch (columnName) {
            case INDEX: {
                break;
            }
            case VALUE: {
                result = threshold.getMaxValue();
                break;
            }
            case LABEL: {
                result = threshold.getText();
                break;
            }
            case COLOR: {
                result = threshold.getFillColor();
            }
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        ThresholdManager.ColumnName columnName = ThresholdManager.getColumnName(property);
        TableItem item = (TableItem)element;
        IGaugeThreshold threshold = (IGaugeThreshold)item.getData();
        String oldValue = null;
        switch (columnName) {
            case INDEX: {
                break;
            }
            case VALUE: {
                threshold.setMaxValue((String)value);
                break;
            }
            case LABEL: {
                threshold.setText((String)value);
                break;
            }
            case COLOR: {
                oldValue = threshold.getFillColor();
                threshold.setFillColor((String)value);
            }
        }
        this._mgr.updateThreshold(threshold, oldValue);
    }
}

