/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.gauge;

import java.awt.Color;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class HexColorCellEditor
extends DialogCellEditor {
    private static final int GAP = 6;
    private Label rgbLabel;

    public HexColorCellEditor(Composite parent) {
        this(parent, 0);
    }

    public HexColorCellEditor(Composite parent, int style) {
        super(parent, style);
        this.doSetValue("#000000");
    }

    protected Control createContents(Composite cell) {
        org.eclipse.swt.graphics.Color bg = cell.getBackground();
        Composite composite = new Composite(cell, this.getStyle());
        composite.setBackground(bg);
        composite.setLayout((Layout)new ColorCellLayout());
        this.rgbLabel = new Label(composite, 16384);
        this.rgbLabel.setBackground(bg);
        this.rgbLabel.setFont(cell.getFont());
        return composite;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        ColorDialog dialog = new ColorDialog(cellEditorWindow.getShell());
        Object value = this.getValue();
        RGB rgb = HexColorCellEditor.convertHexadecimalStringtoRGB((String)value);
        if (rgb != null) {
            dialog.setRGB(rgb);
        }
        rgb = dialog.open();
        return HexColorCellEditor.convertRGBToHexadecimal(dialog.getRGB());
    }

    protected void updateContents(Object value) {
        String colorString = (String)value;
        if (colorString == null) {
            colorString = "";
        }
        this.rgbLabel.setText(colorString);
    }

    static RGB convertHexadecimalStringtoRGB(String colorString) {
        if (colorString != null && colorString.indexOf(35) == 0 && colorString.length() == 7) {
            int hexValue = 0;
            try {
                hexValue = Integer.parseInt(colorString.substring(1), 16);
                Color color = new Color(hexValue);
                return new RGB(color.getRed(), color.getGreen(), color.getBlue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    static String convertRGBToHexadecimal(RGB rgb) {
        int red = rgb.red;
        int green = rgb.green;
        int blue = rgb.blue;
        String redHexadecimal = Integer.toHexString(red);
        String greenHexadecimal = Integer.toHexString(green);
        String blueHexadecimal = Integer.toHexString(blue);
        if (redHexadecimal.length() == 1) {
            redHexadecimal = "0" + redHexadecimal;
        }
        if (greenHexadecimal.length() == 1) {
            greenHexadecimal = "0" + greenHexadecimal;
        }
        if (blueHexadecimal.length() == 1) {
            blueHexadecimal = "0" + blueHexadecimal;
        }
        return "#" + redHexadecimal + greenHexadecimal + blueHexadecimal;
    }

    private class ColorCellLayout
    extends Layout {
        private ColorCellLayout() {
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point rgbSize = HexColorCellEditor.this.rgbLabel.computeSize(-1, -1, force);
            return new Point(6 + rgbSize.x, rgbSize.y);
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point rgbSize = HexColorCellEditor.this.rgbLabel.computeSize(-1, -1, force);
            int ty = (bounds.height - rgbSize.y) / 2;
            if (ty < 0) {
                ty = 0;
            }
            HexColorCellEditor.this.rgbLabel.setBounds(5, ty, bounds.width - 6, bounds.height);
        }
    }
}

