/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.gauge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGaugeOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.AbstractWizardPage;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.gauge.GaugeOptionsComposite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class GaugeOptionsPage
extends AbstractWizardPage
implements PropertyChangeListener {
    private final IGaugeOptionsModel _optionsModel;
    private final IOptionsMapper _optionsMapper;
    private GaugeOptionsComposite _optionsComposite;
    private boolean _isComplete = false;

    public GaugeOptionsPage(String pageName, String helpContextID, IGaugeOptionsModel model, IOptionsMapper optionsMapper) {
        super(pageName, helpContextID);
        this._optionsModel = model;
        this._optionsMapper = optionsMapper;
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
    }

    protected IGaugeOptionsModel getModel() {
        return this._optionsModel;
    }

    private String getPageTitle() {
        return Messages.GaugeOptionsPage_title;
    }

    protected String getPageDescription() {
        return Messages.GaugeOptionsPage_description;
    }

    public void createControl(Composite parent) {
        this._optionsComposite = this.createOptionsComposite(parent);
        this._optionsComposite.addPropertyChangeListener(this);
        this.setControl((Control)this._optionsComposite);
        IStatus status = this._optionsMapper.validateModel();
        if (status == null || status.getSeverity() != 4) {
            this._isComplete = true;
        }
        if (this.helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp((Control)this._optionsComposite, this.helpContextID);
        }
    }

    protected GaugeOptionsComposite createOptionsComposite(Composite parent) {
        return new GaugeOptionsComposite(parent, 0, this.getModel());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this._optionsComposite.updateLayout();
            this.setTitle(this.getPageTitle());
            this.setDescription(this.getPageDescription());
        }
        super.setVisible(visible);
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    protected IStatus getStatus() {
        IStatus status = this._optionsMapper.validateModel();
        this._isComplete = status == null || status.getSeverity() != 4;
        return status;
    }

    public boolean isPageComplete() {
        return this._isComplete;
    }

    public void setPageComplete(boolean complete) {
        this._isComplete = complete;
    }

    public void dispose() {
        this._optionsComposite.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateStatus();
    }
}

