/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationVariation;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PresentationVariationComposite
extends Composite {
    private final List<SelectionListener> _selectionListeners = new ArrayList<SelectionListener>();
    private final IPresentationVariation _pv;
    private final boolean _isChildVariation;
    private Composite _detailsComposite;

    public PresentationVariationComposite(Composite parent, int style, IPresentationVariation pv, boolean isChildVariation) {
        super(parent, style);
        this._pv = pv;
        this._isChildVariation = isChildVariation;
        this.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        this.setLayout((Layout)layout);
        this.setBackgroundMode(2);
        this.setBackground(parent.getBackground());
        String imagePath = this.getPresentationVariation().getImagePath();
        Label imgLabel = new Label((Composite)this, 16384);
        Image image = PresentationVariationComposite.getImage(imagePath);
        imgLabel.setImage(image);
        GridData data = new GridData(4, 4, true, true);
        imgLabel.setLayoutData((Object)data);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
            }

            public void mouseUp(MouseEvent event) {
                PresentationVariationComposite.this.sendSelectionEvent();
            }
        };
        MouseTrackAdapter mouseTrackListener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent event) {
            }

            public void mouseExit(MouseEvent event) {
            }
        };
        imgLabel.addMouseListener((MouseListener)mouseListener);
        imgLabel.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        imgLabel.setDragDetect(false);
        if (!this._isChildVariation) {
            String desc = this.getPresentationVariation().getDescription();
            Label descLabel = new Label((Composite)this, 64);
            descLabel.setText(desc);
            data = new GridData(0x1000000, 128, false, false);
            data.widthHint = image.getBounds().width;
            descLabel.setLayoutData((Object)data);
            descLabel.addMouseListener((MouseListener)mouseListener);
            descLabel.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
            descLabel.setDragDetect(false);
        }
    }

    public void dispose() {
        this._detailsComposite = null;
    }

    public void setDetailsComposite(Composite detailsComposite) {
        this._detailsComposite = detailsComposite;
    }

    public Composite getDetailsComposite() {
        return this._detailsComposite;
    }

    public IPresentationVariation getPresentationVariation() {
        return this._pv;
    }

    private void sendSelectionEvent() {
        Event event = new Event();
        event.type = 13;
        event.widget = this;
        SelectionEvent selectionEvent = new SelectionEvent(event);
        for (SelectionListener listener : this._selectionListeners) {
            listener.widgetSelected(selectionEvent);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this._selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this._selectionListeners.remove(listener);
    }

    private static Image getImage(String imagePath) {
        ImageManager.IImageData imageData = DTRTvCommonUtil.createImageData("/icons" + imagePath);
        return (Image)ImageManager.getInstance().getImage(imageData);
    }
}

