/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationVariation;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.PresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IPresentationOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.AbstractWizardPage;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.PresentationVariationComposite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ComponentGalleryPage
extends AbstractWizardPage {
    private final String _variationTypePropName;
    private final IPresentationOptionsModel _optionsModel;
    private final ICreatorPresentation _creatorPres;
    private final Color _colorListBackground;
    private final Color _colorListSelection;
    private final SelectionListener _masterVariationsSelectionListener = new MySelectionListener();
    private final PropertyChangeListener _detailsPropertyChangeListener = new MyPropertyChangeListener();
    private final boolean _displayDetails;
    private Composite _detailsContentPanel;
    private StackLayout _detailsContentLayout;
    private Label _descriptionLabel;
    private final List<PresentationVariationComposite> _masterVariations = new ArrayList<PresentationVariationComposite>();
    private PresentationVariationComposite _selectedMaster;

    public ComponentGalleryPage(String pageName, String description, String varTypePropName, String helpContextID, IPresentationOptionsModel model) {
        super(pageName, helpContextID);
        if (model == null) {
            throw new IllegalArgumentException("Program error: options model is null");
        }
        this._variationTypePropName = varTypePropName;
        this._optionsModel = model;
        this._creatorPres = this._optionsModel.getCreatorPresentation();
        if (this._creatorPres == null) {
            throw new IllegalArgumentException("Program error: no creator presentation for options model");
        }
        this._displayDetails = this._creatorPres.variationsHaveVariations();
        Display display = Display.getCurrent();
        this._colorListBackground = display.getSystemColor(25);
        this._colorListSelection = display.getSystemColor(26);
        this.setTitle(Messages.ComponentGalleryPage_title);
        this.setDescription(description);
    }

    public void createControl(Composite parent) {
        Composite galleryComposite = this.getGalleryComposite(parent);
        this.setControl((Control)galleryComposite);
        if (this.helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp((Control)galleryComposite, this.helpContextID);
        }
    }

    private Composite getGalleryComposite(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setFont(parent.getFont());
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumHeight = 500;
        gd.minimumWidth = 300;
        mainComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        mainComposite.setLayout((Layout)layout);
        Composite masterPanel = new Composite(mainComposite, 0);
        masterPanel.setFont(mainComposite.getFont());
        masterPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout();
        layout.numColumns = 2;
        masterPanel.setLayout((Layout)layout);
        Label typesLabel = new Label(masterPanel, 16384);
        typesLabel.setText(this._creatorPres.getMasterLabel());
        GridData data = new GridData(16384, 0x1000000, true, false);
        typesLabel.setLayoutData((Object)data);
        Label descLabel = new Label(masterPanel, 16384);
        descLabel.setText(Messages.ComponentGalleryPage_descriptionLabel);
        data = new GridData(16384, 0x1000000, true, false);
        descLabel.setLayoutData((Object)data);
        this.createMasterVariationsComposite(masterPanel);
        this.createDescriptionComposite(masterPanel);
        Composite detailsContainer = new Composite(mainComposite, 0);
        detailsContainer.setFont(mainComposite.getFont());
        detailsContainer.setLayoutData((Object)new GridData(4, 1024, true, false));
        layout = new GridLayout();
        layout.numColumns = 1;
        detailsContainer.setLayout((Layout)layout);
        if (this._displayDetails) {
            Label detailsLabel = new Label(detailsContainer, 16384);
            detailsLabel.setText(this._creatorPres.getDetailLabel());
            data = new GridData(16384, 0x1000000, true, false);
            detailsLabel.setLayoutData((Object)data);
            this.createDetailsPanel(detailsContainer);
        }
        this.updateModel();
        return mainComposite;
    }

    private void createMasterVariationsComposite(Composite parent) {
        final ScrolledComposite scrollComposite = new ScrolledComposite(parent, 2560);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 280;
        gd.widthHint = 485;
        scrollComposite.setLayoutData((Object)gd);
        FillLayout scrollLayout = new FillLayout();
        scrollComposite.setLayout((Layout)scrollLayout);
        final Composite composite = new Composite((Composite)scrollComposite, 0);
        composite.setFont(parent.getFont());
        RowLayout layout = new RowLayout();
        layout.wrap = true;
        composite.setLayout((Layout)layout);
        composite.setBackground(this._colorListBackground);
        scrollComposite.setContent((Control)composite);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setMinHeight(150);
        scrollComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrollComposite.getClientArea();
                scrollComposite.setMinSize(composite.computeSize(r.width, -1));
            }
        });
        List<IPresentationVariation> variations = this._creatorPres.getPresentationVariations();
        if (variations != null && !variations.isEmpty()) {
            for (IPresentationVariation pv : variations) {
                PresentationVariationComposite pvComposite = new PresentationVariationComposite(composite, 0, pv, false);
                pvComposite.addSelectionListener(this._masterVariationsSelectionListener);
                this._masterVariations.add(pvComposite);
            }
            if (!this._masterVariations.isEmpty()) {
                this._selectedMaster = this._masterVariations.get(0);
                this._selectedMaster.setBackground(this._colorListSelection);
            }
        }
    }

    private void createDescriptionComposite(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(4, 4, false, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this._descriptionLabel = new Label(composite, 64);
        this.updateDescriptionLabel();
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 100;
        this._descriptionLabel.setLayoutData((Object)data);
    }

    private void updateDescriptionLabel() {
        String description;
        if (this._selectedMaster != null) {
            IPresentationVariation masterVariation = this._selectedMaster.getPresentationVariation();
            description = masterVariation.getHelpText();
        } else {
            description = "";
        }
        this._descriptionLabel.setText(description);
    }

    private void createDetailsPanel(Composite parent) {
        final ScrolledComposite scrollComposite = new ScrolledComposite(parent, 2304);
        GridData gd = new GridData();
        gd.minimumHeight = 115;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        gd.heightHint = 115;
        scrollComposite.setLayoutData((Object)gd);
        FillLayout scrollLayout = new FillLayout();
        scrollComposite.setLayout((Layout)scrollLayout);
        this._detailsContentPanel = new Composite((Composite)scrollComposite, 0);
        this._detailsContentLayout = new StackLayout();
        this._detailsContentPanel.setLayout((Layout)this._detailsContentLayout);
        scrollComposite.setContent((Control)this._detailsContentPanel);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setMinHeight(150);
        scrollComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrollComposite.getClientArea();
                scrollComposite.setMinSize(ComponentGalleryPage.this._detailsContentPanel.computeSize(-1, r.height));
            }
        });
        for (PresentationVariationComposite masterComposite : this._masterVariations) {
            DetailsComposite detailsComposite = new DetailsComposite(this._detailsContentPanel, 0, masterComposite.getPresentationVariation());
            detailsComposite.addPropertyChangeListener(this._detailsPropertyChangeListener);
            masterComposite.setDetailsComposite(detailsComposite);
        }
        if (!this._masterVariations.isEmpty()) {
            this._detailsContentLayout.topControl = this._masterVariations.get(0).getDetailsComposite();
            this._detailsContentPanel.layout();
        }
    }

    private void updateModel() {
        PresentationVariationComposite pvc;
        IPresentationVariation variation = this._selectedMaster.getPresentationVariation();
        String varType = variation.getProperties().get(this._variationTypePropName);
        String quickLayout = null;
        DetailsComposite dc = (DetailsComposite)this._selectedMaster.getDetailsComposite();
        if (dc != null && (pvc = dc.getSelectedDetail()) != null) {
            IPresentationVariation childVariation = pvc.getPresentationVariation();
            quickLayout = childVariation.getProperties().get("quickLayout");
        }
        PresentationLayout newLayout = new PresentationLayout(varType, quickLayout);
        IPresentationLayout currentLayout = this._optionsModel.getPresentationLayout();
        this._optionsModel.setPresentationLayout(newLayout);
        if (currentLayout == null || !DTRTUtil.equals((Object)varType, (Object)currentLayout.getVariationType())) {
            this._optionsModel.resetData();
            IWizardPage nextPage = this.getNextPage();
            if (nextPage instanceof WizardPage) {
                ((WizardPage)nextPage).setPageComplete(false);
                ((WizardPage)nextPage).setErrorMessage(null);
                if (this.getContainer().getCurrentPage() != null) {
                    this.getContainer().updateButtons();
                }
            }
        }
    }

    @Override
    protected IStatus getStatus() {
        return null;
    }

    public boolean isPageComplete() {
        IStatus status = this.getStatus();
        return status == null || status.getSeverity() != 4;
    }

    public void dispose() {
        for (PresentationVariationComposite masterComposite : this._masterVariations) {
            masterComposite.removeSelectionListener(this._masterVariationsSelectionListener);
            DetailsComposite dc = (DetailsComposite)masterComposite.getDetailsComposite();
            if (dc == null) continue;
            dc.removePropertyChangeListener(this._detailsPropertyChangeListener);
        }
        this._masterVariations.clear();
    }

    private class DetailsComposite
    extends Composite
    implements SelectionListener {
        public static final String PROP_DETAIL_SELECTED = "Detail Selected";
        private final List<PresentationVariationComposite> _childDetails;
        private PresentationVariationComposite _selectedDetail;
        private PropertyChangeSupport _propChangeSupport;

        public DetailsComposite(Composite parent, int style, IPresentationVariation masterVariation) {
            super(parent, style);
            this._childDetails = new ArrayList<PresentationVariationComposite>();
            this._propChangeSupport = new PropertyChangeSupport((Object)this);
            List<IPresentationVariation> childVariations = masterVariation.getChildren();
            if (childVariations != null && !childVariations.isEmpty()) {
                RowLayout layout = new RowLayout();
                layout.wrap = true;
                this.setLayout((Layout)layout);
                this.setBackground(ComponentGalleryPage.this._colorListBackground);
                for (IPresentationVariation childVariation : childVariations) {
                    PresentationVariationComposite childDetail = new PresentationVariationComposite(this, 0, childVariation, true);
                    childDetail.addSelectionListener(this);
                    this._childDetails.add(childDetail);
                }
                if (!this._childDetails.isEmpty()) {
                    this._selectedDetail = this._childDetails.get(0);
                    this._selectedDetail.setBackground(ComponentGalleryPage.this._colorListSelection);
                }
            }
        }

        public void dispose() {
            for (PresentationVariationComposite childDetail : this._childDetails) {
                childDetail.removeSelectionListener(this);
            }
            this._childDetails.clear();
        }

        public PresentationVariationComposite getSelectedDetail() {
            return this._selectedDetail;
        }

        public void widgetSelected(SelectionEvent e) {
            this._selectedDetail.setBackground(ComponentGalleryPage.this._colorListBackground);
            PresentationVariationComposite oldSelection = this._selectedDetail;
            this._selectedDetail = (PresentationVariationComposite)e.widget;
            this._selectedDetail.setBackground(ComponentGalleryPage.this._colorListSelection);
            this._propChangeSupport.firePropertyChange(PROP_DETAIL_SELECTED, (Object)oldSelection, (Object)this._selectedDetail);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this._propChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this._propChangeSupport.removePropertyChangeListener(listener);
        }
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("Detail Selected".equals(event.getPropertyName())) {
                ComponentGalleryPage.this.updateModel();
            }
        }
    }

    private class MySelectionListener
    extends SelectionAdapter {
        private MySelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            ComponentGalleryPage.this._selectedMaster.setBackground(ComponentGalleryPage.this._colorListBackground);
            ComponentGalleryPage.this._selectedMaster = (PresentationVariationComposite)event.widget;
            ComponentGalleryPage.this._selectedMaster.setBackground(ComponentGalleryPage.this._colorListSelection);
            ComponentGalleryPage.this.updateDescriptionLabel();
            if (ComponentGalleryPage.this._displayDetails) {
                ((ComponentGalleryPage)ComponentGalleryPage.this)._detailsContentLayout.topControl = ComponentGalleryPage.this._selectedMaster.getDetailsComposite();
                ComponentGalleryPage.this._detailsContentPanel.layout();
            }
            ComponentGalleryPage.this.updateModel();
        }
    }
}

