/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.AttributeRowValue;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.ListDiffStrategy;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.SimpleListDiff;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;

public class ValueToListMappingObservableList<T>
extends AbstractObservableList {
    private List<IObservableValue> valuesToMap;
    protected List<AttributeRowValue> mappingList = Collections.EMPTY_LIST;
    private IValueChangeListener changeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            ValueToListMappingObservableList.this.fireListChange(ValueToListMappingObservableList.this.calculate());
        }
    };
    private ListDiffStrategy<T> listDiffStrategy;

    public ValueToListMappingObservableList(List<IObservableValue> attrNames, ListDiffStrategy<T> listDiffStrategy) {
        this.valuesToMap = attrNames;
        for (IObservableValue value : this.valuesToMap) {
            value.addValueChangeListener(this.changeListener);
        }
        this.listDiffStrategy = listDiffStrategy;
        this.calculate();
    }

    public synchronized void dispose() {
        super.dispose();
        for (IObservableValue value : this.valuesToMap) {
            value.removeValueChangeListener(this.changeListener);
        }
    }

    protected ListDiff calculate() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (IObservableValue value : this.valuesToMap) {
            values.add(value.getValue());
        }
        SimpleListDiff<AttributeRowValue> simpleListDiff = this.listDiffStrategy.calculate(values, this.mappingList);
        this.mappingList = simpleListDiff.getNewList();
        return simpleListDiff;
    }

    public Object getElementType() {
        return AttributeRowValue.class;
    }

    protected int doGetSize() {
        return this.mappingList != null ? this.mappingList.size() : 0;
    }

    public AttributeRowValue get(int index) {
        return this.mappingList != null ? this.mappingList.get(index) : null;
    }
}

