/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.dialog.common;

import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.EditorLabelMessages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.dialog.advisor.AbstractBindingSelectionValueCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorValueCreationAdvisor;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public abstract class AbstractSimplifiedTreeSelectionDialog
extends ElementTreeSelectionDialog {
    private static final boolean IS_DEBUG = true;
    private final AbstractBindingSelectionValueCreationAdvisor advisor;
    private final List<ViewerFilter> filters;
    private Label _messageArea;
    private boolean isOkOverridden;
    private TreeViewer treeViewer;
    private ITreeContentProvider contentProvider;
    private Object input;
    private Composite noSelectionsLabelComposite;

    public AbstractSimplifiedTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, List<ViewerFilter> filters, AbstractBindingSelectionValueCreationAdvisor advisor) {
        super(parent, labelProvider, contentProvider);
        this.advisor = advisor;
        this.filters = filters;
        this.setComparator(this.advisor.getViewerComparator());
        this.contentProvider = contentProvider;
        this.setDoubleClickSelects(false);
        this.setAllowMultiple(false);
    }

    public AbstractDialogEditorValueCreationAdvisor<IObservableValue, UpdateValueStrategy> getAdvisor() {
        return this.advisor;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (!this.isEmptyTree()) {
            this.doBindData();
        }
        return control;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, this.advisor.getHelpId());
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.input = input;
    }

    protected Control createDialogArea(Composite parent) {
        if (this.isEmptyTree()) {
            this.noSelectionsLabelComposite = new Composite(parent, 0);
            this.noSelectionsLabelComposite.setLayout((Layout)new GridLayout(1, true));
            GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.noSelectionsLabelComposite);
            Label label = new Label(this.noSelectionsLabelComposite, 0);
            label.setText(EditorLabelMessages.AbstractSimplifiedTreeSelectionDialog_ThereAreNoAvailableSelection);
            GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)label);
            this.advisor.setInitialized();
            this.treeViewer = this.createTreeViewer(parent);
            return this.noSelectionsLabelComposite;
        }
        Composite createdDialogArea = (Composite)super.createDialogArea(parent);
        return this.advisor.createEditingArea(createdDialogArea);
    }

    public void create() {
        super.create();
        if (this.isEmptyTree()) {
            this.treeViewer.getTree().dispose();
            this.treeViewer = null;
            this.getShell().pack();
            this.getOkButton().setEnabled(false);
        }
    }

    private boolean isEmptyTree() {
        Object[] elements = this.contentProvider.getElements(this.input);
        if (elements.length > 0 && this.filters != null) {
            for (ViewerFilter filter : this.filters) {
                elements = filter.filter((Viewer)this.treeViewer, null, elements);
            }
        }
        return elements.length == 0;
    }

    protected Label createMessageArea(Composite composite) {
        this._messageArea = super.createMessageArea(composite);
        return this._messageArea;
    }

    protected void doBindData() {
        final AbstractDialogEditorCreationAdvisor.IStatusUpdater statusUpdater = this.createStatusUpdater();
        this.advisor.bindData((IObservableValue)new AbstractObservableValue(){

            protected void doSetValue(Object value) {
                AbstractSimplifiedTreeSelectionDialog.this.setMessage((String)value);
                AbstractSimplifiedTreeSelectionDialog.this._messageArea.setText((String)value);
                AbstractSimplifiedTreeSelectionDialog.this._messageArea.getParent().layout(true);
            }

            protected Object doGetValue() {
                return AbstractSimplifiedTreeSelectionDialog.this.getMessage();
            }

            public Object getValueType() {
                return String.class;
            }
        }, statusUpdater);
        final IObservableValue stateModel = (IObservableValue)this.advisor.getSelectionModel().getStateModel();
        Object selection = stateModel.getValue();
        this.setInitialSelection(selection);
        if (selection == null) {
            this.getOkButton().setEnabled(false);
            IValueChangeListener listener = new IValueChangeListener(){

                public void handleValueChange(ValueChangeEvent event) {
                    if (AbstractSimplifiedTreeSelectionDialog.this.isOkOverridden) {
                        statusUpdater.updateStatus(Status.OK_STATUS);
                        AbstractSimplifiedTreeSelectionDialog.this.isOkOverridden = false;
                    }
                    stateModel.removeValueChangeListener((IValueChangeListener)this);
                }
            };
            stateModel.addValueChangeListener(listener);
        } else {
            this.getTreeViewer().expandToLevel(selection, 1);
        }
    }

    private AbstractDialogEditorCreationAdvisor.IStatusUpdater createStatusUpdater() {
        return new StatusUpdater();
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (((IObservableValue)this.advisor.getSelectionModel().getStateModel()).getValue() == null) {
            this.getOkButton().setEnabled(false);
            boolean bl = this.isOkOverridden = status.getSeverity() < 4;
        }
        if (status.getSeverity() == 4) {
            this.isOkOverridden = false;
        }
    }

    protected void updateOKStatus() {
    }

    public boolean close() {
        this.advisor.dispose();
        return super.close();
    }

    protected void computeResult() {
        super.computeResult();
        this.advisor.computeResult();
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        this.treeViewer = super.doCreateTreeViewer(parent, style);
        this.advisor.setInitialized();
        IViewerObservableValue selectionModel = ViewersObservables.observeSingleSelection((Viewer)this.treeViewer);
        this.advisor.getSelectionModel().setStateModel((IObservable)selectionModel);
        for (ViewerFilter filter : this.filters) {
            this.treeViewer.addFilter(filter);
        }
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement;
                ISelection selection = event.getSelection();
                System.out.printf("Selection: %s\n", selection != null ? selection.toString() : null);
                if (selection instanceof ITreeSelection && (firstElement = ((ITreeSelection)selection).getFirstElement()) instanceof IDataControlObject) {
                    do {
                        System.out.printf("\tParent: %s\n", ((IDataControlObject)firstElement).getParent());
                    } while ((firstElement = ((IDataControlObject)firstElement).getParent()) != null);
                }
            }
        });
        return this.treeViewer;
    }

    private class StatusUpdater
    implements AbstractDialogEditorCreationAdvisor.IStatusUpdater {
        private StatusUpdater() {
        }

        public void updateStatus(IStatus status) {
            if (status.isMultiStatus() && status.getChildren().length > 0) {
                if (status.getChildren()[0].isMultiStatus()) {
                    this.updateStatus(status.getChildren()[0]);
                    return;
                }
                this.updateStatus(status.getChildren()[0]);
                return;
            }
            if (status.isOK()) {
                AbstractSimplifiedTreeSelectionDialog.this.updateStatus((IStatus)new Status(0, "oracle.eclipse.tools.adf.dtrt.vcommon", ""));
            } else {
                AbstractSimplifiedTreeSelectionDialog.this.updateStatus(status);
            }
        }
    }
}

