/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control;

import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.SelectionBasedEditorFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.TableFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.TreeTableFactory;
import oracle.eclipse.tools.xml.edit.ui.propeditor.FormsWidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TreeDrivenTablePropertyEditor
extends PropertyEditor {
    private final FormToolkit formToolkit;
    private final TableFactory tableFactory;
    private final TreeTableFactory treeFactory;
    private final boolean isInitialized;
    private final SelectionBasedEditorFactory treeEditorFactory;
    private final SelectionBasedEditorFactory tableEditorFactory;
    private CheckboxTreeViewer treeViewer;
    private TableViewer tableViewer;
    private SelectionBasedEditorFactory.SelectionBasedEditorPanel tableEditorPanel;
    private IObservableValue removeTableActionEnabled;
    private IObservableValue addTableActionEnabled;
    private SelectionBasedEditorFactory.SelectionBasedEditorPanel treeEditorPanel;
    private IObservableValue addTreeActionEnabled;
    private IObservableValue removeTreeActionEnabled;
    private ObservablesManager myObservableManager;
    private DataBindingContext myDataBindingContext;

    public TreeDrivenTablePropertyEditor(Composite parent, FormToolkit toolkit, TableFactory tableFactory, TreeTableFactory treeFactory, SelectionBasedEditorFactory tableEditorFactory, SelectionBasedEditorFactory treeEditorFactory) {
        super(parent, (WidgetAdapter)FormsWidgetAdapter.INSTANCE);
        this.formToolkit = toolkit;
        this.tableFactory = tableFactory;
        this.treeFactory = treeFactory;
        this.tableEditorFactory = tableEditorFactory;
        this.treeEditorFactory = treeEditorFactory;
        this.isInitialized = true;
        this.myDataBindingContext = new DataBindingContext();
        this.myObservableManager = new ObservablesManager();
        this.myObservableManager.addObservablesFromContext(this.myDataBindingContext, true, true);
        this.create(parent);
    }

    public void create(Composite parent) {
        if (this.isInitialized) {
            super.create(parent);
        }
    }

    protected Composite createControl(Composite parent) {
        Composite editorComposite = new Composite(parent, 0);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)editorComposite);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(4).applyTo(editorComposite);
        Composite treeComposite = new Composite(editorComposite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)treeComposite);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)treeColumnLayout);
        Tree tree = this.treeFactory.build(this.formToolkit, treeComposite);
        this.treeViewer = new CheckboxTreeViewer(tree);
        if (this.treeEditorFactory != null) {
            this.createTreeEditor(editorComposite);
        }
        Composite tableComposite = new Composite(editorComposite, 0);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)tableComposite);
        GridDataFactory.createFrom((GridData)((GridData)tableComposite.getLayoutData())).hint(-1, this.treeViewer.getTree().getItemHeight() * 12).indent(8, 0).applyTo((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        Table table = this.tableFactory.build(this.formToolkit, tableComposite);
        this.tableViewer = new TableViewer(table);
        if (this.tableEditorFactory != null) {
            this.createTableEditor(editorComposite);
        }
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.tableViewer, (ColumnViewerEditorActivationStrategy)actSupport, (int)1);
        return editorComposite;
    }

    private void createTreeEditor(Composite editorComposite) {
        this.treeEditorPanel = this.treeEditorFactory.build((ISelectionProvider)this.treeViewer);
        if (this.treeEditorPanel != null) {
            ToolBar toolbar = this.treeEditorPanel.createControls(editorComposite);
            GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)toolbar);
            final IViewerObservableValue observeTreeChanges = ViewersObservables.observeSingleSelection((Viewer)this.treeViewer);
            this.addTreeActionEnabled = this.treeEditorPanel.getAddActionEnabled();
            if (this.addTreeActionEnabled != null) {
                ComputedValue computedEnablement = new ComputedValue(){

                    protected Object calculate() {
                        observeTreeChanges.getValue();
                        Object numActionChildren = TreeDrivenTablePropertyEditor.this.treeEditorPanel.getAddAction().getNumChildren().getValue();
                        return !Integer.valueOf(0).equals(numActionChildren);
                    }
                };
                this.myDataBindingContext.bindValue(this.addTreeActionEnabled, (IObservableValue)computedEnablement, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy());
            }
            this.removeTreeActionEnabled = this.treeEditorPanel.getRemoveActionEnabled();
            if (this.removeTreeActionEnabled != null) {
                ComputedValue computeEnablement = new ComputedValue(){

                    protected Object calculate() {
                        Object value = observeTreeChanges.getValue();
                        if (value instanceof ITreeReference) {
                            return true;
                        }
                        return false;
                    }
                };
                this.myDataBindingContext.bindValue(this.removeTreeActionEnabled, (IObservableValue)computeEnablement, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy());
            }
        }
    }

    private void createTableEditor(Composite editorComposite) {
        this.tableEditorPanel = this.tableEditorFactory.build((ISelectionProvider)this.tableViewer);
        if (this.tableEditorPanel != null) {
            ToolBar toolbar = this.tableEditorPanel.createControls(editorComposite);
            GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)toolbar);
            final IViewerObservableValue observeTreeChanges = ViewersObservables.observeSingleSelection((Viewer)this.treeViewer);
            this.addTableActionEnabled = this.tableEditorPanel.getAddActionEnabled();
            if (this.addTableActionEnabled != null) {
                ComputedValue computeEnablement = new ComputedValue(){

                    protected Object calculate() {
                        boolean enabled;
                        Object value = observeTreeChanges.getValue();
                        boolean bl = enabled = value != null;
                        if (value instanceof ITreeReference) {
                            enabled &= ((ITreeReference)value).isPrimaryReference();
                        }
                        return enabled;
                    }
                };
                this.myDataBindingContext.bindValue(this.addTableActionEnabled, (IObservableValue)computeEnablement, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy());
            }
            this.removeTableActionEnabled = this.tableEditorPanel.getRemoveActionEnabled();
            if (this.removeTableActionEnabled != null) {
                final IViewerObservableValue tableSelectionObservable = ViewersObservables.observeSingleSelection((Viewer)this.tableViewer);
                ComputedValue computeEnablement = new ComputedValue(){

                    protected Object calculate() {
                        boolean isEnabled;
                        Object value = observeTreeChanges.getValue();
                        Object tableSelection = tableSelectionObservable.getValue();
                        boolean bl = isEnabled = tableSelection != null;
                        if (value instanceof ITreeReference) {
                            isEnabled &= ((ITreeReference)value).isPrimaryReference();
                        }
                        return isEnabled;
                    }
                };
                this.myDataBindingContext.bindValue(this.removeTableActionEnabled, (IObservableValue)computeEnablement, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy());
            }
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.removeTableActionEnabled != null) {
            this.removeTableActionEnabled.setValue((Object)Boolean.FALSE);
        }
        Boolean enabledBoolean = enabled;
        if (this.addTableActionEnabled != null) {
            this.addTableActionEnabled.setValue((Object)enabledBoolean);
        }
        if (this.addTreeActionEnabled != null) {
            this.addTreeActionEnabled.setValue((Object)enabledBoolean);
        }
        if (this.removeTreeActionEnabled != null) {
            this.removeTreeActionEnabled.setValue((Object)enabledBoolean);
        }
        this.myDataBindingContext.updateTargets();
    }

    public IObservableValue getEnablementObservable() {
        return new AbstractObservableValue(){

            public Object getValueType() {
                return Boolean.class;
            }

            protected Object doGetValue() {
                return TreeDrivenTablePropertyEditor.this.isEnabled();
            }

            protected void doSetValue(Object value) {
                boolean oldValue = TreeDrivenTablePropertyEditor.this.isEnabled();
                if ((Boolean)value != oldValue) {
                    TreeDrivenTablePropertyEditor.this.setEnabled((Boolean)value);
                    this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
                }
            }
        };
    }

    public IObservableValue getObservableValue(int event) {
        return null;
    }

    protected void doSetFocus() {
    }

    public void setTreeContentProvider(ITreeContentProvider provider) {
        this.treeViewer.setContentProvider((IContentProvider)provider);
    }

    public void setTableContentProvider(IContentProvider provider) {
        this.tableViewer.setContentProvider(provider);
    }

    public void setTreeInput(Object input) {
        this.treeViewer.setInput(input);
    }

    public void setCheckStateProvider(ICheckStateProvider provider) {
        this.treeViewer.setCheckStateProvider(provider);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.treeViewer.addCheckStateListener(listener);
    }

    public void addTreeSelectionListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public void setTableInput(Object input) {
        this.tableViewer.setInput(input);
    }

    public void setTableLabelProvider(ITableLabelProvider labelProvider) {
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setTreeLabelProvider(ILabelProvider labelProvider) {
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public IObservableValue getTreeAddActionEnablement() {
        return this.treeEditorPanel.getAddActionEnabled();
    }

    public IObservableValue getTreeRemoveActionEnablement() {
        return this.treeEditorPanel.getRemoveActionEnabled();
    }

    public void dispose() {
        IContentProvider contentProvider;
        super.dispose();
        if (this.myObservableManager != null) {
            this.myObservableManager.dispose();
            this.myObservableManager = null;
        }
        this.myDataBindingContext.dispose();
        if (this.tableViewer != null) {
            contentProvider = this.tableViewer.getContentProvider();
            if (contentProvider != null) {
                contentProvider.dispose();
            }
            this.tableViewer = null;
        }
        if (this.treeViewer != null) {
            contentProvider = this.treeViewer.getContentProvider();
            if (contentProvider != null) {
                contentProvider.dispose();
            }
            this.treeViewer = null;
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public static interface ITreeReference {
        public boolean isPrimaryReference();
    }
}

