/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control;

import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.SelectionBasedEditorFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.TableFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.converter.NonNullToBooleanConverter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.FormsWidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TablePropertyEditor
extends PropertyEditor {
    private final FormToolkit formToolkit;
    private final TableFactory tableFactory;
    private final boolean isInitialized;
    private final SelectionBasedEditorFactory tableEditorFactory;
    private final DataBindingContext myDataBindingContext;
    private TableViewer tableViewer;
    private SelectionBasedEditorFactory.SelectionBasedEditorPanel tableEditorPanel;
    private IObservableValue removeActionEnabled;
    private IObservableValue addActionEnabled;
    private ObservablesManager observableManager;

    protected TablePropertyEditor(Composite parent, FormToolkit formToolkit, TableFactory tableFactory, SelectionBasedEditorFactory tableEditorFactory) {
        super(parent, (WidgetAdapter)FormsWidgetAdapter.INSTANCE);
        this.formToolkit = formToolkit;
        this.tableFactory = tableFactory;
        this.tableEditorFactory = tableEditorFactory;
        this.isInitialized = true;
        this.myDataBindingContext = new DataBindingContext();
        this.observableManager = new ObservablesManager();
        this.create(parent);
    }

    public void create(Composite parent) {
        if (this.isInitialized) {
            super.create(parent);
        }
    }

    protected Composite createControl(Composite parent) {
        Composite editorComposite = new Composite(parent, 0);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)editorComposite);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(this.tableEditorFactory != null ? 2 : 1).applyTo(editorComposite);
        Composite tableComposite = new Composite(editorComposite, 0);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        Table table = this.tableFactory.build(this.formToolkit, tableComposite);
        this.tableViewer = new TableViewer(table);
        if (this.tableEditorFactory != null) {
            this.tableEditorPanel = this.tableEditorFactory.build((ISelectionProvider)this.tableViewer);
            if (this.tableEditorPanel != null) {
                ToolBar toolbar = this.tableEditorPanel.createControls(editorComposite);
                GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)toolbar);
                this.addActionEnabled = this.tableEditorPanel.getAddActionEnabled();
                this.removeActionEnabled = this.tableEditorPanel.getRemoveActionEnabled();
                if (this.removeActionEnabled != null) {
                    this.myDataBindingContext.bindValue(this.removeActionEnabled, (IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.tableViewer), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new NonNullToBooleanConverter()));
                }
            }
        }
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.tableViewer, (ColumnViewerEditorActivationStrategy)actSupport, (int)1);
        this.observableManager.addObservablesFromContext(this.myDataBindingContext, true, true);
        return tableComposite;
    }

    public void setEnabled(boolean enabled) {
        if (this.removeActionEnabled != null) {
            this.removeActionEnabled.setValue((Object)Boolean.FALSE);
        }
        if (this.addActionEnabled != null) {
            this.addActionEnabled.setValue((Object)enabled);
        }
        if (enabled) {
            this.myDataBindingContext.updateTargets();
        }
        super.setEnabled(enabled);
    }

    public IObservableValue getEnablementObservable() {
        return new AbstractObservableValue(){

            public Object getValueType() {
                return Boolean.class;
            }

            protected Object doGetValue() {
                return TablePropertyEditor.this.isEnabled();
            }

            protected void doSetValue(Object value) {
                boolean oldValue = TablePropertyEditor.this.isEnabled();
                if ((Boolean)value != oldValue) {
                    TablePropertyEditor.this.setEnabled((Boolean)value);
                    this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
                }
            }
        };
    }

    public IObservableValue getObservableValue(int event) {
        return null;
    }

    protected void doSetFocus() {
    }

    public void setContentProvider(IContentProvider provider) {
        this.tableViewer.setContentProvider(provider);
    }

    public void setInput(Object input) {
        this.tableViewer.setInput(input);
    }

    public void setLabelProvider(ITableLabelProvider labelProvider) {
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    public void dispose() {
        super.dispose();
        this.myDataBindingContext.dispose();
        this.observableManager.dispose();
    }
}

