/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control;

import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.EditorLabelMessages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ActionFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ISelectionContributionItem;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;

public class SelectionBasedEditorFactory {
    private ActionFactory addActionFactory;
    private ActionFactory removeActionFactory;

    public SelectionBasedEditorPanel build(ISelectionProvider selectionProvider) {
        ISelectionContributionItem build;
        ToolBarManager toolBarMgr = new ToolBarManager(0x22800200);
        SelectionBasedEditorPanel panel = new SelectionBasedEditorPanel(toolBarMgr, selectionProvider);
        if (this.addActionFactory != null) {
            build = this.addActionFactory.build();
            build.setToolTipText(EditorLabelMessages.TableEditorFactory_AddActionTooltip);
            panel.setAddAction(build);
        }
        if (this.removeActionFactory != null) {
            build = this.removeActionFactory.build();
            build.setToolTipText(EditorLabelMessages.TableEditorFactory_RemoveActionTooltip);
            panel.setRemoveAction(build);
        }
        return panel;
    }

    public SelectionBasedEditorFactory actionAdd(ActionFactory actionFactory) {
        this.addActionFactory = actionFactory;
        return this;
    }

    public SelectionBasedEditorFactory actionRemove(ActionFactory actionFactory) {
        this.removeActionFactory = actionFactory;
        return this;
    }

    public static class SelectionBasedEditorPanel {
        private ToolBarManager toolBarManager;
        private ISelectionContributionItem addAction;
        private ISelectionContributionItem removeAction;
        private ISelectionProvider selectionProvider;

        public SelectionBasedEditorPanel(ToolBarManager toolBarManager, ISelectionProvider selectionProvider) {
            this.toolBarManager = toolBarManager;
            this.selectionProvider = selectionProvider;
        }

        public ISelectionContributionItem getAddAction() {
            return this.addAction;
        }

        public ISelectionContributionItem getRemoveAction() {
            return this.removeAction;
        }

        protected void setAddAction(ISelectionContributionItem action) {
            this.addAction = action;
        }

        protected void setRemoveAction(ISelectionContributionItem action) {
            this.removeAction = action;
        }

        public IObservableValue getAddActionEnabled() {
            return this.addAction != null ? this.addAction.getEnabled() : null;
        }

        public IObservableValue getRemoveActionEnabled() {
            return this.removeAction != null ? this.removeAction.getEnabled() : null;
        }

        public ToolBar createControls(Composite parent) {
            if (this.addAction != null) {
                this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.addAction);
                this.toolBarManager.add((IContributionItem)this.addAction);
            }
            if (this.removeAction != null) {
                this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.removeAction);
                this.toolBarManager.add((IContributionItem)this.removeAction);
            }
            ToolBar toolBar = this.toolBarManager.createControl(parent);
            toolBar.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (SelectionBasedEditorPanel.this.selectionProvider != null) {
                        if (SelectionBasedEditorPanel.this.addAction != null) {
                            SelectionBasedEditorPanel.this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)SelectionBasedEditorPanel.this.addAction);
                        }
                        if (SelectionBasedEditorPanel.this.removeAction != null) {
                            SelectionBasedEditorPanel.this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)SelectionBasedEditorPanel.this.removeAction);
                        }
                    }
                }
            });
            return toolBar;
        }
    }
}

