/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.xml.edit.ui.propeditor.AbstractDialogPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.FormsWidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.WidgetValueProperty;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormTextPropertyEditor
extends AbstractDialogPropertyEditor {
    private FormText formText;
    private FormToolkit toolkit;
    private boolean isInitialized;

    public FormTextPropertyEditor(Composite parent, FormToolkit toolkit, List<DialogCreationStrategy> creationStrategy) {
        super(parent, creationStrategy, (WidgetAdapter)FormsWidgetAdapter.INSTANCE, true);
        this.toolkit = toolkit;
        this.isInitialized = true;
        this.create(parent);
        this.createDialogButtons();
    }

    public void setDialogCreationStrategies(List<DialogCreationStrategy> strategies) {
        this.strategies = Collections.unmodifiableList(strategies);
    }

    protected void createDialogButtons() {
        if (!this.strategies.isEmpty()) {
            super.createDialogButtons();
        }
    }

    public void create(Composite parent) {
        if (this.isInitialized) {
            super.create(parent);
        }
    }

    protected Control createControl(Composite parent) {
        Composite editor = this.getWidgetAdapter().createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        editor.setLayout((Layout)layout);
        int style = 4;
        if (this.mustEditWithDialog()) {
            style |= 8;
        }
        Control bindingControl = this.createBindingControl(editor, style);
        GridData gridData = new GridData(4, 0x1000008, true, false);
        bindingControl.setLayoutData((Object)gridData);
        return editor;
    }

    protected Control createBindingControl(Composite parent, int style) {
        this.formText = DTRTUIUtil.createFormText((FormToolkit)this.toolkit, (Composite)parent, (int)style);
        return this.formText;
    }

    public Control getBindingControl() {
        return this.formText;
    }

    public IObservableValue getObservableValue(int event) {
        return new FormTextTextProperty().observe((Widget)this.formText);
    }

    protected void doSetFocus() {
        this.formText.setFocus();
    }

    private static class FormTextTextProperty
    extends WidgetValueProperty {
        private FormTextTextProperty() {
        }

        public Object getValueType() {
            return String.class;
        }

        protected Object doGetValue(Object source) {
            return null;
        }

        protected void doSetValue(Object source, Object value) {
            boolean hasTags = value != null && !((String)value).isEmpty();
            ((FormText)source).setText(value == null ? "" : (String)value, hasTags, hasTags);
            ((FormText)source).getParent().getParent().layout(true, true);
        }
    }
}

