/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control;

import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.command.SelectionOperationHandler;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ISelectionContributionItem;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.databinding.util.JFaceProperties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ActionFactory {
    protected String text;
    protected ImageDescriptor imageDesc;
    private SelectionOperationHandler operationHandler;

    public ISelectionContributionItem build() {
        if (this.operationHandler == null) {
            throw new AssertionError((Object)"valueRunnable and command must both be set");
        }
        DataBoundCommandAction commandAction = new DataBoundCommandAction(this.operationHandler);
        if (this.text != null) {
            commandAction.setText(this.text);
            commandAction.setToolTipText(this.text);
        }
        if (this.imageDesc != null) {
            commandAction.setImageDescriptor(this.imageDesc);
        }
        DataBoundCommandActionContribution dataBoundCommandActionContribution = new DataBoundCommandActionContribution(commandAction);
        dataBoundCommandActionContribution.update();
        return dataBoundCommandActionContribution;
    }

    public ActionFactory handler(SelectionOperationHandler operationHandler) {
        this.operationHandler = operationHandler;
        return this;
    }

    public ActionFactory image(ImageDescriptor imageDesc) {
        this.imageDesc = imageDesc;
        return this;
    }

    public ActionFactory text(String text) {
        this.text = text;
        return this;
    }

    public static class DataBoundCommandAction
    extends Action {
        private IObservableValue enabledObservable;
        private SelectionOperationHandler operationHandler;
        private ISelection selection;
        private IObservableValue visibleObservable;

        public DataBoundCommandAction(SelectionOperationHandler operationHandler) {
            this.operationHandler = operationHandler;
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        public IObservableValue getEnabled() {
            if (this.enabledObservable == null) {
                this.enabledObservable = JFaceProperties.value(IAction.class, (String)"enabled", (String)"enabled").observe((Object)this);
            }
            return this.enabledObservable;
        }

        public IObservableValue getVisible() {
            if (this.visibleObservable == null) {
                this.visibleObservable = JFaceProperties.value(IAction.class, (String)"visible", (String)"enabled").observe((Object)this);
            }
            return this.visibleObservable;
        }

        public void runWithEvent(final Event event) {
            Realm.getDefault().exec(new Runnable(){

                @Override
                public void run() {
                    ICommand command;
                    try {
                        Widget widget = event.widget;
                        if (widget instanceof ToolItem && !widget.isDisposed()) {
                            ToolBar toolBar = ((ToolItem)widget).getParent();
                            if (widget.getDisplay().getFocusControl() != toolBar) {
                                toolBar.forceFocus();
                            }
                        }
                    }
                    catch (Exception exception) {}
                    if ((command = DataBoundCommandAction.this.operationHandler.createHandlerCommand(DataBoundCommandAction.this.selection)) != null) {
                        DataBoundCommandAction.this.operationHandler.execute(command);
                    }
                }
            });
        }
    }

    public static class DataBoundCommandActionContribution
    extends ActionContributionItem
    implements ISelectionContributionItem {
        public DataBoundCommandActionContribution(DataBoundCommandAction action) {
            super((IAction)action);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ((DataBoundCommandAction)this.getAction()).setSelection(event.getSelection());
        }

        @Override
        public void setToolTipText(String toolTipText) {
            ((DataBoundCommandAction)this.getAction()).setToolTipText(toolTipText);
        }

        @Override
        public IObservableValue getEnabled() {
            return ((DataBoundCommandAction)this.getAction()).getEnabled();
        }

        @Override
        public IObservableValue getVisible() {
            return ((DataBoundCommandAction)this.getAction()).getVisible();
        }

        @Override
        public void setSelection(ISelection newSelection) {
            ((DataBoundCommandAction)this.getAction()).setSelection(newSelection);
        }

        @Override
        public IObservableValue getNumChildren() {
            return Observables.constantObservableValue((Object)0, Integer.class);
        }
    }
}

