/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.binding;

import java.lang.reflect.Array;
import org.eclipse.core.databinding.observable.value.DecoratingObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;

public class SingleArrayElementObservableValue<T>
extends DecoratingObservableValue {
    private final int index;
    private Class<T> arrayType;
    private T objToSubForNull;

    public SingleArrayElementObservableValue(int index, Class<T> arrayType, IObservableValue decorated, boolean disposeDecoratedOnDispose) {
        this(index, arrayType, decorated, disposeDecoratedOnDispose, null);
    }

    public SingleArrayElementObservableValue(int index, Class<T> arrayType, IObservableValue decorated, boolean disposeDecoratedOnDispose, T objToSubForNull) {
        super(decorated, disposeDecoratedOnDispose);
        this.index = index;
        this.arrayType = arrayType;
        this.objToSubForNull = objToSubForNull;
    }

    public Object getValueType() {
        return null;
    }

    public void setValue(Object value) {
        Object curValue = this.getValue();
        Object[] array = (Object[])curValue;
        int newArraySize = Math.max(this.index + 1, array != null ? array.length : 0);
        Object[] newArray = (Object[])Array.newInstance(this.arrayType, newArraySize);
        if (array != null) {
            System.arraycopy(array, 0, newArray, 0, array.length);
        }
        newArray[this.index] = value;
        if (this.objToSubForNull != null) {
            int i = 0;
            while (i < newArray.length) {
                if (newArray[i] == null) {
                    newArray[i] = this.objToSubForNull;
                }
                ++i;
            }
        }
        super.setValue((Object)newArray);
    }
}

