/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.binding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public class SWTObservableFactory {
    public static final String SWT_OBSERVABLE_FACTORY_DATA_KEY = "oracle.eclipse.tools.adf.dtrt.v110101.editor.binding.SWTObservableFactory.DATA_KEY";

    public IObservableValue observeEnabled(Object key, Control control) {
        ObservableData obsData = this.getOrCreateObservableData(ObservedProperty.ENABLED, control);
        ISWTObservableValue observeEnabled = SWTObservables.observeEnabled((Control)control);
        obsData.addObservable(key, ObservedProperty.ENABLED, (IObservableValue)observeEnabled);
        return observeEnabled;
    }

    public IObservableValue observeSelection(Object key, Control control) {
        ObservableData obsData = this.getOrCreateObservableData(ObservedProperty.SELECTION, control);
        ISWTObservableValue observeSelection = SWTObservables.observeSelection((Control)control);
        obsData.addObservable(key, ObservedProperty.SELECTION, (IObservableValue)observeSelection);
        return observeSelection;
    }

    protected ObservableData getOrCreateObservableData(ObservedProperty property, Control control) {
        Object data = control.getData(SWT_OBSERVABLE_FACTORY_DATA_KEY);
        if (data instanceof ObservableData) {
            return (ObservableData)data;
        }
        ObservableData newData = new ObservableData();
        control.setData(SWT_OBSERVABLE_FACTORY_DATA_KEY, (Object)newData);
        control.addDisposeListener((DisposeListener)newData);
        return newData;
    }

    protected static class ObservableData
    implements DisposeListener {
        protected Map<Object, Map<ObservedProperty, IObservableValue>> attachedObservables = new HashMap<Object, Map<ObservedProperty, IObservableValue>>();

        public Map<Object, Map<ObservedProperty, IObservableValue>> getAttachedObservables() {
            return Collections.unmodifiableMap(this.attachedObservables);
        }

        public void addObservable(Object key, ObservedProperty property, IObservableValue value) {
            Map<ObservedProperty, IObservableValue> map = this.attachedObservables.get(key);
            if (map == null) {
                map = new HashMap<ObservedProperty, IObservableValue>();
                this.attachedObservables.put(key, map);
            }
            map.put(property, value);
        }

        public void widgetDisposed(DisposeEvent e) {
            if (this.attachedObservables != null) {
                this.attachedObservables.clear();
                this.attachedObservables = null;
            }
            e.widget.setData(SWTObservableFactory.SWT_OBSERVABLE_FACTORY_DATA_KEY, null);
        }
    }

    public static enum ObservedProperty {
        ENABLED,
        SELECTION;

    }
}

