/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class IsValidInstanceValidator
implements IValidator {
    private final String errorMessage;
    private final Set<Class> types;

    public IsValidInstanceValidator(Class type, String errorMessage) {
        this(Collections.singleton(type), errorMessage);
    }

    public IsValidInstanceValidator(Set<Class> types, String errorMessage) {
        this.types = types;
        this.errorMessage = errorMessage;
    }

    public IStatus validate(Object value) {
        Object adapt = this.adapt(value);
        IStatus result = Status.OK_STATUS;
        if (adapt != null) {
            Set<Class> expectedTypes = this.getExpectedTypes();
            ArrayList<Class> invalidTypes = new ArrayList<Class>(expectedTypes.size());
            for (Class expectedType : expectedTypes) {
                Class<? extends Object> actualType = this.calculateClass(adapt);
                if (value != null && (expectedType == null || actualType == null || expectedType.isAssignableFrom(actualType))) continue;
                invalidTypes.add(actualType);
            }
            if (invalidTypes.size() == expectedTypes.size()) {
                String actualType = this.foldToString(invalidTypes);
                String expectedType = this.foldToString(this.types);
                result = new Status(4, "oracle.eclipse.tools.adf.dtrt.vcommon", this.getErrorMessageString(this.errorMessage, expectedType, actualType));
            }
        }
        return result;
    }

    private String foldToString(Collection<Class> invalidTypes) {
        StringBuffer buffer = new StringBuffer();
        Iterator<Class> it = invalidTypes.iterator();
        if (it.hasNext()) {
            buffer.append(it.next().getName());
            while (it.hasNext()) {
                buffer.append(", ");
                buffer.append(it.next().getName());
            }
        }
        return buffer.toString();
    }

    protected Class<? extends Object> calculateClass(Object adapt) {
        return adapt.getClass();
    }

    protected Object adapt(Object object) {
        return object;
    }

    protected String getErrorMessageString(Object errorMessage, String expectedType, String actualType) {
        return errorMessage != null ? errorMessage.toString() : null;
    }

    protected Set<Class> getExpectedTypes() {
        return this.types;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

