/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.command;

import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.DTRTvCommonBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;

public abstract class SelectionOperationHandler {
    public abstract ICommand createHandlerCommand(ISelection var1);

    public abstract void execute(ICommand var1);

    public abstract Object getNewValue(ISelection var1);

    public static abstract class DefaultExecutingSelectionOperationHandler
    extends SelectionOperationHandler {
        private final IOEPEExecutableContext context;

        public DefaultExecutingSelectionOperationHandler(IOEPEExecutableContext context) {
            this.context = context;
        }

        @Override
        public void execute(ICommand command) {
            try {
                switch (ICommand.CommandOperation.nextOperation((ICommand)command)) {
                    case EXECUTION: {
                        this.context.setExecuteCommand(command);
                        this.context.execute((IProgressMonitor)new NullProgressMonitor());
                        break;
                    }
                    case UNDO: {
                        this.context.undo(null);
                        break;
                    }
                    case REDO: {
                        this.context.redo(null);
                    }
                }
            }
            catch (InterruptedException e) {
                this.handleExecuteException(e);
            }
            catch (CoreException e) {
                this.handleExecuteException((Exception)((Object)e));
            }
        }

        protected void handleExecuteException(Exception e) {
            DTRTvCommonBundle.log(e);
        }

        public IOEPEExecutableContext getContext() {
            return this.context;
        }
    }
}

