/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.options;

import java.util.List;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationVariation;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IPresentationOptionsModel;

public abstract class PresentationOptionsModel
implements IPresentationOptionsModel {
    private final String _componentTypePropertyName;
    private final ICreatorPresentation _creatorPresentation;
    private IPresentationLayout _presentationLayout;

    public PresentationOptionsModel(String componentTypePropertyName, ICreatorPresentation creatorPresentation) {
        if (componentTypePropertyName == null) {
            throw new IllegalArgumentException("Programming Error: Component type property name cannot be null");
        }
        if (creatorPresentation == null) {
            throw new IllegalArgumentException("Programming Error: Creator presentation cannot be null");
        }
        this._componentTypePropertyName = componentTypePropertyName;
        this._creatorPresentation = creatorPresentation;
    }

    @Override
    public ICreatorPresentation getCreatorPresentation() {
        return this._creatorPresentation;
    }

    @Override
    public IPresentationLayout getPresentationLayout() {
        return this._presentationLayout;
    }

    @Override
    public void setPresentationLayout(IPresentationLayout presentationLayout) {
        this._presentationLayout = presentationLayout;
    }

    @Override
    public String getLayoutVariationName() {
        String type;
        List<IPresentationVariation> variations = this.getCreatorPresentation().getPresentationVariations();
        if (this.getPresentationLayout() != null && (type = this.getPresentationLayout().getVariationType()) != null && variations != null && !variations.isEmpty()) {
            for (IPresentationVariation pv : variations) {
                if (!type.equals(pv.getProperties().get(this._componentTypePropertyName))) continue;
                return pv.getDescription();
            }
        }
        return null;
    }
}

