/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.manager;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import oracle.eclipse.tools.adf.dtrt.util.LinkedProperties;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.ManagedBinaryFile;
import org.eclipse.core.resources.IFile;

public class PropertiesElement
implements IDisposable,
ManagedBinaryFile.IBinaryElement {
    private IFile file;
    private Object data;
    private LinkedProperties properties;
    private String fullName;

    public PropertiesElement(IFile file) {
        this.file = file;
    }

    public void dispose() {
        this.file = null;
        this.data = null;
        this.properties = null;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public IFile getFile() {
        return this.file;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public String getProperty(String key) {
        return this.properties != null ? this.properties.getProperty(key) : null;
    }

    public void setProperty(String key, String value) {
        if (!DTRTUtil.isEmpty((String)key)) {
            if (DTRTUtil.isEmpty((String)value)) {
                if (this.properties != null) {
                    this.properties.remove((Object)key);
                }
            } else {
                if (this.properties == null) {
                    this.properties = new LinkedProperties();
                }
                this.properties.setProperty(key, value);
            }
        }
    }

    @Override
    public void setContent(ManagedBinaryFile.BinaryContent content) {
        if (this.properties != null) {
            this.properties.clear();
        }
        if (content == null) {
            this.properties = null;
        } else if (content.getBytes().length > 0) {
            if (this.properties == null) {
                this.properties = new LinkedProperties();
            }
            try {
                this.properties.load((InputStream)new ByteArrayInputStream(content.getBytes()));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public ManagedBinaryFile.BinaryContent getContent() {
        return this.properties != null ? new ManagedBinaryFile.BinaryContent(this.getBytes()) : null;
    }

    private byte[] getBytes() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.properties.store((OutputStream)out, null, false);
            return out.toByteArray();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

