/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.manager;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.IManagedFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.impl.PlatformResourceURIHandlerImpl;

public final class ManagedBinaryFile
implements IManagedFile<IBinaryElement, BinaryContent> {
    public static final byte[] EMPTY_ARRAY = new byte[0];
    private IFile file;
    private boolean fileWasLoaded = false;
    private byte[] persistedContent;
    private long timestamp = -1L;
    private byte[] recordingData;
    private boolean recording;

    public ManagedBinaryFile(IFile file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        this.file = file;
    }

    public void dispose() {
        this.file = null;
        this.persistedContent = null;
        this.recordingData = null;
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    private BinaryContent getContent(IBinaryElement element) {
        return element != null ? element.getContent() : null;
    }

    @Override
    public BinaryContent createContent() {
        return new BinaryContent();
    }

    @Override
    public BinaryContent loadContent() {
        this.checkDisposed();
        if (this.file.isAccessible()) {
            BinaryContent binaryContent;
            block9: {
                InputStream stream = null;
                try {
                    stream = new BufferedInputStream(this.file.getContents(true));
                    byte[] bytes = DTRTUtil.read((InputStream)stream);
                    this.fileWasLoaded = true;
                    this.timestamp = this.file.getModificationStamp();
                    assert (this.timestamp > 0L) : this.file;
                    binaryContent = new BinaryContent(bytes);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                stream.close();
            }
            return binaryContent;
        }
        return null;
    }

    @Override
    public void storePersistedContent(IBinaryElement element, boolean beginRecording) {
        BinaryContent content;
        if (element != null && (content = this.getContent(element)) != null) {
            this.checkDisposed();
            this.persistedContent = content.getBytes();
            if (beginRecording) {
                this.recording = true;
                this.recordingData = this.persistedContent;
            }
        }
    }

    @Override
    public boolean fileWasLoaded() {
        this.checkDisposed();
        return this.fileWasLoaded;
    }

    @Override
    public boolean hasChangedExternally() {
        this.checkDisposed();
        return this.file.getModificationStamp() != this.timestamp;
    }

    @Override
    public boolean needsSaving(IBinaryElement element) {
        byte[] bytes;
        this.checkDisposed();
        if (this.hasChangedExternally()) {
            return true;
        }
        BinaryContent binaryContent = this.getContent(element);
        byte[] byArray = bytes = binaryContent != null ? binaryContent.getBytes() : null;
        if (!this.file.isAccessible()) {
            return bytes != null && bytes.length > 0;
        }
        return !Arrays.equals(this.persistedContent, bytes);
    }

    @Override
    public void save(IBinaryElement element, IProgressMonitor monitor) throws Exception {
        byte[] bytes;
        this.checkDisposed();
        BinaryContent binaryContent = this.getContent(element);
        byte[] byArray = bytes = binaryContent != null ? binaryContent.getBytes() : null;
        if (bytes == null) {
            bytes = EMPTY_ARRAY;
        }
        try (OutputStream fileOutputStream = null;){
            fileOutputStream = this.createFileOutputStream(monitor);
            fileOutputStream.write(bytes);
            this.persistedContent = bytes;
        }
        assert (this.timestamp > 0L) : this.file;
    }

    private OutputStream createFileOutputStream(IProgressMonitor monitor) {
        this.checkDisposed();
        return new BufferedOutputStream((OutputStream)new PlatformResourceURIHandlerImpl.PlatformResourceOutputStream(this.file, true, true, monitor){

            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    ManagedBinaryFile.this.timestamp = this.file.getModificationStamp();
                    if (!$assertionsDisabled && ManagedBinaryFile.this.timestamp <= 0L) {
                        throw new AssertionError(this.file);
                    }
                }
            }
        });
    }

    @Override
    public boolean isRecording() {
        this.checkDisposed();
        return this.recording;
    }

    @Override
    public boolean beginRecording(IBinaryElement element) {
        return this.beginRecordingByContent(this.getContent(element));
    }

    @Override
    public boolean beginRecordingByContent(BinaryContent content) {
        this.checkDisposed();
        if (content != null) {
            if (this.isRecording()) {
                throw new IllegalStateException("Already recording - " + this);
            }
            this.recordingData = this.takeSnapshot(content);
            this.recording = true;
            return true;
        }
        return false;
    }

    @Override
    public Object endRecording(IBinaryElement element) {
        this.checkDisposed();
        if (element != null && this.isRecording()) {
            this.recording = false;
            byte[] aux = this.recordingData;
            this.recordingData = null;
            if (!Arrays.equals(aux, this.takeSnapshot(element))) {
                return aux;
            }
        }
        return null;
    }

    @Override
    public void resetRecording() {
        this.checkDisposed();
        this.recordingData = null;
    }

    @Override
    public void abortRecording(IBinaryElement content) {
        if (this.isRecording()) {
            this.recording = false;
            this.resetRecording();
        }
    }

    @Override
    public Object apply(IBinaryElement element, Object recordedData) {
        BinaryContent content;
        Object ret;
        if (element != null && (ret = this.applyByContent(content = element.getContent(), recordedData)) != null) {
            element.setContent(content);
            return ret;
        }
        return null;
    }

    @Override
    public Object applyByContent(BinaryContent content, Object recordedData) {
        this.checkDisposed();
        if (content != null && recordedData != null) {
            if (!(recordedData instanceof byte[])) {
                throw new IllegalArgumentException("The record data must be generated by this recorder");
            }
            byte[] bytes = (byte[])recordedData;
            byte[] beforeApplyData = this.takeSnapshot(content);
            content.setBytes(bytes);
            return beforeApplyData;
        }
        return null;
    }

    public byte[] takeSnapshot(IBinaryElement element) {
        this.checkDisposed();
        return this.takeSnapshot(this.getContent(element));
    }

    private byte[] takeSnapshot(BinaryContent content) {
        this.checkDisposed();
        byte[] bytes = content != null ? content.getBytes() : null;
        return bytes != null && bytes.length > 0 ? Arrays.copyOf(bytes, bytes.length) : EMPTY_ARRAY;
    }

    private void checkDisposed() {
        if (this.file == null) {
            throw new IllegalStateException("Managed binary file has been disposed.");
        }
    }

    public static final class BinaryContent {
        private byte[] bytes;

        public BinaryContent() {
        }

        public BinaryContent(byte[] bytes) {
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes == null ? EMPTY_ARRAY : this.bytes;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }
    }

    public static interface IBinaryElement {
        public BinaryContent getContent();

        public void setContent(BinaryContent var1);
    }
}

