/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.JavaUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.DTRTvCommonBundle;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public final class LocatorUtil {
    private static final String REGISTRY_PATH = "META-INF/adfm.xml";
    public static final String DEFAULT_SOURCE_FOLDER_NAME = "adfmsrc";

    private LocatorUtil() {
    }

    public static IFile getADFmRegistryFile(IProject project) throws IllegalArgumentException {
        Exception exception = null;
        try {
            IFile file = JavaUtil.getSourceFile((IProject)project, (String)REGISTRY_PATH, (boolean)true, (String)DEFAULT_SOURCE_FOLDER_NAME);
            if (file != null) {
                return file;
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            throw new IllegalArgumentException("Unable to get a file handle for the project: " + project, exception);
        }
        throw new IllegalArgumentException("Unable to get a file handle for the project: " + project);
    }

    public static List<IFile> getADFmRegistryFiles(IProject earProject, IProject webProject) throws IllegalArgumentException {
        assert (earProject != null);
        assert (webProject != null);
        Set projects = WtpProjectUtil.findProjectsReferencedByEar((IProject)earProject);
        ArrayList<IFile> registryFiles = new ArrayList<IFile>(projects.size() + 1);
        registryFiles.add(LocatorUtil.getADFmRegistryFile(webProject));
        for (IProject project : projects) {
            if (!DTRTUtil.isModelProject((IProject)project)) continue;
            try {
                IFile registryFile = JavaUtil.getSourceFile((IProject)project, (String)REGISTRY_PATH, (boolean)false, (String)DEFAULT_SOURCE_FOLDER_NAME);
                if (registryFile == null) continue;
                registryFiles.add(registryFile);
            }
            catch (Exception e) {
                DTRTvCommonBundle.log("Exception while getting the ADFm registry for model project: " + project, e);
            }
        }
        return registryFiles;
    }
}

