/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.documentrecorder;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.vcommon.DTRTvCommonBundle;
import oracle.eclipse.tools.adf.dtrt.vcommon.documentrecorder.SSEDocumentRecorder;
import org.w3c.dom.Document;

public abstract class DocumentRecorder {
    private static Set<Method> supportMethods;
    private boolean recording;
    private Object recordingData;

    public static boolean registerDocumentRecoder(Class<? extends DocumentRecorder> documentRecoderClass) {
        if (documentRecoderClass != null) {
            try {
                Method supportsMethod = documentRecoderClass.getMethod("supports", Document.class);
                if (supportsMethod != null && Modifier.isStatic(supportsMethod.getModifiers())) {
                    if (supportMethods == null) {
                        supportMethods = new HashSet<Method>(5);
                    }
                    supportMethods.add(supportsMethod);
                }
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    public static DocumentRecorder createDocumentRecorder(Document document) {
        if (SSEDocumentRecorder.supports(document)) {
            return new SSEDocumentRecorder();
        }
        if (supportMethods != null) {
            for (Method method : supportMethods) {
                try {
                    Object ret = method.invoke(null, document);
                    if (!Boolean.TRUE.equals(ret)) continue;
                    Object o = method.getClass().newInstance();
                    return (DocumentRecorder)o;
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    public abstract void resetRecording();

    protected Object getRecordingData() {
        return this.recordingData;
    }

    protected void setRecordingData(Object recordingData) {
        this.recordingData = recordingData;
    }

    public final boolean beginRecording(Document document) {
        if (this.isRecording()) {
            throw new IllegalStateException("Already recording - " + this);
        }
        this.doBeginRecording(document);
        this.recording = true;
        return this.isRecording();
    }

    protected final void markAsRecording() {
        this.recording = true;
    }

    protected abstract void doBeginRecording(Document var1);

    public final boolean isRecording() {
        return this.recording;
    }

    public final Object endRecording(Document document) {
        if (this.isRecording()) {
            this.recording = false;
            return this.doEndRecording(document, false);
        }
        return null;
    }

    public final void abortRecording(Document document) {
        if (this.isRecording()) {
            try {
                this.recording = false;
                this.doEndRecording(document, true);
            }
            catch (Exception e) {
                DTRTvCommonBundle.log(e);
            }
            this.resetRecording();
        }
    }

    protected abstract Object doEndRecording(Document var1, boolean var2);

    public abstract Object apply(Document var1, Object var2);
}

