/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.documentrecorder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.DTRTvCommonBundle;
import oracle.eclipse.tools.adf.dtrt.vcommon.documentrecorder.DocumentRecorder;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.AssertEqualBytesOutputStream;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DocumentBinaryRecorder
extends DocumentRecorder {
    private static final byte[] MAGIC_NUMBER = new byte[]{110, 68};
    private static final byte[] EMPTY_DOCUMENT = Arrays.copyOf(MAGIC_NUMBER, MAGIC_NUMBER.length + 4);

    @Override
    public final void resetRecording() {
        this.setRecordingData(null);
    }

    public final Object takeSnapshot(Document document) {
        return this.toBytes(document);
    }

    @Override
    protected void doBeginRecording(Document document) {
        this.setRecordingData(this.takeSnapshot(document));
    }

    @Override
    protected Object doEndRecording(Document document, boolean aborted) {
        if (!aborted) {
            Object copy = this.getRecordingData();
            this.setRecordingData(null);
            if (!this.equals(document, copy)) {
                return copy;
            }
        }
        return null;
    }

    public final boolean equals(Document document, Object recordedData) {
        if (document == null || recordedData == null) {
            return false;
        }
        try (AssertEqualBytesOutputStream outputStream = new AssertEqualBytesOutputStream(this.checkRecordedData(recordedData), new int[]{10, 13, 9, 32});){
            try {
                this.write(document, outputStream);
            }
            catch (AssertionError assertionError) {
                outputStream.close();
                return false;
            }
            catch (Exception e) {
                DTRTvCommonBundle.log(e);
                outputStream.close();
                return false;
            }
        }
        return true;
    }

    @Override
    public final Object apply(Document document, Object recordedData) {
        if (recordedData != null) {
            byte[] bytes = this.checkRecordedData(recordedData);
            Object beforeApplyData = this.takeSnapshot(document);
            this.revertDocument(document, bytes);
            return beforeApplyData;
        }
        return null;
    }

    private byte[] toBytes(Document document) {
        if (document != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                this.write(document, baos);
                return baos.toByteArray();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return EMPTY_DOCUMENT;
    }

    private void write(Document document, OutputStream outputStream) throws Exception {
        this.writePreamble(document, outputStream);
        this.writeContent(this.getTransformer(), document, outputStream);
    }

    private void writePreamble(Document document, OutputStream outputStream) throws IOException {
        byte[] array = new byte[MAGIC_NUMBER.length + 4];
        int destPos = 0;
        System.arraycopy(MAGIC_NUMBER, 0, array, destPos, MAGIC_NUMBER.length);
        String documentURI = document.getDocumentURI();
        if (!DTRTUtil.isEmpty((String)documentURI)) {
            byte[] documentURIBytes = documentURI.getBytes("UTF-8");
            byte[] documentURIBytesLength = this.toBytes(documentURIBytes.length);
            assert (documentURIBytesLength.length == 4);
            System.arraycopy(documentURIBytesLength, 0, array, destPos += MAGIC_NUMBER.length, documentURIBytesLength.length);
            array = Arrays.copyOf(array, array.length + documentURIBytes.length);
            System.arraycopy(documentURIBytes, 0, array, destPos += documentURIBytesLength.length, documentURIBytes.length);
        }
        outputStream.write(array);
    }

    private byte[] toBytes(int integer) {
        return new byte[]{(byte)(integer >>> 24 & 0xFF), (byte)(integer >>> 16 & 0xFF), (byte)(integer >>> 8 & 0xFF), (byte)(integer & 0xFF)};
    }

    protected final boolean writeContent(Transformer transformer, Document document, OutputStream outputStream) throws Exception {
        if (document.getDocumentElement() != null) {
            String xmlEncoding = document.getXmlEncoding();
            String encoding = !DTRTUtil.isEmpty((String)xmlEncoding) ? xmlEncoding : "UTF-8";
            this.writeContent(transformer, document, encoding, outputStream);
            return true;
        }
        return false;
    }

    private void writeContent(Transformer transformer, Document document, String encoding, OutputStream outputStream) throws Exception {
        try {
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(outputStream);
            transformer.setOutputProperty("encoding", encoding);
            transformer.transform(source, result);
        }
        finally {
            outputStream.close();
        }
    }

    protected abstract Transformer getTransformer();

    private byte[] checkRecordedData(Object recordedData) {
        if (recordedData != null && !(recordedData instanceof byte[])) {
            throw new IllegalArgumentException("The record data must be generated by this recorder");
        }
        return (byte[])recordedData;
    }

    private void revertDocument(Document document, byte[] bytes) {
        if (Arrays.equals(EMPTY_DOCUMENT, bytes)) {
            this.clearDocument(document);
        } else if (DocumentBinaryRecorder.isEncodedDocument(bytes)) {
            String documentURI;
            int documentURIBytesLength;
            int position = MAGIC_NUMBER.length;
            if ((documentURIBytesLength = DocumentBinaryRecorder.toInt(bytes[position++], bytes[position++], bytes[position++], bytes[position++])) > 0) {
                byte[] documentURIBytes = new byte[documentURIBytesLength];
                System.arraycopy(bytes, position, documentURIBytes, 0, documentURIBytes.length);
                try {
                    documentURI = new String(documentURIBytes, "UTF-8");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                position += documentURIBytes.length;
            } else {
                documentURI = null;
            }
            if (bytes.length == position) {
                assert (documentURI != null);
                this.clearDocument(document);
                document.setDocumentURI(documentURI);
            } else {
                assert (bytes.length > position);
                byte[] content = new byte[bytes.length - position];
                System.arraycopy(bytes, position, content, 0, content.length);
                Document newDocument = (Document)document.cloneNode(false);
                this.loadContent(this.getTransformer(), newDocument, new ByteArrayInputStream(content));
                Element element = document.getDocumentElement();
                if (element != null) {
                    document.removeChild(element);
                }
                try {
                    document.setXmlStandalone(newDocument.getXmlStandalone());
                }
                catch (DOMException dOMException) {}
                try {
                    document.setXmlVersion(newDocument.getXmlVersion());
                }
                catch (DOMException dOMException) {}
                element = newDocument.getDocumentElement();
                if (element != null) {
                    Node node = document.adoptNode(element);
                    document.appendChild(node);
                }
                if (documentURI != null) {
                    document.setDocumentURI(documentURI);
                }
            }
        } else {
            throw new IllegalArgumentException("Unable to decode the data");
        }
    }

    private void clearDocument(Document document) {
        if (document.getDocumentElement() != null) {
            document.removeChild(document.getDocumentElement());
        }
        if (document.getDocumentURI() != null) {
            document.setDocumentURI(null);
        }
        if (document.getXmlStandalone()) {
            document.setXmlStandalone(false);
        }
        if (document.getXmlVersion() != null) {
            try {
                document.setXmlVersion(null);
            }
            catch (Exception exception) {}
        }
    }

    private static int toInt(byte b1, byte b2, byte b3, byte b4) {
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    private static boolean isEncodedDocument(byte[] bytes) {
        if (bytes.length > MAGIC_NUMBER.length + 4 + 20) {
            int i = 0;
            while (i < MAGIC_NUMBER.length) {
                if (bytes[i] != MAGIC_NUMBER[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected final void loadContent(Transformer transformer, Document document, InputStream inputStream) {
        try {
            try {
                Source source = this.toSource(inputStream);
                DOMResult result = new DOMResult(document);
                transformer.transform(source, result);
            }
            finally {
                inputStream.close();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Source toSource(InputStream inputStream) {
        return new StreamSource(inputStream);
    }
}

